/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.contentstream.operator.state;

import android.util.Log;
import com.tom_roush.pdfbox.contentstream.operator.MissingOperandException;
import com.tom_roush.pdfbox.contentstream.operator.Operator;
import com.tom_roush.pdfbox.contentstream.operator.OperatorProcessor;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSNumber;
import java.util.List;

public class SetLineDashPattern
extends OperatorProcessor {
    @Override
    public void process(Operator operator, List<COSBase> arguments) throws MissingOperandException {
        if (arguments.size() < 2) {
            throw new MissingOperandException(operator, arguments);
        }
        COSBase base0 = arguments.get(0);
        if (!(base0 instanceof COSArray)) {
            return;
        }
        COSBase base1 = arguments.get(1);
        if (!(base1 instanceof COSNumber)) {
            return;
        }
        COSArray dashArray = (COSArray)base0;
        int dashPhase = ((COSNumber)base1).intValue();
        boolean allZero = true;
        for (COSBase base : dashArray) {
            if (base instanceof COSNumber) {
                COSNumber num = (COSNumber)base;
                if (num.floatValue() == 0.0f) continue;
                allZero = false;
                break;
            }
            Log.e((String)"PdfBox-Android", (String)("dash array has non number element " + base + ", ignored"));
            dashArray = new COSArray();
            break;
        }
        if (dashArray.size() > 0 && allZero) {
            Log.e((String)"PdfBox-Android", (String)"dash lengths all zero, ignored");
            dashArray = new COSArray();
        }
        this.context.setLineDashPattern(dashArray, dashPhase);
    }

    @Override
    public String getName() {
        return "d";
    }
}

