/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.ResourceCache;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDFontFactory;
import com.tom_roush.pdfbox.pdmodel.graphics.PDXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDFormXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImageXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import com.tom_roush.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.PDShading;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import java.io.IOException;
import java.util.Collections;

public final class PDResources
implements COSObjectable {
    private final COSDictionary resources;
    private final ResourceCache cache;

    public PDResources() {
        this.resources = new COSDictionary();
        this.cache = null;
    }

    public PDResources(COSDictionary resourceDictionary) {
        if (resourceDictionary == null) {
            throw new IllegalArgumentException("resourceDictionary is null");
        }
        this.resources = resourceDictionary;
        this.cache = null;
    }

    public PDResources(COSDictionary resourceDictionary, ResourceCache resourceCache) {
        if (resourceDictionary == null) {
            throw new IllegalArgumentException("resourceDictionary is null");
        }
        this.resources = resourceDictionary;
        this.cache = resourceCache;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.resources;
    }

    public PDFont getFont(COSName name) throws IOException {
        PDFont cached;
        COSObject indirect = this.getIndirect(COSName.FONT, name);
        if (this.cache != null && indirect != null && (cached = this.cache.getFont(indirect)) != null) {
            return cached;
        }
        PDFont font = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.FONT, name);
        if (dict != null) {
            font = PDFontFactory.createFont(dict);
        }
        if (this.cache != null) {
            this.cache.put(indirect, font);
        }
        return font;
    }

    public PDColorSpace getColorSpace(COSName name) throws IOException {
        return this.getColorSpace(name, false);
    }

    public PDColorSpace getColorSpace(COSName name, boolean wasDefault) throws IOException {
        PDColorSpace cached;
        COSObject indirect = this.getIndirect(COSName.FONT, name);
        if (this.cache != null && indirect != null && (cached = this.cache.getColorSpace(indirect)) != null) {
            return cached;
        }
        COSBase object = this.get(COSName.COLORSPACE, name);
        PDColorSpace colorSpace = object != null ? PDColorSpace.create(object, this, wasDefault) : PDColorSpace.create(name, this, wasDefault);
        if (this.cache != null) {
            this.cache.put(indirect, colorSpace);
        }
        return colorSpace;
    }

    public boolean hasColorSpace(COSName name) {
        return this.get(COSName.COLORSPACE, name) != null;
    }

    public PDExtendedGraphicsState getExtGState(COSName name) {
        PDExtendedGraphicsState cached;
        COSObject indirect = this.getIndirect(COSName.EXT_G_STATE, name);
        if (this.cache != null && indirect != null && (cached = this.cache.getExtGState(indirect)) != null) {
            return cached;
        }
        PDExtendedGraphicsState extGState = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.EXT_G_STATE, name);
        if (dict != null) {
            extGState = new PDExtendedGraphicsState(dict);
        }
        if (this.cache != null) {
            this.cache.put(indirect, extGState);
        }
        return extGState;
    }

    public PDShading getShading(COSName name) throws IOException {
        PDShading cached;
        COSObject indirect = this.getIndirect(COSName.SHADING, name);
        if (this.cache != null && indirect != null && (cached = this.cache.getShading(indirect)) != null) {
            return cached;
        }
        PDShading shading = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.SHADING, name);
        if (dict != null) {
            shading = PDShading.create(dict);
        }
        if (this.cache != null) {
            this.cache.put(indirect, shading);
        }
        return shading;
    }

    public PDAbstractPattern getPattern(COSName name) throws IOException {
        PDAbstractPattern cached;
        COSObject indirect = this.getIndirect(COSName.PATTERN, name);
        if (this.cache != null && indirect != null && (cached = this.cache.getPattern(indirect)) != null) {
            return cached;
        }
        PDAbstractPattern pattern = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.PATTERN, name);
        if (dict != null) {
            pattern = PDAbstractPattern.create(dict);
        }
        if (this.cache != null) {
            this.cache.put(indirect, pattern);
        }
        return pattern;
    }

    public PDPropertyList getProperties(COSName name) {
        PDPropertyList cached;
        COSObject indirect = this.getIndirect(COSName.PROPERTIES, name);
        if (this.cache != null && indirect != null && (cached = this.cache.getProperties(indirect)) != null) {
            return cached;
        }
        PDPropertyList propertyList = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.PROPERTIES, name);
        if (dict != null) {
            propertyList = PDPropertyList.create(dict);
        }
        if (this.cache != null) {
            this.cache.put(indirect, propertyList);
        }
        return propertyList;
    }

    public boolean isImageXObject(COSName name) {
        COSBase value = this.get(COSName.XOBJECT, name);
        if (value == null) {
            return false;
        }
        if (value instanceof COSObject) {
            value = ((COSObject)value).getObject();
        }
        if (!(value instanceof COSStream)) {
            return false;
        }
        COSStream stream = (COSStream)value;
        return COSName.IMAGE.equals(stream.getCOSName(COSName.SUBTYPE));
    }

    public PDXObject getXObject(COSName name) throws IOException {
        PDXObject cached;
        COSObject indirect = this.getIndirect(COSName.XOBJECT, name);
        if (this.cache != null && indirect != null && (cached = this.cache.getXObject(indirect)) != null) {
            return cached;
        }
        COSBase value = this.get(COSName.XOBJECT, name);
        PDXObject xobject = value == null ? null : (value instanceof COSObject ? PDXObject.createXObject(((COSObject)value).getObject(), this) : PDXObject.createXObject(value, this));
        if (this.cache != null && !(xobject instanceof PDImageXObject)) {
            this.cache.put(indirect, xobject);
        }
        return xobject;
    }

    private COSObject getIndirect(COSName kind, COSName name) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return null;
        }
        COSBase base = dict.getItem(name);
        if (base instanceof COSObject) {
            return (COSObject)base;
        }
        return null;
    }

    private COSBase get(COSName kind, COSName name) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return null;
        }
        return dict.getDictionaryObject(name);
    }

    public Iterable<COSName> getColorSpaceNames() {
        return this.getNames(COSName.COLORSPACE);
    }

    public Iterable<COSName> getXObjectNames() {
        return this.getNames(COSName.XOBJECT);
    }

    public Iterable<COSName> getFontNames() {
        return this.getNames(COSName.FONT);
    }

    public Iterable<COSName> getPropertiesNames() {
        return this.getNames(COSName.PROPERTIES);
    }

    public Iterable<COSName> getShadingNames() {
        return this.getNames(COSName.SHADING);
    }

    public Iterable<COSName> getPatternNames() {
        return this.getNames(COSName.PATTERN);
    }

    public Iterable<COSName> getExtGStateNames() {
        return this.getNames(COSName.EXT_G_STATE);
    }

    private Iterable<COSName> getNames(COSName kind) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return Collections.emptySet();
        }
        return dict.keySet();
    }

    public COSName add(PDFont font) {
        return this.add(COSName.FONT, "F", font);
    }

    public COSName add(PDColorSpace colorSpace) {
        return this.add(COSName.COLORSPACE, "cs", colorSpace);
    }

    public COSName add(PDExtendedGraphicsState extGState) {
        return this.add(COSName.EXT_G_STATE, "gs", extGState);
    }

    public COSName add(PDShading shading) {
        return this.add(COSName.SHADING, "sh", shading);
    }

    public COSName add(PDAbstractPattern pattern) {
        return this.add(COSName.PATTERN, "p", pattern);
    }

    public COSName add(PDPropertyList properties) {
        if (properties instanceof PDOptionalContentGroup) {
            return this.add(COSName.PROPERTIES, "oc", properties);
        }
        return this.add(COSName.PROPERTIES, "Prop", properties);
    }

    public COSName add(PDImageXObject image) {
        return this.add(COSName.XOBJECT, "Im", image);
    }

    public COSName add(PDFormXObject form) {
        return this.add(COSName.XOBJECT, "Form", form);
    }

    public COSName add(PDXObject xobject, String prefix) {
        return this.add(COSName.XOBJECT, prefix, xobject);
    }

    private COSName add(COSName kind, String prefix, COSObjectable object) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict != null && dict.containsValue(object.getCOSObject())) {
            return dict.getKeyForValue(object.getCOSObject());
        }
        COSName name = this.createKey(kind, prefix);
        this.put(kind, name, object);
        return name;
    }

    private COSName createKey(COSName kind, String prefix) {
        String key;
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return COSName.getPDFName(prefix + 1);
        }
        int n = dict.keySet().size();
        while (dict.containsKey(key = prefix + ++n)) {
        }
        return COSName.getPDFName(key);
    }

    private void put(COSName kind, COSName name, COSObjectable object) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            dict = new COSDictionary();
            this.resources.setItem(kind, (COSBase)dict);
        }
        dict.setItem(name, object);
    }

    public void put(COSName name, PDFont font) {
        this.put(COSName.FONT, name, font);
    }

    public void put(COSName name, PDColorSpace colorSpace) {
        this.put(COSName.COLORSPACE, name, colorSpace);
    }

    public void put(COSName name, PDExtendedGraphicsState extGState) {
        this.put(COSName.EXT_G_STATE, name, extGState);
    }

    public void put(COSName name, PDShading shading) {
        this.put(COSName.SHADING, name, shading);
    }

    public void put(COSName name, PDAbstractPattern pattern) {
        this.put(COSName.PATTERN, name, pattern);
    }

    public void put(COSName name, PDPropertyList properties) {
        this.put(COSName.PROPERTIES, name, properties);
    }

    public void put(COSName name, PDXObject xobject) {
        this.put(COSName.XOBJECT, name, xobject);
    }

    public ResourceCache getResourceCache() {
        return this.cache;
    }
}

