/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.visible;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PDVisibleSignDesigner {
    private Float imageWidth;
    private Float imageHeight;
    private float xAxis;
    private float yAxis;
    private float pageHeight;
    private float pageWidth;
    private Bitmap image;
    private String signatureFieldName = "sig";
    private byte[] formatterRectangleParams = new byte[]{0, 0, 100, 50};
    private byte[] AffineTransformParams = new byte[]{1, 0, 0, 1, 0, 0};
    private float imageSizeInPercents;

    public PDVisibleSignDesigner(String filename, InputStream imageStream, int page) throws IOException {
        this.readImageStream(imageStream);
        this.calculatePageSizeFromFile(filename, page);
    }

    public PDVisibleSignDesigner(InputStream documentStream, InputStream imageStream, int page) throws IOException {
        this.readImageStream(imageStream);
        this.calculatePageSizeFromStream(documentStream, page);
    }

    public PDVisibleSignDesigner(PDDocument document, InputStream imageStream, int page) throws IOException {
        this.readImageStream(imageStream);
        this.calculatePageSize(document, page);
    }

    public PDVisibleSignDesigner(String filename, Bitmap image, int page) throws IOException {
        this.setImage(image);
        this.calculatePageSizeFromFile(filename, page);
    }

    public PDVisibleSignDesigner(InputStream documentStream, Bitmap image, int page) throws IOException {
        this.setImage(image);
        this.calculatePageSizeFromStream(documentStream, page);
    }

    public PDVisibleSignDesigner(PDDocument document, Bitmap image, int page) {
        this.setImage(image);
        this.calculatePageSize(document, page);
    }

    private void calculatePageSizeFromFile(String filename, int page) throws IOException {
        PDDocument document = PDDocument.load(new File(filename));
        this.calculatePageSize(document, page);
        document.close();
    }

    private void calculatePageSizeFromStream(InputStream documentStream, int page) throws IOException {
        PDDocument document = PDDocument.load(documentStream);
        this.calculatePageSize(document, page);
        document.close();
    }

    private void calculatePageSize(PDDocument document, int page) {
        if (page < 1) {
            throw new IllegalArgumentException("First page of pdf is 1, not " + page);
        }
        PDPage firstPage = document.getPage(page - 1);
        PDRectangle mediaBox = firstPage.getMediaBox();
        this.pageHeight(mediaBox.getHeight());
        float x = this.pageWidth = mediaBox.getWidth();
        float y = 0.0f;
        this.pageWidth += y;
        float tPercent = 100.0f * y / (x + y);
        this.imageSizeInPercents = 100.0f - tPercent;
    }

    public PDVisibleSignDesigner signatureImage(String path) throws IOException {
        FileInputStream fin = new FileInputStream(path);
        this.readImageStream(fin);
        return this;
    }

    public PDVisibleSignDesigner zoom(float percent) {
        this.imageHeight = Float.valueOf(this.imageHeight.floatValue() + this.imageHeight.floatValue() * percent / 100.0f);
        this.imageWidth = Float.valueOf(this.imageWidth.floatValue() + this.imageWidth.floatValue() * percent / 100.0f);
        return this;
    }

    public PDVisibleSignDesigner coordinates(float x, float y) {
        this.xAxis(x);
        this.yAxis(y);
        return this;
    }

    public float getxAxis() {
        return this.xAxis;
    }

    public PDVisibleSignDesigner xAxis(float xAxis) {
        this.xAxis = xAxis;
        return this;
    }

    public float getyAxis() {
        return this.yAxis;
    }

    public PDVisibleSignDesigner yAxis(float yAxis) {
        this.yAxis = yAxis;
        return this;
    }

    public float getWidth() {
        return this.imageWidth.floatValue();
    }

    public PDVisibleSignDesigner width(float width) {
        this.imageWidth = Float.valueOf(width);
        return this;
    }

    public float getHeight() {
        return this.imageHeight.floatValue();
    }

    public PDVisibleSignDesigner height(float height) {
        this.imageHeight = Float.valueOf(height);
        return this;
    }

    protected float getTemplateHeight() {
        return this.getPageHeight();
    }

    private PDVisibleSignDesigner pageHeight(float templateHeight) {
        this.pageHeight = templateHeight;
        return this;
    }

    public String getSignatureFieldName() {
        return this.signatureFieldName;
    }

    public PDVisibleSignDesigner signatureFieldName(String signatureFieldName) {
        this.signatureFieldName = signatureFieldName;
        return this;
    }

    public Bitmap getImage() {
        return this.image;
    }

    private void readImageStream(InputStream stream) throws IOException {
        this.setImage(BitmapFactory.decodeStream((InputStream)stream));
    }

    private void setImage(Bitmap image) {
        this.image = image;
        this.imageHeight = Float.valueOf(image.getHeight());
        this.imageWidth = Float.valueOf(image.getWidth());
    }

    public byte[] getAffineTransformParams() {
        return this.AffineTransformParams;
    }

    public PDVisibleSignDesigner affineTransformParams(byte[] affineTransformParams) {
        this.AffineTransformParams = affineTransformParams;
        return this;
    }

    public byte[] getFormatterRectangleParams() {
        return this.formatterRectangleParams;
    }

    public PDVisibleSignDesigner formatterRectangleParams(byte[] formatterRectangleParams) {
        this.formatterRectangleParams = formatterRectangleParams;
        return this;
    }

    public float getPageWidth() {
        return this.pageWidth;
    }

    public PDVisibleSignDesigner pageWidth(float pageWidth) {
        this.pageWidth = pageWidth;
        return this;
    }

    public float getPageHeight() {
        return this.pageHeight;
    }

    public float getImageSizeInPercents() {
        return this.imageSizeInPercents;
    }

    public void imageSizeInPercents(float imageSizeInPercents) {
        this.imageSizeInPercents = imageSizeInPercents;
    }

    public String getSignatureText() {
        throw new UnsupportedOperationException("That method is not yet implemented");
    }

    public PDVisibleSignDesigner signatureText(String signatureText) {
        throw new UnsupportedOperationException("That method is not yet implemented");
    }
}

