/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.ResourceCache;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType0;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType2;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDMMType1Font;
import com.tom_roush.pdfbox.pdmodel.font.PDTrueTypeFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType0Font;
import com.tom_roush.pdfbox.pdmodel.font.PDType1CFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType1Font;
import com.tom_roush.pdfbox.pdmodel.font.PDType3Font;
import java.io.IOException;

public final class PDFontFactory {
    private PDFontFactory() {
    }

    public static PDFont createFont(COSDictionary dictionary) throws IOException {
        return PDFontFactory.createFont(dictionary, null);
    }

    public static PDFont createFont(COSDictionary dictionary, ResourceCache resourceCache) throws IOException {
        COSName subType;
        COSName type = dictionary.getCOSName(COSName.TYPE, COSName.FONT);
        if (!COSName.FONT.equals(type)) {
            Log.e((String)"PdfBox-Android", (String)("Expected 'Font' dictionary but found '" + type.getName() + "'"));
        }
        if (COSName.TYPE1.equals(subType = dictionary.getCOSName(COSName.SUBTYPE))) {
            COSBase fd = dictionary.getDictionaryObject(COSName.FONT_DESC);
            if (fd instanceof COSDictionary && ((COSDictionary)fd).containsKey(COSName.FONT_FILE3)) {
                return new PDType1CFont(dictionary);
            }
            return new PDType1Font(dictionary);
        }
        if (COSName.MM_TYPE1.equals(subType)) {
            COSBase fd = dictionary.getDictionaryObject(COSName.FONT_DESC);
            if (fd instanceof COSDictionary && ((COSDictionary)fd).containsKey(COSName.FONT_FILE3)) {
                return new PDType1CFont(dictionary);
            }
            return new PDMMType1Font(dictionary);
        }
        if (COSName.TRUE_TYPE.equals(subType)) {
            return new PDTrueTypeFont(dictionary);
        }
        if (COSName.TYPE3.equals(subType)) {
            return new PDType3Font(dictionary, resourceCache);
        }
        if (COSName.TYPE0.equals(subType)) {
            return new PDType0Font(dictionary);
        }
        if (COSName.CID_FONT_TYPE0.equals(subType)) {
            throw new IllegalArgumentException("Type 0 descendant font not allowed");
        }
        if (COSName.CID_FONT_TYPE2.equals(subType)) {
            throw new IllegalArgumentException("Type 2 descendant font not allowed");
        }
        Log.w((String)"PdfBox-Android", (String)("Invalid font subtype '" + subType + "'"));
        return new PDType1Font(dictionary);
    }

    static PDCIDFont createDescendantFont(COSDictionary dictionary, PDType0Font parent) throws IOException {
        COSName type = dictionary.getCOSName(COSName.TYPE, COSName.FONT);
        if (!COSName.FONT.equals(type)) {
            throw new IllegalArgumentException("Expected 'Font' dictionary but found '" + type.getName() + "'");
        }
        COSName subType = dictionary.getCOSName(COSName.SUBTYPE);
        if (COSName.CID_FONT_TYPE0.equals(subType)) {
            return new PDCIDFontType0(dictionary, parent);
        }
        if (COSName.CID_FONT_TYPE2.equals(subType)) {
            return new PDCIDFontType2(dictionary, parent);
        }
        throw new IOException("Invalid font type: " + type);
    }

    @Deprecated
    public static PDFont createDefaultFont() throws IOException {
        return PDType1Font.HELVETICA;
    }
}

