/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.PDAppearanceContentStream;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers.PDAbstractAppearanceHandler;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;

public class PDCaretAppearanceHandler
extends PDAbstractAppearanceHandler {
    public PDCaretAppearanceHandler(PDAnnotation annotation) {
        super(annotation);
    }

    public PDCaretAppearanceHandler(PDAnnotation annotation, PDDocument document) {
        super(annotation, document);
    }

    @Override
    public void generateAppearanceStreams() {
        this.generateNormalAppearance();
        this.generateRolloverAppearance();
        this.generateDownAppearance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateNormalAppearance() {
        PDAnnotationMarkup annotation = (PDAnnotationMarkup)this.getAnnotation();
        PDAppearanceContentStream contentStream = null;
        try {
            contentStream = this.getNormalAppearanceAsContentStream();
            contentStream.setStrokingColor(this.getColor());
            contentStream.setNonStrokingColor(this.getColor());
            this.setOpacity(contentStream, annotation.getConstantOpacity());
            PDRectangle rect = this.getRectangle();
            PDRectangle bbox = new PDRectangle(rect.getWidth(), rect.getHeight());
            if (!annotation.getCOSObject().containsKey(COSName.RD)) {
                float rd = Math.min(rect.getHeight() / 10.0f, 5.0f);
                annotation.setRectDifferences(rd);
                bbox = new PDRectangle(-rd, -rd, rect.getWidth() + 2.0f * rd, rect.getHeight() + 2.0f * rd);
                Matrix matrix = annotation.getNormalAppearanceStream().getMatrix();
                matrix.transformPoint(rd, rd);
                annotation.getNormalAppearanceStream().setMatrix(matrix.createAffineTransform());
                PDRectangle rect2 = new PDRectangle(rect.getLowerLeftX() - rd, rect.getLowerLeftY() - rd, rect.getWidth() + 2.0f * rd, rect.getHeight() + 2.0f * rd);
                annotation.setRectangle(rect2);
            }
            annotation.getNormalAppearanceStream().setBBox(bbox);
            float halfX = rect.getWidth() / 2.0f;
            float halfY = rect.getHeight() / 2.0f;
            contentStream.moveTo(0.0f, 0.0f);
            contentStream.curveTo(halfX, 0.0f, halfX, halfY, halfX, rect.getHeight());
            contentStream.curveTo(halfX, halfY, halfX, 0.0f, rect.getWidth(), 0.0f);
            contentStream.closePath();
            contentStream.fill();
        }
        catch (IOException e) {
            Log.e((String)"PdfBox-Android", (String)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(contentStream);
        }
    }

    @Override
    public void generateRolloverAppearance() {
    }

    @Override
    public void generateDownAppearance() {
    }
}

