/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.text;

import android.graphics.RectF;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.text.PDFTextStripper;
import com.tom_roush.pdfbox.text.TextPosition;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFTextStripperByArea
extends PDFTextStripper {
    private final List<String> regions = new ArrayList<String>();
    private final Map<String, RectF> regionArea = new HashMap<String, RectF>();
    private final Map<String, ArrayList<List<TextPosition>>> regionCharacterList = new HashMap<String, ArrayList<List<TextPosition>>>();
    private final Map<String, StringWriter> regionText = new HashMap<String, StringWriter>();

    public PDFTextStripperByArea() throws IOException {
        super.setShouldSeparateByBeads(false);
    }

    @Override
    public final void setShouldSeparateByBeads(boolean aShouldSeparateByBeads) {
    }

    public void addRegion(String regionName, RectF rect) {
        this.regions.add(regionName);
        this.regionArea.put(regionName, rect);
    }

    public void removeRegion(String regionName) {
        this.regions.remove(regionName);
        this.regionArea.remove(regionName);
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public String getTextForRegion(String regionName) {
        StringWriter text = this.regionText.get(regionName);
        return text.toString();
    }

    public void extractRegions(PDPage page) throws IOException {
        for (String region : this.regions) {
            this.setStartPage(this.getCurrentPageNo());
            this.setEndPage(this.getCurrentPageNo());
            String regionName = region;
            ArrayList regionCharactersByArticle = new ArrayList();
            regionCharactersByArticle.add(new ArrayList());
            this.regionCharacterList.put(regionName, regionCharactersByArticle);
            this.regionText.put(regionName, new StringWriter());
        }
        if (page.hasContents()) {
            this.processPage(page);
        }
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        for (Map.Entry<String, RectF> regionAreaEntry : this.regionArea.entrySet()) {
            RectF rect = regionAreaEntry.getValue();
            if (!rect.contains(text.getX(), text.getY())) continue;
            this.charactersByArticle = this.regionCharacterList.get(regionAreaEntry.getKey());
            super.processTextPosition(text);
        }
    }

    @Override
    protected void writePage() throws IOException {
        for (String region : this.regionArea.keySet()) {
            this.charactersByArticle = this.regionCharacterList.get(region);
            this.output = this.regionText.get(region);
            super.writePage();
        }
    }
}

