/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.ttf;

import com.tom_roush.fontbox.cff.CFFFont;
import com.tom_roush.fontbox.cff.CFFParser;
import com.tom_roush.fontbox.ttf.TTFDataStream;
import com.tom_roush.fontbox.ttf.TTFTable;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import java.io.IOException;

public class CFFTable
extends TTFTable {
    public static final String TAG = "CFF ";
    private CFFFont cffFont;

    CFFTable(TrueTypeFont font) {
        super(font);
    }

    @Override
    void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        byte[] bytes = data.read((int)this.getLength());
        CFFParser parser = new CFFParser();
        this.cffFont = parser.parse(bytes, new CFFBytesource(this.font)).get(0);
        this.initialized = true;
    }

    public CFFFont getFont() {
        return this.cffFont;
    }

    private static class CFFBytesource
    implements CFFParser.ByteSource {
        private final TrueTypeFont ttf;

        CFFBytesource(TrueTypeFont ttf) {
            this.ttf = ttf;
        }

        @Override
        public byte[] getBytes() throws IOException {
            return this.ttf.getTableBytes(this.ttf.getTableMap().get(CFFTable.TAG));
        }
    }
}

