/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.ttf;

import com.tom_roush.fontbox.ttf.CmapLookup;
import com.tom_roush.fontbox.ttf.CmapSubtable;
import com.tom_roush.fontbox.ttf.GlyphSubstitutionTable;
import com.tom_roush.fontbox.ttf.OpenTypeScript;
import java.util.List;

public class SubstitutingCmapLookup
implements CmapLookup {
    private final CmapSubtable cmap;
    private final GlyphSubstitutionTable gsub;
    private final List<String> enabledFeatures;

    public SubstitutingCmapLookup(CmapSubtable cmap, GlyphSubstitutionTable gsub, List<String> enabledFeatures) {
        this.cmap = cmap;
        this.gsub = gsub;
        this.enabledFeatures = enabledFeatures;
    }

    @Override
    public int getGlyphId(int characterCode) {
        int gid = this.cmap.getGlyphId(characterCode);
        String[] scriptTags = OpenTypeScript.getScriptTags(characterCode);
        return this.gsub.getSubstitution(gid, scriptTags, this.enabledFeatures);
    }

    @Override
    public List<Integer> getCharCodes(int gid) {
        return this.cmap.getCharCodes(this.gsub.getUnsubstitution(gid));
    }
}

