/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.fixup.processor;

import android.util.Log;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.fixup.processor.AbstractProcessor;
import com.tom_roush.pdfbox.pdmodel.font.FontMapper;
import com.tom_roush.pdfbox.pdmodel.font.FontMappers;
import com.tom_roush.pdfbox.pdmodel.font.FontMapping;
import com.tom_roush.pdfbox.pdmodel.font.PDType0Font;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDFieldFactory;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDVariableText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AcroFormOrphanWidgetsProcessor
extends AbstractProcessor {
    public AcroFormOrphanWidgetsProcessor(PDDocument document) {
        super(document);
    }

    @Override
    public void process() {
        PDAcroForm acroForm = this.document.getDocumentCatalog().getAcroForm(null);
        if (acroForm != null) {
            this.resolveFieldsFromWidgets(acroForm);
        }
    }

    private void resolveFieldsFromWidgets(PDAcroForm acroForm) {
        HashMap<String, PDField> nonTerminalFieldsMap = new HashMap<String, PDField>();
        Log.d((String)"PdfBox-Android", (String)"rebuilding fields from widgets");
        ArrayList<PDField> fields = new ArrayList<PDField>();
        for (PDPage page : this.document.getPages()) {
            try {
                this.handleAnnotations(acroForm, fields, page.getAnnotations(), nonTerminalFieldsMap);
            }
            catch (IOException ioe) {
                Log.d((String)"PdfBox-Android", (String)("couldn't read annotations for page " + ioe.getMessage()));
            }
        }
        acroForm.setFields(fields);
        for (PDField field : acroForm.getFieldTree()) {
            if (!(field instanceof PDVariableText)) continue;
            this.ensureFontResources(acroForm.getDefaultResources(), (PDVariableText)field);
        }
    }

    private void handleAnnotations(PDAcroForm acroForm, List<PDField> fields, List<PDAnnotation> annotations, Map<String, PDField> nonTerminalFieldsMap) {
        PDResources acroFormResources = acroForm.getDefaultResources();
        for (PDAnnotation annot : annotations) {
            if (!(annot instanceof PDAnnotationWidget)) continue;
            this.addFontFromWidget(acroFormResources, annot);
            COSDictionary parent = annot.getCOSObject().getCOSDictionary(COSName.PARENT);
            if (parent != null) {
                PDField resolvedField = this.resolveNonRootField(acroForm, (PDAnnotationWidget)annot, nonTerminalFieldsMap);
                if (resolvedField == null) continue;
                fields.add(resolvedField);
                continue;
            }
            fields.add(PDFieldFactory.createField(acroForm, annot.getCOSObject(), null));
        }
    }

    private void addFontFromWidget(PDResources acroFormResources, PDAnnotation annotation) {
        PDAppearanceStream normalAppearanceStream = annotation.getNormalAppearanceStream();
        if (normalAppearanceStream != null && normalAppearanceStream.getResources() != null) {
            PDResources widgetResources = normalAppearanceStream.getResources();
            for (COSName fontName : widgetResources.getFontNames()) {
                if (!fontName.getName().startsWith("+")) {
                    try {
                        if (acroFormResources.getFont(fontName) != null) continue;
                        acroFormResources.put(fontName, widgetResources.getFont(fontName));
                        Log.d((String)"PdfBox-Android", (String)("qdded font resource to AcroForm from widget for font name " + fontName.getName()));
                    }
                    catch (IOException ioe) {
                        Log.d((String)"PdfBox-Android", (String)("unable to add font to AcroForm for font name " + fontName.getName()));
                    }
                    continue;
                }
                Log.d((String)"PdfBox-Android", (String)("font resource for widget was a subsetted font - ignored: " + fontName.getName()));
            }
        }
    }

    private PDField resolveNonRootField(PDAcroForm acroForm, PDAnnotationWidget widget, Map<String, PDField> nonTerminalFieldsMap) {
        COSDictionary parent = widget.getCOSObject().getCOSDictionary(COSName.PARENT);
        while (parent.containsKey(COSName.PARENT)) {
            if ((parent = parent.getCOSDictionary(COSName.PARENT)) != null) continue;
            return null;
        }
        if (nonTerminalFieldsMap.get(parent.getString(COSName.T)) == null) {
            PDField field = PDFieldFactory.createField(acroForm, parent, null);
            nonTerminalFieldsMap.put(field.getFullyQualifiedName(), field);
            return field;
        }
        return null;
    }

    private void ensureFontResources(PDResources defaultResources, PDVariableText field) {
        String daString = field.getDefaultAppearance();
        if (daString.startsWith("/") && daString.length() > 1) {
            COSName fontName = COSName.getPDFName(daString.substring(1, daString.indexOf(" ")));
            try {
                if (defaultResources != null && defaultResources.getFont(fontName) == null) {
                    Log.d((String)"PdfBox-Android", (String)("trying to add missing font resource for field " + field.getFullyQualifiedName()));
                    FontMapper mapper = FontMappers.instance();
                    FontMapping<TrueTypeFont> fontMapping = mapper.getTrueTypeFont(fontName.getName(), null);
                    if (fontMapping != null) {
                        PDType0Font pdFont = PDType0Font.load(this.document, fontMapping.getFont(), false);
                        Log.d((String)"PdfBox-Android", (String)("looked up font for " + fontName.getName() + " - found " + fontMapping.getFont().getName()));
                        defaultResources.put(fontName, pdFont);
                    } else {
                        Log.d((String)"PdfBox-Android", (String)("no suitable font found for field " + field.getFullyQualifiedName() + " for font name " + fontName.getName()));
                    }
                }
            }
            catch (IOException ioe) {
                Log.d((String)"PdfBox-Android", (String)("Unable to handle font resources for field " + field.getFullyQualifiedName() + ": " + ioe.getMessage()));
            }
        }
    }
}

