/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font;

import android.util.Log;
import com.tom_roush.fontbox.FontBoxFont;
import com.tom_roush.fontbox.cff.CFFCIDFont;
import com.tom_roush.fontbox.cff.CFFFont;
import com.tom_roush.fontbox.ttf.NamingTable;
import com.tom_roush.fontbox.ttf.OS2WindowsMetricsTable;
import com.tom_roush.fontbox.ttf.OTFParser;
import com.tom_roush.fontbox.ttf.OpenTypeFont;
import com.tom_roush.fontbox.ttf.TTFParser;
import com.tom_roush.fontbox.ttf.TrueTypeCollection;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import com.tom_roush.fontbox.type1.Type1Font;
import com.tom_roush.fontbox.util.autodetect.FontFileFinder;
import com.tom_roush.pdfbox.android.PDFBoxConfig;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.font.CIDSystemInfo;
import com.tom_roush.pdfbox.pdmodel.font.FontCache;
import com.tom_roush.pdfbox.pdmodel.font.FontFormat;
import com.tom_roush.pdfbox.pdmodel.font.FontInfo;
import com.tom_roush.pdfbox.pdmodel.font.FontProvider;
import com.tom_roush.pdfbox.pdmodel.font.PDPanoseClassification;
import com.tom_roush.pdfbox.util.Charsets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

final class FileSystemFontProvider
extends FontProvider {
    private final List<FSFontInfo> fontInfoList = new ArrayList<FSFontInfo>();
    private final FontCache cache;

    FileSystemFontProvider(FontCache cache) {
        this.cache = cache;
        if (PDFBoxConfig.getFontLoadLevel() == PDFBoxConfig.FontLoadLevel.NONE) {
            return;
        }
        if (PDFBoxConfig.getFontLoadLevel() == PDFBoxConfig.FontLoadLevel.MINIMUM) {
            try {
                this.addTrueTypeFont(new File("/system/fonts/DroidSans.ttf"));
                this.addTrueTypeFont(new File("/system/fonts/DroidSans-Bold.ttf"));
                this.addTrueTypeFont(new File("/system/fonts/DroidSansMono.ttf"));
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            List<FSFontInfo> cachedInfos;
            if (PDFBoxConfig.isDebugEnabled()) {
                Log.d((String)"PdfBox-Android", (String)"Will search the local system for fonts");
            }
            FontFileFinder fontFileFinder = new FontFileFinder();
            List<URI> fonts = fontFileFinder.find();
            ArrayList<File> files = new ArrayList<File>(fonts.size());
            for (URI font : fonts) {
                files.add(new File(font));
            }
            if (PDFBoxConfig.isDebugEnabled()) {
                Log.d((String)"PdfBox-Android", (String)("Found " + files.size() + " fonts on the local system"));
            }
            if ((cachedInfos = this.loadDiskCache(files)) != null && !cachedInfos.isEmpty()) {
                this.fontInfoList.addAll(cachedInfos);
            } else {
                Log.w((String)"PdfBox-Android", (String)"Building on-disk font cache, this may take a while");
                this.scanFonts(files);
                this.saveDiskCache();
                Log.w((String)"PdfBox-Android", (String)("Finished building on-disk font cache, found " + this.fontInfoList.size() + " fonts"));
            }
        }
        catch (AccessControlException e) {
            Log.e((String)"PdfBox-Android", (String)"Error accessing the file system", (Throwable)e);
        }
    }

    private void scanFonts(List<File> files) {
        for (File file : files) {
            try {
                String filePath = file.getPath().toLowerCase();
                if (filePath.endsWith(".ttf") || filePath.endsWith(".otf")) {
                    this.addTrueTypeFont(file);
                    continue;
                }
                if (filePath.endsWith(".ttc") || filePath.endsWith(".otc")) {
                    this.addTrueTypeCollection(file);
                    continue;
                }
                if (!filePath.endsWith(".pfb")) continue;
                this.addType1Font(file);
            }
            catch (IOException e) {
                Log.e((String)"PdfBox-Android", (String)("Error parsing font " + file.getPath()), (Throwable)e);
            }
        }
    }

    private File getDiskCacheFile() {
        String path = System.getProperty("pdfbox.fontcache");
        if (!(path != null && new File(path).isDirectory() && new File(path).canWrite() || (path = System.getProperty("user.home")) != null && new File(path).isDirectory() && new File(path).canWrite())) {
            path = System.getProperty("java.io.tmpdir");
        }
        return new File(path, ".pdfbox.cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDiskCache() {
        BufferedWriter writer = null;
        try {
            File file = this.getDiskCacheFile();
            writer = new BufferedWriter(new FileWriter(file));
        }
        catch (SecurityException e) {
            IOUtils.closeQuietly(writer);
            return;
        }
        try {
            for (FSFontInfo fontInfo : this.fontInfoList) {
                writer.write(fontInfo.postScriptName.trim());
                writer.write("|");
                writer.write(fontInfo.format.toString());
                writer.write("|");
                if (fontInfo.cidSystemInfo != null) {
                    writer.write(fontInfo.cidSystemInfo.getRegistry() + '-' + fontInfo.cidSystemInfo.getOrdering() + '-' + fontInfo.cidSystemInfo.getSupplement());
                }
                writer.write("|");
                if (fontInfo.usWeightClass > -1) {
                    writer.write(Integer.toHexString(fontInfo.usWeightClass));
                }
                writer.write("|");
                if (fontInfo.sFamilyClass > -1) {
                    writer.write(Integer.toHexString(fontInfo.sFamilyClass));
                }
                writer.write("|");
                writer.write(Integer.toHexString(fontInfo.ulCodePageRange1));
                writer.write("|");
                writer.write(Integer.toHexString(fontInfo.ulCodePageRange2));
                writer.write("|");
                if (fontInfo.macStyle > -1) {
                    writer.write(Integer.toHexString(fontInfo.macStyle));
                }
                writer.write("|");
                if (fontInfo.panose != null) {
                    byte[] bytes = fontInfo.panose.getBytes();
                    for (int i = 0; i < 10; ++i) {
                        String str = Integer.toHexString(bytes[i]);
                        if (str.length() == 1) {
                            writer.write(48);
                        }
                        writer.write(str);
                    }
                }
                writer.write("|");
                writer.write(fontInfo.file.getAbsolutePath());
                writer.newLine();
            }
        }
        catch (IOException e) {
            try {
                Log.w((String)"PdfBox-Android", (String)"Could not write to font cache", (Throwable)e);
                Log.w((String)"PdfBox-Android", (String)"Installed fonts information will have to be reloaded for each start");
                Log.w((String)"PdfBox-Android", (String)"You can assign a directory to the 'pdfbox.fontcache' property");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }
        IOUtils.closeQuietly(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FSFontInfo> loadDiskCache(List<File> files) {
        File file2;
        HashSet<String> pending = new HashSet<String>(files.size());
        for (File file2 : files) {
            pending.add(file2.getAbsolutePath());
        }
        ArrayList<FSFontInfo> results = new ArrayList<FSFontInfo>();
        file2 = null;
        boolean fileExists = false;
        try {
            file2 = this.getDiskCacheFile();
            fileExists = file2.exists();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (fileExists) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file2));
                while ((line = reader.readLine()) != null) {
                    File fontFile;
                    String[] parts = line.split("\\|", 10);
                    if (parts.length < 10) {
                        Log.e((String)"PdfBox-Android", (String)("Incorrect line '" + line + "' in font disk cache is skipped"));
                        continue;
                    }
                    CIDSystemInfo cidSystemInfo = null;
                    int usWeightClass = -1;
                    int sFamilyClass = -1;
                    int macStyle = -1;
                    byte[] panose = null;
                    String postScriptName = parts[0];
                    FontFormat format = FontFormat.valueOf(parts[1]);
                    if (parts[2].length() > 0) {
                        String[] ros = parts[2].split("-");
                        cidSystemInfo = new CIDSystemInfo(ros[0], ros[1], Integer.parseInt(ros[2]));
                    }
                    if (parts[3].length() > 0) {
                        usWeightClass = (int)Long.parseLong(parts[3], 16);
                    }
                    if (parts[4].length() > 0) {
                        sFamilyClass = (int)Long.parseLong(parts[4], 16);
                    }
                    int ulCodePageRange1 = (int)Long.parseLong(parts[5], 16);
                    int ulCodePageRange2 = (int)Long.parseLong(parts[6], 16);
                    if (parts[7].length() > 0) {
                        macStyle = (int)Long.parseLong(parts[7], 16);
                    }
                    if (parts[8].length() > 0) {
                        panose = new byte[10];
                        for (int i = 0; i < 10; ++i) {
                            String str = parts[8].substring(i * 2, i * 2 + 2);
                            int b = Integer.parseInt(str, 16);
                            panose[i] = (byte)(b & 0xFF);
                        }
                    }
                    if ((fontFile = new File(parts[9])).exists()) {
                        FSFontInfo info = new FSFontInfo(fontFile, format, postScriptName, cidSystemInfo, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this);
                        results.add(info);
                    } else {
                        Log.d((String)"PdfBox-Android", (String)("Font file " + fontFile.getAbsolutePath() + " not found, skipped"));
                    }
                    pending.remove(fontFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                List<FSFontInfo> list;
                try {
                    Log.e((String)"PdfBox-Android", (String)"Error loading font cache, will be re-built", (Throwable)e);
                    list = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly(reader);
                return list;
            }
            IOUtils.closeQuietly(reader);
        }
        if (!pending.isEmpty()) {
            Log.w((String)"PdfBox-Android", (String)"New fonts found, font cache will be re-built");
            return null;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeCollection(final File ttcFile) throws IOException {
        try (TrueTypeCollection ttc = null;){
            ttc = new TrueTypeCollection(ttcFile);
            ttc.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                @Override
                public void process(TrueTypeFont ttf) throws IOException {
                    FileSystemFontProvider.this.addTrueTypeFontImpl(ttf, ttcFile);
                }
            });
        }
    }

    private void addTrueTypeFont(File ttfFile) throws IOException {
        try {
            if (ttfFile.getPath().endsWith(".otf")) {
                OTFParser parser = new OTFParser(false, true);
                OpenTypeFont otf = parser.parse(ttfFile);
                this.addTrueTypeFontImpl(otf, ttfFile);
            } else {
                TTFParser parser = new TTFParser(false, true);
                TrueTypeFont ttf = parser.parse(ttfFile);
                this.addTrueTypeFontImpl(ttf, ttfFile);
            }
        }
        catch (IOException e) {
            Log.e((String)"PdfBox-Android", (String)("Could not load font file: " + ttfFile), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeFontImpl(TrueTypeFont ttf, File file) throws IOException {
        try {
            if (ttf.getName() != null && ttf.getName().contains("|")) {
                this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, "*skippipeinname*"));
                Log.w((String)"PdfBox-Android", (String)("Skipping font with '|' in name " + ttf.getName() + " in file " + file));
            } else if (ttf.getName() != null) {
                NamingTable name;
                String format;
                if (ttf.getHeader() == null) {
                    this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, ttf.getName()));
                    return;
                }
                int macStyle = ttf.getHeader().getMacStyle();
                int sFamilyClass = -1;
                int usWeightClass = -1;
                int ulCodePageRange1 = 0;
                int ulCodePageRange2 = 0;
                byte[] panose = null;
                OS2WindowsMetricsTable os2WindowsMetricsTable = ttf.getOS2Windows();
                if (os2WindowsMetricsTable != null) {
                    sFamilyClass = os2WindowsMetricsTable.getFamilyClass();
                    usWeightClass = os2WindowsMetricsTable.getWeightClass();
                    ulCodePageRange1 = (int)os2WindowsMetricsTable.getCodePageRange1();
                    ulCodePageRange2 = (int)os2WindowsMetricsTable.getCodePageRange2();
                    panose = os2WindowsMetricsTable.getPanose();
                }
                if (ttf instanceof OpenTypeFont && ((OpenTypeFont)ttf).isPostScript()) {
                    format = "OTF";
                    CFFFont cff = ((OpenTypeFont)ttf).getCFF().getFont();
                    CIDSystemInfo ros = null;
                    if (cff instanceof CFFCIDFont) {
                        CFFCIDFont cidFont = (CFFCIDFont)cff;
                        String registry = cidFont.getRegistry();
                        String ordering = cidFont.getOrdering();
                        int supplement = cidFont.getSupplement();
                        ros = new CIDSystemInfo(registry, ordering, supplement);
                    }
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.OTF, ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                } else {
                    CIDSystemInfo ros = null;
                    if (ttf.getTableMap().containsKey("gcid")) {
                        byte[] bytes = ttf.getTableBytes(ttf.getTableMap().get("gcid"));
                        String reg = new String(bytes, 10, 64, Charsets.US_ASCII);
                        String registryName = reg.substring(0, reg.indexOf(0));
                        String ord = new String(bytes, 76, 64, Charsets.US_ASCII);
                        String orderName = ord.substring(0, ord.indexOf(0));
                        int supplementVersion = bytes[140] << 8 & (bytes[141] & 0xFF);
                        ros = new CIDSystemInfo(registryName, orderName, supplementVersion);
                    }
                    format = "TTF";
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.TTF, ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                }
                if (PDFBoxConfig.isDebugEnabled() && (name = ttf.getNaming()) != null) {
                    Log.d((String)"PdfBox-Android", (String)(format + ": '" + name.getPostScriptName() + "' / '" + name.getFontFamily() + "' / '" + name.getFontSubFamily() + "'"));
                }
            } else {
                this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, "*skipnoname*"));
                Log.w((String)"PdfBox-Android", (String)("Missing 'name' entry for PostScript name in font " + file));
            }
        }
        catch (IOException e) {
            this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, "*skipexception*"));
            Log.e((String)"PdfBox-Android", (String)("Could not load font file: " + file), (Throwable)e);
        }
        finally {
            ttf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType1Font(File pfbFile) throws IOException {
        try (FileInputStream input = new FileInputStream(pfbFile);){
            Type1Font type1 = Type1Font.createWithPFB(input);
            if (type1.getName() != null && type1.getName().contains("|")) {
                this.fontInfoList.add(new FSIgnored(pfbFile, FontFormat.PFB, "*skippipeinname*"));
                Log.w((String)"PdfBox-Android", (String)("Skipping font with '|' in name " + type1.getName() + " in file " + pfbFile));
                return;
            }
            this.fontInfoList.add(new FSFontInfo(pfbFile, FontFormat.PFB, type1.getName(), null, -1, -1, 0, 0, -1, null, this));
            if (PDFBoxConfig.isDebugEnabled()) {
                Log.d((String)"PdfBox-Android", (String)("PFB: '" + type1.getName() + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'"));
            }
        }
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (FSFontInfo info : this.fontInfoList) {
            sb.append((Object)info.getFormat());
            sb.append(": ");
            sb.append(info.getPostScriptName());
            sb.append(": ");
            sb.append(info.file.getPath());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<? extends FontInfo> getFontInfo() {
        return this.fontInfoList;
    }

    private static final class FSIgnored
    extends FSFontInfo {
        private FSIgnored(File file, FontFormat format, String postScriptName) {
            super(file, format, postScriptName, null, 0, 0, 0, 0, 0, null, null);
        }
    }

    private static class FSFontInfo
    extends FontInfo {
        private final String postScriptName;
        private final FontFormat format;
        private final CIDSystemInfo cidSystemInfo;
        private final int usWeightClass;
        private final int sFamilyClass;
        private final int ulCodePageRange1;
        private final int ulCodePageRange2;
        private final int macStyle;
        private final PDPanoseClassification panose;
        private final File file;
        private final FileSystemFontProvider parent;

        private FSFontInfo(File file, FontFormat format, String postScriptName, CIDSystemInfo cidSystemInfo, int usWeightClass, int sFamilyClass, int ulCodePageRange1, int ulCodePageRange2, int macStyle, byte[] panose, FileSystemFontProvider parent) {
            this.file = file;
            this.format = format;
            this.postScriptName = postScriptName;
            this.cidSystemInfo = cidSystemInfo;
            this.usWeightClass = usWeightClass;
            this.sFamilyClass = sFamilyClass;
            this.ulCodePageRange1 = ulCodePageRange1;
            this.ulCodePageRange2 = ulCodePageRange2;
            this.macStyle = macStyle;
            this.panose = panose != null ? new PDPanoseClassification(panose) : null;
            this.parent = parent;
        }

        @Override
        public String getPostScriptName() {
            return this.postScriptName;
        }

        @Override
        public FontFormat getFormat() {
            return this.format;
        }

        @Override
        public CIDSystemInfo getCIDSystemInfo() {
            return this.cidSystemInfo;
        }

        @Override
        public synchronized FontBoxFont getFont() {
            FontBoxFont font;
            FontBoxFont cached = this.parent.cache.getFont(this);
            if (cached != null) {
                return cached;
            }
            switch (this.format) {
                case PFB: {
                    font = this.getType1Font(this.postScriptName, this.file);
                    break;
                }
                case TTF: {
                    font = this.getTrueTypeFont(this.postScriptName, this.file);
                    break;
                }
                case OTF: {
                    font = this.getOTFFont(this.postScriptName, this.file);
                    break;
                }
                default: {
                    throw new RuntimeException("can't happen");
                }
            }
            if (font != null) {
                this.parent.cache.addFont(this, font);
            }
            return font;
        }

        @Override
        public int getFamilyClass() {
            return this.sFamilyClass;
        }

        @Override
        public int getWeightClass() {
            return this.usWeightClass;
        }

        @Override
        public int getCodePageRange1() {
            return this.ulCodePageRange1;
        }

        @Override
        public int getCodePageRange2() {
            return this.ulCodePageRange2;
        }

        @Override
        public int getMacStyle() {
            return this.macStyle;
        }

        @Override
        public PDPanoseClassification getPanose() {
            return this.panose;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.file;
        }

        private TrueTypeFont getTrueTypeFont(String postScriptName, File file) {
            try {
                TrueTypeFont ttf = this.readTrueTypeFont(postScriptName, file);
                if (PDFBoxConfig.isDebugEnabled()) {
                    Log.d((String)"PdfBox-Android", (String)("Loaded " + postScriptName + " from " + file));
                }
                return ttf;
            }
            catch (IOException e) {
                Log.e((String)"PdfBox-Android", (String)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }

        private TrueTypeFont readTrueTypeFont(String postScriptName, File file) throws IOException {
            if (file.getName().toLowerCase().endsWith(".ttc")) {
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                TrueTypeFont ttf = null;
                try {
                    ttf = ttc.getFontByName(postScriptName);
                }
                catch (IOException ex) {
                    ttc.close();
                    throw ex;
                }
                if (ttf == null) {
                    ttc.close();
                    throw new IOException("Font " + postScriptName + " not found in " + file);
                }
                return ttf;
            }
            TTFParser ttfParser = new TTFParser(false, true);
            return ttfParser.parse(file);
        }

        private OpenTypeFont getOTFFont(String postScriptName, File file) {
            try {
                if (file.getName().toLowerCase().endsWith(".ttc")) {
                    TrueTypeCollection ttc = new TrueTypeCollection(file);
                    TrueTypeFont ttf = null;
                    try {
                        ttf = ttc.getFontByName(postScriptName);
                    }
                    catch (IOException ex) {
                        Log.e((String)"PdfBox-Android", (String)ex.getMessage(), (Throwable)ex);
                        ttc.close();
                        return null;
                    }
                    if (ttf == null) {
                        ttc.close();
                        throw new IOException("Font " + postScriptName + " not found in " + file);
                    }
                    return (OpenTypeFont)ttf;
                }
                OTFParser parser = new OTFParser(false, true);
                OpenTypeFont otf = parser.parse(file);
                if (PDFBoxConfig.isDebugEnabled()) {
                    Log.d((String)"PdfBox-Android", (String)("Loaded " + postScriptName + " from " + file));
                }
                return otf;
            }
            catch (IOException e) {
                Log.e((String)"PdfBox-Android", (String)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Type1Font getType1Font(String postScriptName, File file) {
            Type1Font type1Font;
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                Type1Font type1 = Type1Font.createWithPFB(input);
                if (PDFBoxConfig.isDebugEnabled()) {
                    Log.d((String)"PdfBox-Android", (String)("Loaded " + postScriptName + " from " + file));
                }
                type1Font = type1;
            }
            catch (IOException e) {
                try {
                    Log.e((String)"PdfBox-Android", (String)("Could not load font file: " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly(input);
                return null;
            }
            IOUtils.closeQuietly(input);
            return type1Font;
        }
    }
}

