/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.color;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;
import java.io.IOException;

public final class PDDeviceGray
extends PDDeviceColorSpace {
    public static final PDDeviceGray INSTANCE = new PDDeviceGray();
    private final PDColor initialColor = new PDColor(new float[]{0.0f}, (PDColorSpace)this);

    private PDDeviceGray() {
    }

    @Override
    public String getName() {
        return COSName.DEVICEGRAY.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) {
        return new float[]{value[0], value[0], value[0]};
    }

    @Override
    public Bitmap toRGBImage(Bitmap raster) throws IOException {
        if (raster.getConfig() != Bitmap.Config.ALPHA_8) {
            Log.e((String)"PdfBox-Android", (String)"Raster in PDDevicGrey was not ALPHA_8");
        }
        int width = raster.getWidth();
        int height = raster.getHeight();
        int[] imgPixels = new int[width];
        Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int[] outPixels = new int[width];
        for (int y = 0; y < height; ++y) {
            raster.getPixels(imgPixels, 0, width, 0, y, width, 1);
            for (int x = 0; x < width; ++x) {
                int rgb;
                int gray = Color.alpha((int)imgPixels[x]);
                outPixels[x] = rgb = Color.argb((int)255, (int)gray, (int)gray, (int)gray);
            }
            image.setPixels(outPixels, 0, width, 0, y, width, 1);
        }
        return image;
    }
}

