/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSInputStream;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.filter.DecodeOptions;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDMetadata;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import com.tom_roush.pdfbox.pdmodel.graphics.PDXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.image.CCITTFactory;
import com.tom_roush.pdfbox.pdmodel.graphics.image.JPEGFactory;
import com.tom_roush.pdfbox.pdmodel.graphics.image.LosslessFactory;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImage;
import com.tom_roush.pdfbox.pdmodel.graphics.image.SampledImageReader;
import com.tom_roush.pdfbox.util.filetypedetector.FileType;
import com.tom_roush.pdfbox.util.filetypedetector.FileTypeDetector;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.List;

public final class PDImageXObject
extends PDXObject
implements PDImage {
    private SoftReference<Bitmap> cachedImage;
    private PDColorSpace colorSpace;
    private int cachedImageSubsampling = Integer.MAX_VALUE;
    private final PDResources resources;

    public PDImageXObject(PDDocument document) throws IOException {
        this(new PDStream(document), (PDResources)null);
    }

    public PDImageXObject(PDDocument document, InputStream encodedStream, COSBase cosFilter, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        super(PDImageXObject.createRawStream(document, encodedStream), COSName.IMAGE);
        this.getCOSObject().setItem(COSName.FILTER, cosFilter);
        this.resources = null;
        this.colorSpace = null;
        this.setBitsPerComponent(bitsPerComponent);
        this.setWidth(width);
        this.setHeight(height);
        this.setColorSpace(initColorSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDImageXObject(PDStream stream, PDResources resources) throws IOException {
        super(stream, COSName.IMAGE);
        this.resources = resources;
        List<COSName> filters = stream.getFilters();
        if (filters != null && !filters.isEmpty() && COSName.JPX_DECODE.equals(filters.get(filters.size() - 1))) {
            List<COSName> requireKeys = Arrays.asList(COSName.WIDTH, COSName.HEIGHT, COSName.COLORSPACE);
            boolean needDecode = false;
            COSStream cos = stream.getCOSObject();
            for (COSName k : requireKeys) {
                if (cos.containsKey(k)) continue;
                needDecode = true;
                break;
            }
            if (!needDecode) {
                return;
            }
            COSInputStream is = null;
            try {
                is = stream.createInputStream();
                DecodeResult decodeResult = is.getDecodeResult();
                stream.getCOSObject().addAll(decodeResult.getParameters());
                this.colorSpace = decodeResult.getJPXColorSpace();
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
    }

    public static PDImageXObject createThumbnail(COSStream cosStream) throws IOException {
        PDStream pdStream = new PDStream(cosStream);
        return new PDImageXObject(pdStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static COSStream createRawStream(PDDocument document, InputStream rawInput) throws IOException {
        COSStream stream = document.getDocument().createCOSStream();
        try (OutputStream output = null;){
            output = stream.createRawOutputStream();
            IOUtils.copy(rawInput, output);
        }
        return stream;
    }

    public static PDImageXObject createFromFile(String imagePath, PDDocument doc) throws IOException {
        return PDImageXObject.createFromFileByExtension(new File(imagePath), doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDImageXObject createFromFileByExtension(File file, PDDocument doc) throws IOException {
        String name = file.getName();
        int dot = file.getName().lastIndexOf(46);
        if (dot == -1) {
            throw new IllegalArgumentException("Image type not supported: " + name);
        }
        String ext = name.substring(dot + 1).toLowerCase();
        if ("jpg".equals(ext) || "jpeg".equals(ext)) {
            PDImageXObject pDImageXObject;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                pDImageXObject = JPEGFactory.createFromStream(doc, fis);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
            return pDImageXObject;
        }
        if ("tif".equals(ext) || "tiff".equals(ext)) {
            return CCITTFactory.createFromFile(doc, file);
        }
        if ("gif".equals(ext) || "bmp".equals(ext) || "png".equals(ext)) {
            Bitmap bim = BitmapFactory.decodeFile((String)file.getPath());
            return LosslessFactory.createFromImage(doc, bim);
        }
        throw new IllegalArgumentException("Image type not supported: " + name);
    }

    public static PDImageXObject createFromFileByContent(File file, PDDocument doc) throws IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FileType fileType = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            fileType = FileTypeDetector.detectFileType(bufferedInputStream);
        }
        catch (IOException e) {
            try {
                throw new IOException("Could not determine file type: " + file.getName(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileInputStream);
        IOUtils.closeQuietly(bufferedInputStream);
        if (fileType == null) {
            throw new IllegalArgumentException("Image type not supported: " + file.getName());
        }
        if (fileType.equals((Object)FileType.JPEG)) {
            FileInputStream fis = new FileInputStream(file);
            PDImageXObject imageXObject = JPEGFactory.createFromStream(doc, fis);
            fis.close();
            return imageXObject;
        }
        if (fileType.equals((Object)FileType.TIFF)) {
            try {
                return CCITTFactory.createFromFile(doc, file);
            }
            catch (IOException ex) {
                Log.d((String)"PdfBox-Android", (String)"Reading as TIFF failed, setting fileType to PNG", (Throwable)ex);
                fileType = FileType.PNG;
            }
        }
        if (fileType.equals((Object)FileType.BMP) || fileType.equals((Object)FileType.GIF) || fileType.equals((Object)FileType.PNG)) {
            Bitmap bim = BitmapFactory.decodeFile((String)file.getPath());
            return LosslessFactory.createFromImage(doc, bim);
        }
        throw new IllegalArgumentException("Image type " + (Object)((Object)fileType) + " not supported: " + file.getName());
    }

    public static PDImageXObject createFromByteArray(PDDocument document, byte[] byteArray, String name) throws IOException {
        FileType fileType;
        try {
            fileType = FileTypeDetector.detectFileType(byteArray);
        }
        catch (IOException e) {
            throw new IOException("Could not determine file type: " + name, e);
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Image type not supported: " + name);
        }
        if (fileType.equals((Object)FileType.JPEG)) {
            return JPEGFactory.createFromByteArray(document, byteArray);
        }
        if (fileType.equals((Object)FileType.TIFF)) {
            try {
                return CCITTFactory.createFromByteArray(document, byteArray);
            }
            catch (IOException ex) {
                Log.d((String)"PdfBox-Android", (String)"Reading as TIFF failed, setting fileType to PNG", (Throwable)ex);
                fileType = FileType.PNG;
            }
        }
        if (fileType.equals((Object)FileType.BMP) || fileType.equals((Object)FileType.GIF) || fileType.equals((Object)FileType.PNG)) {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            Bitmap bim = BitmapFactory.decodeStream((InputStream)bais);
            return LosslessFactory.createFromImage(document, bim);
        }
        throw new IllegalArgumentException("Image type " + (Object)((Object)fileType) + " not supported: " + name);
    }

    public PDMetadata getMetadata() {
        COSStream cosStream = this.getCOSObject().getCOSStream(COSName.METADATA);
        if (cosStream != null) {
            return new PDMetadata(cosStream);
        }
        return null;
    }

    public void setMetadata(PDMetadata meta) {
        this.getCOSObject().setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getStructParent() {
        return this.getCOSObject().getInt(COSName.STRUCT_PARENT);
    }

    public void setStructParent(int key) {
        this.getCOSObject().setInt(COSName.STRUCT_PARENT, key);
    }

    @Override
    public Bitmap getImage() throws IOException {
        return this.getImage(null, 1);
    }

    @Override
    public Bitmap getImage(Rect region, int subsampling) throws IOException {
        Bitmap cached;
        if (region == null && subsampling == this.cachedImageSubsampling && this.cachedImage != null && (cached = this.cachedImage.get()) != null) {
            return cached;
        }
        Bitmap image = SampledImageReader.getRGBImage(this, region, subsampling, this.getColorKeyMask());
        PDImageXObject softMask = this.getSoftMask();
        if (softMask != null) {
            float[] matte = this.extractMatte(softMask);
            image = this.applyMask(image, softMask.getOpaqueImage(), true, matte);
        } else {
            PDImageXObject mask = this.getMask();
            if (mask != null && mask.isStencil()) {
                image = this.applyMask(image, mask.getOpaqueImage(), false, null);
            }
        }
        if (region == null && subsampling <= this.cachedImageSubsampling) {
            this.cachedImageSubsampling = subsampling;
            this.cachedImage = new SoftReference<Bitmap>(image);
        }
        return image;
    }

    private float[] extractMatte(PDImageXObject softMask) throws IOException {
        COSBase base = softMask.getCOSObject().getItem(COSName.MATTE);
        float[] matte = null;
        if (base instanceof COSArray) {
            matte = ((COSArray)base).toFloatArray();
            if (matte.length < this.getColorSpace().getNumberOfComponents()) {
                Log.e((String)"PdfBox-Android", (String)"Image /Matte entry not long enough for colorspace, skipped");
                return null;
            }
            matte = this.getColorSpace().toRGB(matte);
        }
        return matte;
    }

    @Override
    public Bitmap getStencilImage(Paint paint) throws IOException {
        if (!this.isStencil()) {
            throw new IllegalStateException("Image is not a stencil");
        }
        return SampledImageReader.getStencilImage(this, paint);
    }

    public Bitmap getOpaqueImage() throws IOException {
        return SampledImageReader.getRGBImage(this, null);
    }

    private Bitmap applyMask(Bitmap image, Bitmap mask, boolean isSoft, float[] matte) {
        if (mask == null) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (mask.getWidth() < width || mask.getHeight() < height) {
            mask = this.scaleImage(mask, width, height);
        } else if (mask.getWidth() > width || mask.getHeight() > height) {
            width = mask.getWidth();
            height = mask.getHeight();
            image = this.scaleImage(image, width, height);
        }
        Bitmap masked = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int[] outPixels = new int[width];
        int[] imgPixels = new int[width];
        int[] maskPixels = new int[width];
        for (int y = 0; y < height; ++y) {
            image.getPixels(imgPixels, 0, width, 0, y, width, 1);
            mask.getPixels(maskPixels, 0, width, 0, y, width, 1);
            for (int x = 0; x < width; ++x) {
                int alpha;
                int rgb = imgPixels[x];
                int r = Color.red((int)rgb);
                int g = Color.green((int)rgb);
                int b = Color.blue((int)rgb);
                int alphaPixel = maskPixels[x];
                if (isSoft) {
                    alpha = Color.alpha((int)alphaPixel);
                    if (matte != null && Float.compare(alpha, 0.0f) != 0) {
                        r = this.clampColor((((float)r / 255.0f - matte[0]) / ((float)alpha / 255.0f) + matte[0]) * 255.0f);
                        g = this.clampColor((((float)g / 255.0f - matte[1]) / ((float)alpha / 255.0f) + matte[1]) * 255.0f);
                        b = this.clampColor((((float)b / 255.0f - matte[2]) / ((float)alpha / 255.0f) + matte[2]) * 255.0f);
                    }
                } else {
                    alpha = 255 - Color.alpha((int)alphaPixel);
                }
                outPixels[x] = Color.argb((int)alpha, (int)r, (int)g, (int)b);
            }
            masked.setPixels(outPixels, 0, width, 0, y, width, 1);
        }
        return masked;
    }

    private int clampColor(float color) {
        return Float.valueOf(color < 0.0f ? 0.0f : (color > 255.0f ? 255.0f : color)).intValue();
    }

    private Bitmap scaleImage(Bitmap image, int width, int height) {
        return Bitmap.createScaledBitmap((Bitmap)image, (int)width, (int)height, (boolean)true);
    }

    public PDImageXObject getMask() throws IOException {
        COSBase mask = this.getCOSObject().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSArray) {
            return null;
        }
        COSStream cosStream = this.getCOSObject().getCOSStream(COSName.MASK);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    public COSArray getColorKeyMask() {
        COSBase mask = this.getCOSObject().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSArray) {
            return (COSArray)mask;
        }
        return null;
    }

    public PDImageXObject getSoftMask() throws IOException {
        COSStream cosStream = this.getCOSObject().getCOSStream(COSName.SMASK);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    @Override
    public int getBitsPerComponent() {
        if (this.isStencil()) {
            return 1;
        }
        return this.getCOSObject().getInt(COSName.BITS_PER_COMPONENT, COSName.BPC);
    }

    @Override
    public void setBitsPerComponent(int bpc) {
        this.getCOSObject().setInt(COSName.BITS_PER_COMPONENT, bpc);
    }

    @Override
    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorSpace == null) {
            COSBase cosBase = this.getCOSObject().getItem(COSName.COLORSPACE, COSName.CS);
            if (cosBase != null) {
                COSObject indirect = null;
                if (cosBase instanceof COSObject && this.resources != null && this.resources.getResourceCache() != null) {
                    indirect = (COSObject)cosBase;
                    this.colorSpace = this.resources.getResourceCache().getColorSpace(indirect);
                    if (this.colorSpace != null) {
                        return this.colorSpace;
                    }
                }
                this.colorSpace = PDColorSpace.create(cosBase, this.resources);
                if (indirect != null) {
                    this.resources.getResourceCache().put(indirect, this.colorSpace);
                }
            } else {
                if (this.isStencil()) {
                    return PDDeviceGray.INSTANCE;
                }
                throw new IOException("could not determine color space");
            }
        }
        return this.colorSpace;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return this.getStream().createInputStream();
    }

    @Override
    public InputStream createInputStream(DecodeOptions options) throws IOException {
        return this.getStream().createInputStream(options);
    }

    @Override
    public InputStream createInputStream(List<String> stopFilters) throws IOException {
        return this.getStream().createInputStream(stopFilters);
    }

    @Override
    public boolean isEmpty() {
        return this.getStream().getCOSObject().getLength() == 0L;
    }

    @Override
    public void setColorSpace(PDColorSpace cs) {
        this.getCOSObject().setItem(COSName.COLORSPACE, cs != null ? cs.getCOSObject() : null);
        this.colorSpace = null;
        this.cachedImage = null;
    }

    @Override
    public int getHeight() {
        return this.getCOSObject().getInt(COSName.HEIGHT);
    }

    @Override
    public void setHeight(int h) {
        this.getCOSObject().setInt(COSName.HEIGHT, h);
    }

    @Override
    public int getWidth() {
        return this.getCOSObject().getInt(COSName.WIDTH);
    }

    @Override
    public void setWidth(int w) {
        this.getCOSObject().setInt(COSName.WIDTH, w);
    }

    @Override
    public boolean getInterpolate() {
        return this.getCOSObject().getBoolean(COSName.INTERPOLATE, false);
    }

    @Override
    public void setInterpolate(boolean value) {
        this.getCOSObject().setBoolean(COSName.INTERPOLATE, value);
    }

    @Override
    public void setDecode(COSArray decode) {
        this.getCOSObject().setItem(COSName.DECODE, (COSBase)decode);
    }

    @Override
    public COSArray getDecode() {
        COSBase decode = this.getCOSObject().getDictionaryObject(COSName.DECODE);
        if (decode instanceof COSArray) {
            return (COSArray)decode;
        }
        return null;
    }

    @Override
    public boolean isStencil() {
        return this.getCOSObject().getBoolean(COSName.IMAGE_MASK, false);
    }

    @Override
    public void setStencil(boolean isStencil) {
        this.getCOSObject().setBoolean(COSName.IMAGE_MASK, isStencil);
    }

    @Override
    public String getSuffix() {
        List<COSName> filters = this.getStream().getFilters();
        if (filters == null) {
            return "png";
        }
        if (filters.contains(COSName.DCT_DECODE)) {
            return "jpg";
        }
        if (filters.contains(COSName.JPX_DECODE)) {
            return "jpx";
        }
        if (filters.contains(COSName.CCITTFAX_DECODE)) {
            return "tiff";
        }
        if (filters.contains(COSName.FLATE_DECODE) || filters.contains(COSName.LZW_DECODE) || filters.contains(COSName.RUN_LENGTH_DECODE)) {
            return "png";
        }
        if (filters.contains(COSName.JBIG2_DECODE)) {
            return "jb2";
        }
        Log.w((String)"PdfBox-Android", (String)("getSuffix() returns null, filters: " + filters));
        return null;
    }

    public PDPropertyList getOptionalContent() {
        COSBase base = this.getCOSObject().getDictionaryObject(COSName.OC);
        if (base instanceof COSDictionary) {
            return PDPropertyList.create((COSDictionary)base);
        }
        return null;
    }

    public void setOptionalContent(PDPropertyList oc) {
        this.getCOSObject().setItem(COSName.OC, (COSObjectable)oc);
    }
}

