/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers;

import android.util.Log;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.PDAppearanceContentStream;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers.AnnotationBorder;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers.PDAbstractAppearanceHandler;
import java.io.IOException;

public class PDInkAppearanceHandler
extends PDAbstractAppearanceHandler {
    public PDInkAppearanceHandler(PDAnnotation annotation) {
        super(annotation);
    }

    public PDInkAppearanceHandler(PDAnnotation annotation, PDDocument document) {
        super(annotation, document);
    }

    @Override
    public void generateAppearanceStreams() {
        this.generateNormalAppearance();
        this.generateRolloverAppearance();
        this.generateDownAppearance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateNormalAppearance() {
        PDAnnotationMarkup ink = (PDAnnotationMarkup)this.getAnnotation();
        AnnotationBorder ab = AnnotationBorder.getAnnotationBorder(ink, ink.getBorderStyle());
        PDColor color = ink.getColor();
        if (color == null || color.getComponents().length == 0 || Float.compare(ab.width, 0.0f) == 0) {
            return;
        }
        PDAppearanceContentStream cs = null;
        try {
            cs = this.getNormalAppearanceAsContentStream();
            this.setOpacity(cs, ink.getConstantOpacity());
            cs.setStrokingColor(color);
            if (ab.dashArray != null) {
                cs.setLineDashPattern(ab.dashArray, 0.0f);
            }
            cs.setLineWidth(ab.width);
            for (float[] pathArray : ink.getInkList()) {
                int nPoints = pathArray.length / 2;
                for (int i = 0; i < nPoints; ++i) {
                    float x = pathArray[i * 2];
                    float y = pathArray[i * 2 + 1];
                    if (i == 0) {
                        cs.moveTo(x, y);
                        continue;
                    }
                    cs.lineTo(x, y);
                }
                cs.stroke();
            }
        }
        catch (IOException ex) {
            Log.e((String)"PdfBox-Android", (String)ex.getMessage(), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly(cs);
        }
    }

    @Override
    public void generateRolloverAppearance() {
    }

    @Override
    public void generateDownAppearance() {
    }
}

