/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.multipdf;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PDFCloneUtility {
    private final PDDocument destination;
    private final Map<Object, COSBase> clonedVersion = new HashMap<Object, COSBase>();
    private final Set<COSBase> clonedValues = new HashSet<COSBase>();

    public PDFCloneUtility(PDDocument dest) {
        this.destination = dest;
    }

    public PDDocument getDestination() {
        return this.destination;
    }

    public COSBase cloneForNewDocument(Object base) throws IOException {
        if (base == null) {
            return null;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return retval;
        }
        if (base instanceof COSBase && this.clonedValues.contains(base)) {
            return (COSBase)base;
        }
        if (base instanceof List) {
            COSArray array = new COSArray();
            List list = (List)base;
            for (Object obj : list) {
                array.add(this.cloneForNewDocument(obj));
            }
            retval = array;
        } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            retval = this.cloneForNewDocument(((COSObjectable)base).getCOSObject());
        } else if (base instanceof COSObject) {
            COSObject object = (COSObject)base;
            retval = this.cloneForNewDocument(object.getObject());
        } else if (base instanceof COSArray) {
            COSArray newArray = new COSArray();
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                newArray.add(this.cloneForNewDocument(array.get(i)));
            }
            retval = newArray;
        } else if (base instanceof COSStream) {
            COSStream originalStream = (COSStream)base;
            COSStream stream = this.destination.getDocument().createCOSStream();
            OutputStream output = stream.createRawOutputStream();
            InputStream input = originalStream.createRawInputStream();
            IOUtils.copy(input, output);
            input.close();
            output.close();
            this.clonedVersion.put(base, stream);
            for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                stream.setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
            }
            retval = stream;
        } else if (base instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)base;
            retval = new COSDictionary();
            this.clonedVersion.put(base, retval);
            for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                ((COSDictionary)retval).setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
            }
        } else {
            retval = (COSBase)base;
        }
        this.clonedVersion.put(base, retval);
        this.clonedValues.add(retval);
        return retval;
    }

    public void cloneMerge(COSObjectable base, COSObjectable target) throws IOException {
        if (base == null) {
            return;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return;
        }
        if (!(base instanceof COSBase)) {
            this.cloneMerge(base.getCOSObject(), target.getCOSObject());
        } else if (base instanceof COSObject) {
            if (target instanceof COSObject) {
                this.cloneMerge(((COSObject)base).getObject(), ((COSObject)target).getObject());
            } else if (target instanceof COSDictionary || target instanceof COSArray) {
                this.cloneMerge(((COSObject)base).getObject(), target);
            }
        } else if (base instanceof COSArray) {
            if (target instanceof COSObject) {
                this.cloneMerge(base, ((COSObject)target).getObject());
            } else {
                COSArray array = (COSArray)base;
                for (int i = 0; i < array.size(); ++i) {
                    ((COSArray)target).add(this.cloneForNewDocument(array.get(i)));
                }
            }
        } else if (base instanceof COSStream) {
            COSStream originalStream = (COSStream)base;
            COSStream stream = this.destination.getDocument().createCOSStream();
            OutputStream output = stream.createOutputStream(originalStream.getFilters());
            IOUtils.copy(originalStream.createInputStream(), output);
            output.close();
            this.clonedVersion.put(base, stream);
            for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                stream.setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
            }
            retval = stream;
        } else if (base instanceof COSDictionary) {
            if (target instanceof COSObject) {
                this.cloneMerge(base, ((COSObject)target).getObject());
            } else {
                COSDictionary dic = (COSDictionary)base;
                this.clonedVersion.put(base, retval);
                for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                    COSName key = entry.getKey();
                    COSBase value = entry.getValue();
                    if (((COSDictionary)target).getItem(key) != null) {
                        this.cloneMerge(value, ((COSDictionary)target).getItem(key));
                        continue;
                    }
                    ((COSDictionary)target).setItem(key, this.cloneForNewDocument(value));
                }
            }
        } else {
            retval = (COSBase)base;
        }
        this.clonedVersion.put(base, retval);
        this.clonedValues.add(retval);
    }
}

