/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.shading;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.harmony.javax.imageio.stream.ImageInputStream;
import com.tom_roush.harmony.javax.imageio.stream.MemoryCacheImageInputStream;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.common.PDRange;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.PDShadingType4;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.Patch;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class PDMeshBasedShadingType
extends PDShadingType4 {
    PDMeshBasedShadingType(COSDictionary shadingDictionary) {
        super(shadingDictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Patch> collectPatches(AffineTransform xform, Matrix matrix, int controlPoints) throws IOException {
        COSDictionary dict = this.getCOSObject();
        if (!(dict instanceof COSStream)) {
            return Collections.emptyList();
        }
        PDRange rangeX = this.getDecodeForParameter(0);
        PDRange rangeY = this.getDecodeForParameter(1);
        if (Float.compare(rangeX.getMin(), rangeX.getMax()) == 0 || Float.compare(rangeY.getMin(), rangeY.getMax()) == 0) {
            return Collections.emptyList();
        }
        int bitsPerFlag = this.getBitsPerFlag();
        PDRange[] colRange = new PDRange[this.getNumberOfColorComponents()];
        for (int i = 0; i < colRange.length; ++i) {
            colRange[i] = this.getDecodeForParameter(2 + i);
            if (colRange[i] != null) continue;
            throw new IOException("Range missing in shading /Decode entry");
        }
        ArrayList<Patch> list = new ArrayList<Patch>();
        long maxSrcCoord = (long)Math.pow(2.0, this.getBitsPerCoordinate()) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.getBitsPerComponent()) - 1L;
        COSStream cosStream = (COSStream)dict;
        try (MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.createInputStream());){
            PointF[] implicitEdge = new PointF[4];
            float[][] implicitCornerColor = new float[2][colRange.length];
            byte flag = 0;
            try {
                flag = (byte)(mciis.readBits(bitsPerFlag) & 3L);
            }
            catch (EOFException ex) {
                Log.e((String)"PdfBox-Android", (String)ex.getMessage(), (Throwable)ex);
                ArrayList<Patch> arrayList = list;
                mciis.close();
                return arrayList;
            }
            boolean eof = false;
            block15: while (!eof) {
                try {
                    boolean isFree = flag == 0;
                    Patch current = this.readPatch(mciis, isFree, implicitEdge, implicitCornerColor, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform, controlPoints);
                    if (current == null) {
                        break;
                    }
                    list.add(current);
                    flag = (byte)(mciis.readBits(bitsPerFlag) & 3L);
                    switch (flag) {
                        case 0: {
                            continue block15;
                        }
                        case 1: {
                            implicitEdge = current.getFlag1Edge();
                            implicitCornerColor = current.getFlag1Color();
                            continue block15;
                        }
                        case 2: {
                            implicitEdge = current.getFlag2Edge();
                            implicitCornerColor = current.getFlag2Color();
                            continue block15;
                        }
                        case 3: {
                            implicitEdge = current.getFlag3Edge();
                            implicitCornerColor = current.getFlag3Color();
                            continue block15;
                        }
                    }
                    Log.w((String)"PdfBox-Android", (String)("bad flag: " + flag));
                }
                catch (EOFException ex) {
                    eof = true;
                }
            }
        }
        return list;
    }

    protected Patch readPatch(ImageInputStream input, boolean isFree, PointF[] implicitEdge, float[][] implicitCornerColor, long maxSrcCoord, long maxSrcColor, PDRange rangeX, PDRange rangeY, PDRange[] colRange, Matrix matrix, AffineTransform xform, int controlPoints) throws IOException {
        int i;
        int numberOfColorComponents = this.getNumberOfColorComponents();
        float[][] color = new float[4][numberOfColorComponents];
        PointF[] points = new PointF[controlPoints];
        int pStart = 4;
        int cStart = 2;
        if (isFree) {
            pStart = 0;
            cStart = 0;
        } else {
            points[0] = implicitEdge[0];
            points[1] = implicitEdge[1];
            points[2] = implicitEdge[2];
            points[3] = implicitEdge[3];
            for (i = 0; i < numberOfColorComponents; ++i) {
                color[0][i] = implicitCornerColor[0][i];
                color[1][i] = implicitCornerColor[1][i];
            }
        }
        try {
            for (i = pStart; i < controlPoints; ++i) {
                long x = input.readBits(this.getBitsPerCoordinate());
                long y = input.readBits(this.getBitsPerCoordinate());
                float px = this.interpolate(x, maxSrcCoord, rangeX.getMin(), rangeX.getMax());
                float py = this.interpolate(y, maxSrcCoord, rangeY.getMin(), rangeY.getMax());
                PointF p = matrix.transformPoint(px, py);
                xform.transform(p, p);
                points[i] = p;
            }
            for (i = cStart; i < 4; ++i) {
                for (int j = 0; j < numberOfColorComponents; ++j) {
                    long c = input.readBits(this.getBitsPerComponent());
                    color[i][j] = this.interpolate(c, maxSrcColor, colRange[j].getMin(), colRange[j].getMax());
                }
            }
        }
        catch (EOFException ex) {
            Log.d((String)"PdfBox-Android", (String)"EOF", (Throwable)ex);
            return null;
        }
        return this.generatePatch(points, color);
    }

    abstract Patch generatePatch(PointF[] var1, float[][] var2);

    @Override
    public abstract RectF getBounds(AffineTransform var1, Matrix var2) throws IOException;

    RectF getBounds(AffineTransform xform, Matrix matrix, int controlPoints) throws IOException {
        RectF bounds = null;
        for (Patch patch : this.collectPatches(xform, matrix, controlPoints)) {
            for (ShadedTriangle shadedTriangle : patch.listOfTriangles) {
                if (bounds == null) {
                    bounds = new RectF(shadedTriangle.corner[0].x, shadedTriangle.corner[0].y, 0.0f, 0.0f);
                }
                bounds.union(shadedTriangle.corner[0].x, shadedTriangle.corner[0].y);
                bounds.union(shadedTriangle.corner[1].x, shadedTriangle.corner[1].y);
                bounds.union(shadedTriangle.corner[2].x, shadedTriangle.corner[2].y);
            }
        }
        return bounds;
    }
}

