/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.shading;

import android.graphics.PointF;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.CoordinateColorPair;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.Patch;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import java.util.List;

class CoonsPatch
extends Patch {
    protected CoonsPatch(PointF[] points, float[][] color) {
        super(color);
        this.controlPoints = this.reshapeControlPoints(points);
        this.level = this.calcLevel();
        this.listOfTriangles = this.getTriangles();
    }

    private PointF[][] reshapeControlPoints(PointF[] points) {
        PointF[][] fourRows = new PointF[4][4];
        fourRows[2] = new PointF[]{points[0], points[1], points[2], points[3]};
        fourRows[1] = new PointF[]{points[3], points[4], points[5], points[6]};
        fourRows[3] = new PointF[]{points[9], points[8], points[7], points[6]};
        fourRows[0] = new PointF[]{points[0], points[11], points[10], points[9]};
        return fourRows;
    }

    private int[] calcLevel() {
        int[] l = new int[]{4, 4};
        if (this.isEdgeALine(this.controlPoints[0]) && this.isEdgeALine(this.controlPoints[1])) {
            double lc1 = this.getLen(this.controlPoints[0][0], this.controlPoints[0][3]);
            double lc2 = this.getLen(this.controlPoints[1][0], this.controlPoints[1][3]);
            if (!(lc1 > 800.0) && !(lc2 > 800.0)) {
                l[0] = lc1 > 400.0 || lc2 > 400.0 ? 3 : (lc1 > 200.0 || lc2 > 200.0 ? 2 : 1);
            }
        }
        if (this.isEdgeALine(this.controlPoints[2]) && this.isEdgeALine(this.controlPoints[3])) {
            double ld1 = this.getLen(this.controlPoints[2][0], this.controlPoints[2][3]);
            double ld2 = this.getLen(this.controlPoints[3][0], this.controlPoints[3][3]);
            if (!(ld1 > 800.0) && !(ld2 > 800.0)) {
                l[1] = ld1 > 400.0 || ld2 > 400.0 ? 3 : (ld1 > 200.0 || ld2 > 200.0 ? 2 : 1);
            }
        }
        return l;
    }

    private List<ShadedTriangle> getTriangles() {
        CoordinateColorPair[][] patchCC = new CoordinateColorPair[][]{};
        return this.getShadedTriangles(patchCC);
    }

    @Override
    protected PointF[] getFlag1Edge() {
        return (PointF[])this.controlPoints[1].clone();
    }

    @Override
    protected PointF[] getFlag2Edge() {
        PointF[] implicitEdge = new PointF[]{this.controlPoints[3][3], this.controlPoints[3][2], this.controlPoints[3][1], this.controlPoints[3][0]};
        return implicitEdge;
    }

    @Override
    protected PointF[] getFlag3Edge() {
        PointF[] implicitEdge = new PointF[]{this.controlPoints[0][3], this.controlPoints[0][2], this.controlPoints[0][1], this.controlPoints[0][0]};
        return implicitEdge;
    }
}

