/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.harmony.awt;

import android.graphics.Color;

public class AWTColor {
    public static final AWTColor white;
    public static final AWTColor WHITE;
    public static final AWTColor lightGray;
    public static final AWTColor LIGHT_GRAY;
    public static final AWTColor gray;
    public static final AWTColor GRAY;
    public static final AWTColor darkGray;
    public static final AWTColor DARK_GRAY;
    public static final AWTColor black;
    public static final AWTColor BLACK;
    public static final AWTColor red;
    public static final AWTColor RED;
    public static final AWTColor pink;
    public static final AWTColor PINK;
    public static final AWTColor orange;
    public static final AWTColor ORANGE;
    public static final AWTColor yellow;
    public static final AWTColor YELLOW;
    public static final AWTColor green;
    public static final AWTColor GREEN;
    public static final AWTColor magenta;
    public static final AWTColor MAGENTA;
    public static final AWTColor cyan;
    public static final AWTColor CYAN;
    public static final AWTColor blue;
    public static final AWTColor BLUE;
    public int color;

    public AWTColor(int c) {
        this.color = c;
    }

    public AWTColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public AWTColor(int r, int g, int b, int a) {
        this.color = Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    public AWTColor(float r, float g, float b) {
        this.color = Color.rgb((int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
    }

    public int getRed() {
        return Color.red((int)this.color);
    }

    public int getGreen() {
        return Color.green((int)this.color);
    }

    public int getBlue() {
        return Color.blue((int)this.color);
    }

    public int getAlpha() {
        return Color.alpha((int)this.color);
    }

    public float[] getRGBColorComponents(float[] compArray) {
        float[] retval = compArray == null ? new float[3] : compArray;
        retval[0] = (float)this.getRed() / 255.0f;
        retval[1] = (float)this.getGreen() / 255.0f;
        retval[2] = (float)this.getBlue() / 255.0f;
        return retval;
    }

    static {
        WHITE = white = new AWTColor(255, 255, 255);
        LIGHT_GRAY = lightGray = new AWTColor(192, 192, 192);
        GRAY = gray = new AWTColor(128, 128, 128);
        DARK_GRAY = darkGray = new AWTColor(64, 64, 64);
        BLACK = black = new AWTColor(0, 0, 0);
        RED = red = new AWTColor(255, 0, 0);
        PINK = pink = new AWTColor(255, 175, 175);
        ORANGE = orange = new AWTColor(255, 200, 0);
        YELLOW = yellow = new AWTColor(255, 255, 0);
        GREEN = green = new AWTColor(0, 255, 0);
        MAGENTA = magenta = new AWTColor(255, 0, 255);
        CYAN = cyan = new AWTColor(0, 255, 255);
        BLUE = blue = new AWTColor(0, 0, 255);
    }
}

