/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;
import com.tom_roush.harmony.javax.imageio.stream.MemoryCacheImageOutputStream;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.FilterFactory;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImageXObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public final class LosslessFactory {
    static boolean usePredictorEncoder = false;

    private LosslessFactory() {
    }

    public static PDImageXObject createFromImage(PDDocument document, Bitmap image) throws IOException {
        PDImageXObject pdImageXObject;
        if (LosslessFactory.isGrayImage(image)) {
            return LosslessFactory.createFromGrayImage(image, document);
        }
        if (usePredictorEncoder && (pdImageXObject = new PredictorEncoder(document, image).encode()) != null) {
            if (pdImageXObject.getColorSpace() == PDDeviceRGB.INSTANCE && pdImageXObject.getBitsPerComponent() < 16 && image.getWidth() * image.getHeight() <= 2500) {
                PDImageXObject pdImageXObjectClassic = LosslessFactory.createFromRGBImage(image, document);
                if (pdImageXObjectClassic.getCOSObject().getLength() < pdImageXObject.getCOSObject().getLength()) {
                    Log.e((String)"PdfBox-Android", (String)"Return classic");
                    pdImageXObject.getCOSObject().close();
                    return pdImageXObjectClassic;
                }
                Log.e((String)"PdfBox-Android", (String)"Return predictor");
                pdImageXObjectClassic.getCOSObject().close();
            }
            return pdImageXObject;
        }
        return LosslessFactory.createFromRGBImage(image, document);
    }

    private static boolean isGrayImage(Bitmap image) {
        return image.getConfig() == Bitmap.Config.ALPHA_8;
    }

    private static PDImageXObject createFromGrayImage(Bitmap image, PDDocument document) throws IOException {
        int height = image.getHeight();
        int width = image.getWidth();
        int[] rgbLineBuffer = new int[width];
        int bpc = 8;
        ByteArrayOutputStream baos = new ByteArrayOutputStream((width * bpc / 8 + (width * bpc % 8 != 0 ? 1 : 0)) * height);
        MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(baos);
        for (int y = 0; y < height; ++y) {
            image.getPixels(rgbLineBuffer, 0, width, 0, y, width, 1);
            for (int pixel : rgbLineBuffer) {
                mcios.writeBits(pixel & 0xFF, bpc);
            }
            int bitOffset = mcios.getBitOffset();
            if (bitOffset == 0) continue;
            mcios.writeBits(0L, 8 - bitOffset);
        }
        mcios.flush();
        mcios.close();
        return LosslessFactory.prepareImageXObject(document, baos.toByteArray(), image.getWidth(), image.getHeight(), bpc, PDDeviceGray.INSTANCE);
    }

    private static PDImageXObject createFromRGBImage(Bitmap image, PDDocument document) throws IOException {
        int height = image.getHeight();
        int width = image.getWidth();
        int[] rgbLineBuffer = new int[width];
        int bpc = 8;
        PDDeviceRGB deviceColorSpace = PDDeviceRGB.INSTANCE;
        byte[] imageData = new byte[width * height * 3];
        int byteIdx = 0;
        int alphaByteIdx = 0;
        int alphaBitPos = 7;
        int apbc = 8;
        byte[] alphaImageData = image.hasAlpha() ? new byte[(width * apbc / 8 + (width * apbc % 8 != 0 ? 1 : 0)) * height] : new byte[]{};
        for (int y = 0; y < height; ++y) {
            image.getPixels(rgbLineBuffer, 0, width, 0, y, width, 1);
            for (int pixel : rgbLineBuffer) {
                imageData[byteIdx++] = (byte)(pixel >> 16 & 0xFF);
                imageData[byteIdx++] = (byte)(pixel >> 8 & 0xFF);
                imageData[byteIdx++] = (byte)(pixel & 0xFF);
                if (!image.hasAlpha()) continue;
                alphaImageData[alphaByteIdx++] = (byte)(pixel >> 24 & 0xFF);
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(document, imageData, image.getWidth(), image.getHeight(), bpc, deviceColorSpace);
        if (image.hasAlpha()) {
            PDImageXObject pdMask = LosslessFactory.prepareImageXObject(document, alphaImageData, image.getWidth(), image.getHeight(), apbc, PDDeviceGray.INSTANCE);
            pdImage.getCOSObject().setItem(COSName.SMASK, (COSObjectable)pdMask);
        }
        return pdImage;
    }

    static PDImageXObject prepareImageXObject(PDDocument document, byte[] byteArray, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(byteArray.length / 2);
        Filter filter = FilterFactory.INSTANCE.getFilter(COSName.FLATE_DECODE);
        filter.encode(new ByteArrayInputStream(byteArray), baos, new COSDictionary(), 0);
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(baos.toByteArray());
        return new PDImageXObject(document, encodedByteStream, COSName.FLATE_DECODE, width, height, bitsPerComponent, initColorSpace);
    }

    private static class PredictorEncoder {
        private final PDDocument document;
        private final Bitmap image;
        private final int bytesPerComponent;
        private final int bytesPerPixel;
        private final int height;
        private final int width;
        private final byte[] dataRawRowNone;
        private final byte[] dataRawRowSub;
        private final byte[] dataRawRowUp;
        private final byte[] dataRawRowAverage;
        private final byte[] dataRawRowPaeth;
        final Bitmap.Config imageType;
        final boolean hasAlpha;
        final byte[] alphaImageData;
        final byte[] aValues;
        final byte[] cValues;
        final byte[] bValues;
        final byte[] xValues;
        final byte[] tmpResultValues;

        PredictorEncoder(PDDocument document, Bitmap image) {
            this.document = document;
            this.image = image;
            this.bytesPerComponent = 1;
            this.bytesPerPixel = 3 * this.bytesPerComponent;
            this.height = image.getHeight();
            this.width = image.getWidth();
            this.imageType = image.getConfig();
            this.hasAlpha = image.hasAlpha();
            this.alphaImageData = this.hasAlpha ? new byte[this.width * this.height * this.bytesPerComponent] : null;
            int dataRowByteCount = this.width * this.bytesPerPixel + 1;
            this.dataRawRowNone = new byte[dataRowByteCount];
            this.dataRawRowSub = new byte[dataRowByteCount];
            this.dataRawRowUp = new byte[dataRowByteCount];
            this.dataRawRowAverage = new byte[dataRowByteCount];
            this.dataRawRowPaeth = new byte[dataRowByteCount];
            this.dataRawRowNone[0] = 0;
            this.dataRawRowSub[0] = 1;
            this.dataRawRowUp[0] = 2;
            this.dataRawRowAverage[0] = 3;
            this.dataRawRowPaeth[0] = 4;
            this.aValues = new byte[this.bytesPerPixel];
            this.cValues = new byte[this.bytesPerPixel];
            this.bValues = new byte[this.bytesPerPixel];
            this.xValues = new byte[this.bytesPerPixel];
            this.tmpResultValues = new byte[this.bytesPerPixel];
        }

        PDImageXObject encode() throws IOException {
            int[] transferRow;
            int[] prevRow;
            int elementsInRowPerPixel;
            switch (this.imageType) {
                case ARGB_8888: 
                case RGB_565: {
                    elementsInRowPerPixel = 1;
                    prevRow = new int[this.width * elementsInRowPerPixel];
                    transferRow = new int[this.width * elementsInRowPerPixel];
                    break;
                }
                default: {
                    return null;
                }
            }
            int elementsInTransferRow = this.width * elementsInRowPerPixel;
            ByteArrayOutputStream stream = new ByteArrayOutputStream(this.height * this.width * this.bytesPerPixel / 2);
            Deflater deflater = new Deflater(Filter.getCompressionLevel());
            DeflaterOutputStream zip = new DeflaterOutputStream((OutputStream)stream, deflater);
            int alphaPtr = 0;
            for (int rowNum = 0; rowNum < this.height; ++rowNum) {
                this.image.getPixels(transferRow, 0, this.width, 0, rowNum, this.width, 1);
                int writerPtr = 1;
                Arrays.fill(this.aValues, (byte)0);
                Arrays.fill(this.cValues, (byte)0);
                int[] transferRowInt = transferRow;
                int[] prevRowInt = prevRow;
                int indexInTransferRow = 0;
                while (indexInTransferRow < elementsInTransferRow) {
                    this.copyIntToBytes(transferRowInt, indexInTransferRow, this.xValues, this.alphaImageData, alphaPtr);
                    this.copyIntToBytes(prevRowInt, indexInTransferRow, this.bValues, null, 0);
                    int length = this.xValues.length;
                    for (int bytePtr = 0; bytePtr < length; ++bytePtr) {
                        int x = this.xValues[bytePtr] & 0xFF;
                        int a = this.aValues[bytePtr] & 0xFF;
                        int b = this.bValues[bytePtr] & 0xFF;
                        int c = this.cValues[bytePtr] & 0xFF;
                        this.dataRawRowNone[writerPtr] = (byte)x;
                        this.dataRawRowSub[writerPtr] = PredictorEncoder.pngFilterSub(x, a);
                        this.dataRawRowUp[writerPtr] = PredictorEncoder.pngFilterUp(x, b);
                        this.dataRawRowAverage[writerPtr] = PredictorEncoder.pngFilterAverage(x, a, b);
                        this.dataRawRowPaeth[writerPtr] = PredictorEncoder.pngFilterPaeth(x, a, b, c);
                        ++writerPtr;
                    }
                    System.arraycopy(this.xValues, 0, this.aValues, 0, this.bytesPerPixel);
                    System.arraycopy(this.bValues, 0, this.cValues, 0, this.bytesPerPixel);
                    indexInTransferRow += elementsInRowPerPixel;
                    alphaPtr += this.bytesPerComponent;
                }
                byte[] rowToWrite = this.chooseDataRowToWrite();
                zip.write(rowToWrite, 0, rowToWrite.length);
                int[] temp = prevRow;
                prevRow = transferRow;
                transferRow = temp;
            }
            zip.close();
            deflater.end();
            return this.preparePredictorPDImage(stream, this.bytesPerComponent * 8);
        }

        private void copyIntToBytes(int[] transferRow, int indexInTranferRow, byte[] targetValues, byte[] alphaImageData, int alphaPtr) {
            int val = transferRow[indexInTranferRow];
            byte b0 = (byte)Color.blue((int)val);
            byte b1 = (byte)Color.green((int)val);
            byte b2 = (byte)Color.red((int)val);
            switch (this.imageType) {
                case ARGB_8888: {
                    byte b3;
                    targetValues[0] = b2;
                    targetValues[1] = b1;
                    targetValues[2] = b0;
                    if (alphaImageData == null) break;
                    alphaImageData[alphaPtr] = b3 = (byte)Color.alpha((int)val);
                    break;
                }
                case RGB_565: {
                    targetValues[0] = b2;
                    targetValues[1] = b1;
                    targetValues[2] = b0;
                    break;
                }
            }
        }

        private PDImageXObject preparePredictorPDImage(ByteArrayOutputStream stream, int bitsPerComponent) throws IOException {
            int h = this.image.getHeight();
            int w = this.image.getWidth();
            PDDeviceRGB pdColorSpace = PDDeviceRGB.INSTANCE;
            PDImageXObject imageXObject = new PDImageXObject(this.document, new ByteArrayInputStream(stream.toByteArray()), COSName.FLATE_DECODE, w, h, bitsPerComponent, pdColorSpace);
            COSDictionary decodeParms = new COSDictionary();
            decodeParms.setItem(COSName.BITS_PER_COMPONENT, (COSBase)COSInteger.get(bitsPerComponent));
            decodeParms.setItem(COSName.PREDICTOR, (COSBase)COSInteger.get(15L));
            decodeParms.setItem(COSName.COLUMNS, (COSBase)COSInteger.get(w));
            decodeParms.setItem(COSName.COLORS, (COSBase)COSInteger.get(3L));
            imageXObject.getCOSObject().setItem(COSName.DECODE_PARMS, (COSBase)decodeParms);
            if (this.hasAlpha) {
                PDImageXObject pdMask = LosslessFactory.prepareImageXObject(this.document, this.alphaImageData, this.image.getWidth(), this.image.getHeight(), 8 * this.bytesPerComponent, PDDeviceGray.INSTANCE);
                imageXObject.getCOSObject().setItem(COSName.SMASK, (COSObjectable)pdMask);
            }
            return imageXObject;
        }

        private byte[] chooseDataRowToWrite() {
            byte[] rowToWrite = this.dataRawRowNone;
            long estCompressSum = PredictorEncoder.estCompressSum(this.dataRawRowNone);
            long estCompressSumSub = PredictorEncoder.estCompressSum(this.dataRawRowSub);
            long estCompressSumUp = PredictorEncoder.estCompressSum(this.dataRawRowUp);
            long estCompressSumAvg = PredictorEncoder.estCompressSum(this.dataRawRowAverage);
            long estCompressSumPaeth = PredictorEncoder.estCompressSum(this.dataRawRowPaeth);
            if (estCompressSum > estCompressSumSub) {
                rowToWrite = this.dataRawRowSub;
                estCompressSum = estCompressSumSub;
            }
            if (estCompressSum > estCompressSumUp) {
                rowToWrite = this.dataRawRowUp;
                estCompressSum = estCompressSumUp;
            }
            if (estCompressSum > estCompressSumAvg) {
                rowToWrite = this.dataRawRowAverage;
                estCompressSum = estCompressSumAvg;
            }
            if (estCompressSum > estCompressSumPaeth) {
                rowToWrite = this.dataRawRowPaeth;
            }
            return rowToWrite;
        }

        private static byte pngFilterSub(int x, int a) {
            return (byte)((x & 0xFF) - (a & 0xFF));
        }

        private static byte pngFilterUp(int x, int b) {
            return PredictorEncoder.pngFilterSub(x, b);
        }

        private static byte pngFilterAverage(int x, int a, int b) {
            return (byte)(x - (b + a) / 2);
        }

        private static byte pngFilterPaeth(int x, int a, int b, int c) {
            int p = a + b - c;
            int pa = Math.abs(p - a);
            int pb = Math.abs(p - b);
            int pc = Math.abs(p - c);
            int pr = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
            int r = x - pr;
            return (byte)r;
        }

        private static long estCompressSum(byte[] dataRawRowSub) {
            long sum = 0L;
            for (byte aDataRawRowSub : dataRawRowSub) {
                sum += (long)Math.abs(aDataRawRowSub);
            }
            return sum;
        }
    }
}

