/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.shading;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.harmony.javax.imageio.stream.ImageInputStream;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.PDRange;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.PDShading;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.Vertex;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;
import java.util.List;

abstract class PDTriangleBasedShadingType
extends PDShading {
    private COSArray decode = null;
    private int bitsPerCoordinate = -1;
    private int bitsPerColorComponent = -1;
    private int numberOfColorComponents = -1;

    PDTriangleBasedShadingType(COSDictionary shadingDictionary) {
        super(shadingDictionary);
    }

    public int getBitsPerComponent() {
        if (this.bitsPerColorComponent == -1) {
            this.bitsPerColorComponent = this.getCOSObject().getInt(COSName.BITS_PER_COMPONENT, -1);
            Log.d((String)"PdfBox-Android", (String)("bitsPerColorComponent: " + this.bitsPerColorComponent));
        }
        return this.bitsPerColorComponent;
    }

    public void setBitsPerComponent(int bitsPerComponent) {
        this.getCOSObject().setInt(COSName.BITS_PER_COMPONENT, bitsPerComponent);
        this.bitsPerColorComponent = bitsPerComponent;
    }

    public int getBitsPerCoordinate() {
        if (this.bitsPerCoordinate == -1) {
            this.bitsPerCoordinate = this.getCOSObject().getInt(COSName.BITS_PER_COORDINATE, -1);
            Log.d((String)"PdfBox-Android", (String)("bitsPerCoordinate: " + (Math.pow(2.0, this.bitsPerCoordinate) - 1.0)));
        }
        return this.bitsPerCoordinate;
    }

    public void setBitsPerCoordinate(int bitsPerCoordinate) {
        this.getCOSObject().setInt(COSName.BITS_PER_COORDINATE, bitsPerCoordinate);
        this.bitsPerCoordinate = bitsPerCoordinate;
    }

    public int getNumberOfColorComponents() throws IOException {
        if (this.numberOfColorComponents == -1) {
            this.numberOfColorComponents = this.getFunction() != null ? 1 : this.getColorSpace().getNumberOfComponents();
            Log.d((String)"PdfBox-Android", (String)("numberOfColorComponents: " + this.numberOfColorComponents));
        }
        return this.numberOfColorComponents;
    }

    private COSArray getDecodeValues() {
        if (this.decode == null) {
            this.decode = (COSArray)this.getCOSObject().getDictionaryObject(COSName.DECODE);
        }
        return this.decode;
    }

    public void setDecodeValues(COSArray decodeValues) {
        this.decode = decodeValues;
        this.getCOSObject().setItem(COSName.DECODE, (COSBase)decodeValues);
    }

    public PDRange getDecodeForParameter(int paramNum) {
        PDRange retval = null;
        COSArray decodeValues = this.getDecodeValues();
        if (decodeValues != null && decodeValues.size() >= paramNum * 2 + 1) {
            retval = new PDRange(decodeValues, paramNum);
        }
        return retval;
    }

    protected float interpolate(float src, long srcMax, float dstMin, float dstMax) {
        return dstMin + src * (dstMax - dstMin) / (float)srcMax;
    }

    protected Vertex readVertex(ImageInputStream input, long maxSrcCoord, long maxSrcColor, PDRange rangeX, PDRange rangeY, PDRange[] colRangeTab, Matrix matrix, AffineTransform xform) throws IOException {
        float[] colorComponentTab = new float[this.numberOfColorComponents];
        long x = input.readBits(this.bitsPerCoordinate);
        long y = input.readBits(this.bitsPerCoordinate);
        float dstX = this.interpolate(x, maxSrcCoord, rangeX.getMin(), rangeX.getMax());
        float dstY = this.interpolate(y, maxSrcCoord, rangeY.getMin(), rangeY.getMax());
        Log.d((String)"PdfBox-Android", (String)("coord: " + String.format("[%06X,%06X] -> [%f,%f]", x, y, Float.valueOf(dstX), Float.valueOf(dstY))));
        PointF p = matrix.transformPoint(dstX, dstY);
        xform.transform(p, p);
        for (int n = 0; n < this.numberOfColorComponents; ++n) {
            int color = (int)input.readBits(this.bitsPerColorComponent);
            colorComponentTab[n] = this.interpolate(color, maxSrcColor, colRangeTab[n].getMin(), colRangeTab[n].getMax());
            Log.d((String)"PdfBox-Android", (String)("color[" + n + "]: " + color + "/" + String.format("%02x", color) + "-> color[" + n + "]: " + colorComponentTab[n]));
        }
        int bitOffset = input.getBitOffset();
        if (bitOffset != 0) {
            input.readBits(8 - bitOffset);
        }
        return new Vertex(p, colorComponentTab);
    }

    abstract List<ShadedTriangle> collectTriangles(AffineTransform var1, Matrix var2) throws IOException;

    @Override
    public RectF getBounds(AffineTransform xform, Matrix matrix) throws IOException {
        RectF bounds = null;
        for (ShadedTriangle shadedTriangle : this.collectTriangles(xform, matrix)) {
            if (bounds == null) {
                bounds = new RectF(shadedTriangle.corner[0].x, shadedTriangle.corner[0].y, 0.0f, 0.0f);
            }
            bounds.union(shadedTriangle.corner[0].x, shadedTriangle.corner[0].y);
            bounds.union(shadedTriangle.corner[1].x, shadedTriangle.corner[1].y);
            bounds.union(shadedTriangle.corner[2].x, shadedTriangle.corner[2].y);
        }
        if (bounds == null) {
            return new RectF();
        }
        return bounds;
    }
}

