/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class PDXFAResource
implements COSObjectable {
    private static final int BUFFER_SIZE = 1024;
    private final COSBase xfa;

    public PDXFAResource(COSBase xfaBase) {
        this.xfa = xfaBase;
    }

    @Override
    public COSBase getCOSObject() {
        return this.xfa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream is = null;){
            if (this.getCOSObject() instanceof COSArray) {
                byte[] xfaBytes = new byte[1024];
                COSArray cosArray = (COSArray)this.getCOSObject();
                for (int i = 1; i < cosArray.size(); i += 2) {
                    int nRead;
                    COSBase cosObj = cosArray.getObject(i);
                    if (!(cosObj instanceof COSStream)) continue;
                    is = ((COSStream)cosObj).createInputStream();
                    while ((nRead = is.read(xfaBytes, 0, xfaBytes.length)) != -1) {
                        baos.write(xfaBytes, 0, nRead);
                    }
                    baos.flush();
                }
            } else if (this.xfa.getCOSObject() instanceof COSStream) {
                int nRead;
                byte[] xfaBytes = new byte[1024];
                is = ((COSStream)this.xfa.getCOSObject()).createInputStream();
                while ((nRead = is.read(xfaBytes, 0, xfaBytes.length)) != -1) {
                    baos.write(xfaBytes, 0, nRead);
                }
                baos.flush();
            }
        }
        return baos.toByteArray();
    }

    public Document getDocument() throws ParserConfigurationException, SAXException, IOException {
        return XMLUtil.parse(new ByteArrayInputStream(this.getBytes()), true);
    }
}

