/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.harmony.javax.imageio.stream;

import com.tom_roush.harmony.javax.imageio.stream.IIOByteBuffer;
import com.tom_roush.harmony.javax.imageio.stream.ImageInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;

public abstract class ImageInputStreamImpl
implements ImageInputStream {
    protected ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long streamPos = 0L;
    protected long flushedPos = 0L;
    protected int bitOffset = 0;
    private boolean closed = false;
    private final PositionStack posStack = new PositionStack();
    private final PositionStack offsetStack = new PositionStack();
    private final byte[] buff = new byte[8];
    int currentByte;

    protected final void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public abstract int read() throws IOException;

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void readBytes(IIOByteBuffer buf, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException("buffer is NULL");
        }
        byte[] b = new byte[len];
        len = this.read(b, 0, b.length);
        buf.setData(b);
        buf.setOffset(0);
        buf.setLength(len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException("EOF reached");
        }
        return b != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException("EOF reached");
        }
        return (byte)b;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException("EOF reached");
        }
        return b;
    }

    @Override
    public short readShort() throws IOException {
        if (this.read(this.buff, 0, 2) < 0) {
            throw new EOFException();
        }
        return this.byteOrder == ByteOrder.BIG_ENDIAN ? (short)(this.buff[0] << 8 | this.buff[1] & 0xFF) : (short)(this.buff[1] << 8 | this.buff[0] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public int readInt() throws IOException {
        if (this.read(this.buff, 0, 4) < 0) {
            throw new EOFException();
        }
        return this.byteOrder == ByteOrder.BIG_ENDIAN ? (this.buff[0] & 0xFF) << 24 | (this.buff[1] & 0xFF) << 16 | (this.buff[2] & 0xFF) << 8 | this.buff[3] & 0xFF : (this.buff[3] & 0xFF) << 24 | (this.buff[2] & 0xFF) << 16 | (this.buff[1] & 0xFF) << 8 | this.buff[0] & 0xFF;
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        if (this.read(this.buff, 0, 8) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int i1 = (this.buff[0] & 0xFF) << 24 | (this.buff[1] & 0xFF) << 16 | (this.buff[2] & 0xFF) << 8 | this.buff[3] & 0xFF;
            int i2 = (this.buff[4] & 0xFF) << 24 | (this.buff[5] & 0xFF) << 16 | (this.buff[6] & 0xFF) << 8 | this.buff[7] & 0xFF;
            return ((long)i1 & 0xFFFFFFFFL) << 32 | (long)i2 & 0xFFFFFFFFL;
        }
        int i1 = (this.buff[3] & 0xFF) << 24 | (this.buff[2] & 0xFF) << 16 | (this.buff[1] & 0xFF) << 8 | this.buff[0] & 0xFF;
        int i2 = (this.buff[7] & 0xFF) << 24 | (this.buff[6] & 0xFF) << 16 | (this.buff[5] & 0xFF) << 8 | this.buff[4] & 0xFF;
        return ((long)i2 & 0xFFFFFFFFL) << 32 | (long)i1 & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean isEmpty = true;
        int c = -1;
        while ((c = this.read()) != -1) {
            isEmpty = false;
            if (c == 10) break;
            if (c == 13) {
                c = this.read();
                if (c == 10 || c == -1) break;
                this.seek(this.getStreamPosition() - 1L);
                break;
            }
            line.append((char)c);
        }
        return isEmpty ? null : line.toString();
    }

    @Override
    public String readUTF() throws IOException {
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        int size = this.readUnsignedShort();
        byte[] buf = new byte[size];
        char[] out = new char[size];
        this.readFully(buf, 0, size);
        this.setByteOrder(byteOrder);
        return new DataInputStream(new ByteArrayInputStream(this.buff)).readUTF();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int i = this.read(b, off, len);
            if (i == -1) {
                throw new EOFException();
            }
            off += i;
            len -= i;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            s[off + i] = this.readShort();
        }
    }

    @Override
    public void readFully(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            c[off + i] = this.readChar();
        }
    }

    @Override
    public void readFully(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int k = 0; k < len; ++k) {
            i[off + k] = this.readInt();
        }
    }

    @Override
    public void readFully(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            l[off + i] = this.readLong();
        }
    }

    @Override
    public void readFully(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            f[off + i] = this.readFloat();
        }
    }

    @Override
    public void readFully(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            d[off + i] = this.readFloat();
        }
    }

    @Override
    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    @Override
    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    @Override
    public void setBitOffset(int bitOffset) throws IOException {
        this.checkClosed();
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException();
        }
        this.bitOffset = bitOffset;
    }

    @Override
    public int readBit() throws IOException {
        this.checkClosed();
        int offset = this.bitOffset;
        int currentByte = this.read();
        if (currentByte == -1) {
            throw new EOFException();
        }
        if ((offset = offset + 1 & 7) != 0) {
            currentByte >>= 8 - offset;
            this.seek(this.getStreamPosition() - 1L);
        }
        this.bitOffset = offset;
        return currentByte & 1;
    }

    @Override
    public long readBits(int numBits) throws IOException {
        this.checkClosed();
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException();
        }
        long res = 0L;
        for (int i = 0; i < numBits; ++i) {
            res <<= 1;
            res |= (long)this.readBit();
        }
        return res;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skipBytes((long)n);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        this.seek(this.getStreamPosition() + n);
        return n;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.getFlushedPosition()) {
            throw new IllegalArgumentException("trying to seek before flushed pos");
        }
        this.bitOffset = 0;
        this.streamPos = pos;
    }

    @Override
    public void mark() {
        try {
            this.posStack.push(this.getStreamPosition());
            this.offsetStack.push(this.getBitOffset());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Stream marking error");
        }
    }

    @Override
    public void reset() throws IOException {
        if (!this.posStack.isEmpty() && !this.offsetStack.isEmpty()) {
            long p = this.posStack.pop();
            if (p < this.flushedPos) {
                throw new IOException("marked position lies in the flushed portion of the stream");
            }
            this.seek(p);
            this.setBitOffset((int)this.offsetStack.pop());
        }
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        long sPos = this.getStreamPosition();
        if (pos > sPos) {
            throw new IndexOutOfBoundsException("Trying to flush outside of current position");
        }
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("Trying to flush within already flushed portion");
        }
        this.flushedPos = pos;
    }

    @Override
    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    @Override
    public long getFlushedPosition() {
        return this.flushedPos;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.checkClosed();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static class PositionStack {
        private static final int SIZE = 10;
        private long[] values = new long[10];
        private int pos = 0;

        private PositionStack() {
        }

        void push(long v) {
            if (this.pos >= this.values.length) {
                this.ensure(this.pos + 1);
            }
            this.values[this.pos++] = v;
        }

        long pop() {
            return this.values[--this.pos];
        }

        boolean isEmpty() {
            return this.pos == 0;
        }

        private void ensure(int size) {
            long[] arr = new long[Math.max(2 * this.values.length, size)];
            System.arraycopy(this.values, 0, arr, 0, this.values.length);
            this.values = arr;
        }
    }
}

