/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.ttf;

import android.graphics.Path;
import com.tom_roush.fontbox.FontBoxFont;
import com.tom_roush.fontbox.ttf.CmapSubtable;
import com.tom_roush.fontbox.ttf.CmapTable;
import com.tom_roush.fontbox.ttf.GlyphData;
import com.tom_roush.fontbox.ttf.GlyphTable;
import com.tom_roush.fontbox.ttf.HeaderTable;
import com.tom_roush.fontbox.ttf.HorizontalHeaderTable;
import com.tom_roush.fontbox.ttf.HorizontalMetricsTable;
import com.tom_roush.fontbox.ttf.IndexToLocationTable;
import com.tom_roush.fontbox.ttf.KerningTable;
import com.tom_roush.fontbox.ttf.MaximumProfileTable;
import com.tom_roush.fontbox.ttf.NamingTable;
import com.tom_roush.fontbox.ttf.OS2WindowsMetricsTable;
import com.tom_roush.fontbox.ttf.PostScriptTable;
import com.tom_roush.fontbox.ttf.TTFDataStream;
import com.tom_roush.fontbox.ttf.TTFTable;
import com.tom_roush.fontbox.ttf.VerticalHeaderTable;
import com.tom_roush.fontbox.ttf.VerticalMetricsTable;
import com.tom_roush.fontbox.ttf.VerticalOriginTable;
import com.tom_roush.fontbox.util.BoundingBox;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrueTypeFont
implements FontBoxFont,
Closeable {
    private float version;
    private int numberOfGlyphs = -1;
    private int unitsPerEm = -1;
    protected Map<String, TTFTable> tables = new HashMap<String, TTFTable>();
    private final TTFDataStream data;
    private Map<String, Integer> postScriptNames;

    TrueTypeFont(TTFDataStream fontData) {
        this.data = fontData;
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    public float getVersion() {
        return this.version;
    }

    void setVersion(float versionValue) {
        this.version = versionValue;
    }

    void addTable(TTFTable table) {
        this.tables.put(table.getTag(), table);
    }

    public Collection<TTFTable> getTables() {
        return this.tables.values();
    }

    public Map<String, TTFTable> getTableMap() {
        return this.tables;
    }

    public synchronized byte[] getTableBytes(TTFTable table) throws IOException {
        long currentPosition = this.data.getCurrentPosition();
        this.data.seek(table.getOffset());
        byte[] bytes = this.data.read((int)table.getLength());
        this.data.seek(currentPosition);
        return bytes;
    }

    protected synchronized TTFTable getTable(String tag) throws IOException {
        TTFTable ttfTable = this.tables.get(tag);
        if (ttfTable != null && !ttfTable.getInitialized()) {
            this.readTable(ttfTable);
        }
        return ttfTable;
    }

    public NamingTable getNaming() throws IOException {
        return (NamingTable)this.getTable("name");
    }

    public PostScriptTable getPostScript() throws IOException {
        return (PostScriptTable)this.getTable("post");
    }

    public OS2WindowsMetricsTable getOS2Windows() throws IOException {
        return (OS2WindowsMetricsTable)this.getTable("OS/2");
    }

    public MaximumProfileTable getMaximumProfile() throws IOException {
        return (MaximumProfileTable)this.getTable("maxp");
    }

    public HeaderTable getHeader() throws IOException {
        return (HeaderTable)this.getTable("head");
    }

    public HorizontalHeaderTable getHorizontalHeader() throws IOException {
        return (HorizontalHeaderTable)this.getTable("hhea");
    }

    public HorizontalMetricsTable getHorizontalMetrics() throws IOException {
        return (HorizontalMetricsTable)this.getTable("hmtx");
    }

    public IndexToLocationTable getIndexToLocation() throws IOException {
        return (IndexToLocationTable)this.getTable("loca");
    }

    public GlyphTable getGlyph() throws IOException {
        return (GlyphTable)this.getTable("glyf");
    }

    public CmapTable getCmap() throws IOException {
        return (CmapTable)this.getTable("cmap");
    }

    public VerticalHeaderTable getVerticalHeader() throws IOException {
        return (VerticalHeaderTable)this.getTable("vhea");
    }

    public VerticalMetricsTable getVerticalMetrics() throws IOException {
        return (VerticalMetricsTable)this.getTable("vmtx");
    }

    public VerticalOriginTable getVerticalOrigin() throws IOException {
        return (VerticalOriginTable)this.getTable("VORG");
    }

    public KerningTable getKerning() throws IOException {
        return (KerningTable)this.getTable("kern");
    }

    public InputStream getOriginalData() throws IOException {
        return this.data.getOriginalData();
    }

    void readTable(TTFTable table) throws IOException {
        long currentPosition = this.data.getCurrentPosition();
        this.data.seek(table.getOffset());
        table.read(this, this.data);
        this.data.seek(currentPosition);
    }

    public int getNumberOfGlyphs() throws IOException {
        if (this.numberOfGlyphs == -1) {
            MaximumProfileTable maximumProfile = this.getMaximumProfile();
            this.numberOfGlyphs = maximumProfile != null ? maximumProfile.getNumGlyphs() : 0;
        }
        return this.numberOfGlyphs;
    }

    public int getUnitsPerEm() throws IOException {
        if (this.unitsPerEm == -1) {
            HeaderTable header = this.getHeader();
            this.unitsPerEm = header != null ? header.getUnitsPerEm() : 0;
        }
        return this.unitsPerEm;
    }

    public int getAdvanceWidth(int gid) throws IOException {
        HorizontalMetricsTable hmtx = this.getHorizontalMetrics();
        if (hmtx != null) {
            return hmtx.getAdvanceWidth(gid);
        }
        return 250;
    }

    public int getAdvanceHeight(int gid) throws IOException {
        VerticalMetricsTable vmtx = this.getVerticalMetrics();
        if (vmtx != null) {
            return vmtx.getAdvanceHeight(gid);
        }
        return 250;
    }

    @Override
    public String getName() throws IOException {
        if (this.getNaming() != null) {
            return this.getNaming().getPostScriptName();
        }
        return null;
    }

    private synchronized void readPostScriptNames() throws IOException {
        if (this.postScriptNames == null && this.getPostScript() != null) {
            String[] names = this.getPostScript().getGlyphNames();
            if (names != null) {
                this.postScriptNames = new HashMap<String, Integer>(names.length);
                for (int i = 0; i < names.length; ++i) {
                    this.postScriptNames.put(names[i], i);
                }
            } else {
                this.postScriptNames = new HashMap<String, Integer>();
            }
        }
    }

    public CmapSubtable getUnicodeCmap() throws IOException {
        return this.getUnicodeCmap(true);
    }

    public CmapSubtable getUnicodeCmap(boolean isStrict) throws IOException {
        CmapTable cmapTable = this.getCmap();
        if (cmapTable == null) {
            if (isStrict) {
                throw new IOException("The TrueType font does not contain a 'cmap' table");
            }
            return null;
        }
        CmapSubtable cmap = cmapTable.getSubtable(0, 4);
        if (cmap == null) {
            cmap = cmapTable.getSubtable(0, 3);
        }
        if (cmap == null) {
            cmap = cmapTable.getSubtable(3, 1);
        }
        if (cmap == null) {
            cmap = cmapTable.getSubtable(3, 0);
        }
        if (cmap == null) {
            if (isStrict) {
                throw new IOException("The TrueType font does not contain a Unicode cmap");
            }
            if (cmapTable.getCmaps().length > 0) {
                cmap = cmapTable.getCmaps()[0];
            }
        }
        return cmap;
    }

    public int nameToGID(String name) throws IOException {
        Integer gid;
        this.readPostScriptNames();
        if (this.postScriptNames != null && (gid = this.postScriptNames.get(name)) != null && gid > 0 && gid < this.getMaximumProfile().getNumGlyphs()) {
            return gid;
        }
        int uni = this.parseUniName(name);
        if (uni > -1) {
            CmapSubtable cmap = this.getUnicodeCmap(false);
            return cmap.getGlyphId(uni);
        }
        return 0;
    }

    private int parseUniName(String name) throws IOException {
        if (name.startsWith("uni") && name.length() == 7) {
            int nameLength = name.length();
            StringBuilder uniStr = new StringBuilder();
            try {
                int chPos = 3;
                while (chPos + 4 <= nameLength) {
                    int codePoint = Integer.parseInt(name.substring(chPos, chPos + 4), 16);
                    if (codePoint <= 55295 || codePoint >= 57344) {
                        uniStr.append((char)codePoint);
                    }
                    chPos += 4;
                }
                String unicode = uniStr.toString();
                if (unicode.length() == 0) {
                    return -1;
                }
                return unicode.codePointAt(0);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public Path getPath(String name) throws IOException {
        int gid = this.nameToGID(name);
        GlyphData glyph = this.getGlyph().getGlyph(gid);
        if (glyph == null) {
            return new Path();
        }
        return glyph.getPath();
    }

    @Override
    public float getWidth(String name) throws IOException {
        Integer gid = this.nameToGID(name);
        return this.getAdvanceWidth(gid);
    }

    @Override
    public boolean hasGlyph(String name) throws IOException {
        return this.nameToGID(name) != 0;
    }

    @Override
    public BoundingBox getFontBBox() throws IOException {
        short xMin = this.getHeader().getXMin();
        short xMax = this.getHeader().getXMax();
        short yMin = this.getHeader().getYMin();
        short yMax = this.getHeader().getYMax();
        float scale = 1000.0f / (float)this.getUnitsPerEm();
        return new BoundingBox((float)xMin * scale, (float)yMin * scale, (float)xMax * scale, (float)yMax * scale);
    }

    @Override
    public List<Number> getFontMatrix() throws IOException {
        float scale = 1000.0f / (float)this.getUnitsPerEm();
        return Arrays.asList(Float.valueOf(0.001f * scale), 0, 0, Float.valueOf(0.001f * scale), 0, 0);
    }

    public String toString() {
        try {
            if (this.getNaming() != null) {
                return this.getNaming().getPostScriptName();
            }
            return "(null)";
        }
        catch (IOException e) {
            return "(null - " + e.getMessage() + ")";
        }
    }
}

