/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.visible;

import android.graphics.Bitmap;
import android.util.Log;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDFormXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.image.LosslessFactory;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImageXObject;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.visible.PDFTemplateBuilder;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.visible.PDFTemplateStructure;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDSignatureField;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class PDVisibleSigBuilder
implements PDFTemplateBuilder {
    private final PDFTemplateStructure pdfStructure = new PDFTemplateStructure();

    public PDVisibleSigBuilder() {
        Log.i((String)"PdfBox-Android", (String)"PDF Structure has been created");
    }

    @Override
    public void createPage(PDVisibleSignDesigner properties) {
        PDPage page = new PDPage(new PDRectangle(properties.getPageWidth(), properties.getPageHeight()));
        this.pdfStructure.setPage(page);
        Log.i((String)"PdfBox-Android", (String)"PDF page has been created");
    }

    @Override
    public void createTemplate(PDPage page) throws IOException {
        PDDocument template = new PDDocument();
        template.addPage(page);
        this.pdfStructure.setTemplate(template);
    }

    @Override
    public void createAcroForm(PDDocument template) {
        PDAcroForm theAcroForm = new PDAcroForm(template);
        template.getDocumentCatalog().setAcroForm(theAcroForm);
        this.pdfStructure.setAcroForm(theAcroForm);
        Log.i((String)"PdfBox-Android", (String)"AcroForm has been created");
    }

    @Override
    public PDFTemplateStructure getStructure() {
        return this.pdfStructure;
    }

    @Override
    public void createSignatureField(PDAcroForm acroForm) throws IOException {
        PDSignatureField sf = new PDSignatureField(acroForm);
        this.pdfStructure.setSignatureField(sf);
        Log.i((String)"PdfBox-Android", (String)"Signature field has been created");
    }

    @Override
    public void createSignature(PDSignatureField pdSignatureField, PDPage page, String signerName) throws IOException {
        PDSignature pdSignature = new PDSignature();
        PDAnnotationWidget widget = pdSignatureField.getWidgets().get(0);
        pdSignatureField.setValue(pdSignature);
        widget.setPage(page);
        page.getAnnotations().add(widget);
        if (!signerName.isEmpty()) {
            pdSignature.setName(signerName);
        }
        this.pdfStructure.setPdSignature(pdSignature);
        Log.i((String)"PdfBox-Android", (String)"PDSignature has been created");
    }

    @Override
    public void createAcroFormDictionary(PDAcroForm acroForm, PDSignatureField signatureField) throws IOException {
        List<PDField> acroFormFields = acroForm.getFields();
        COSDictionary acroFormDict = acroForm.getCOSObject();
        acroForm.setSignaturesExist(true);
        acroForm.setAppendOnly(true);
        acroFormDict.setDirect(true);
        acroFormFields.add(signatureField);
        acroForm.setDefaultAppearance("/sylfaen 0 Tf 0 g");
        this.pdfStructure.setAcroFormFields(acroFormFields);
        this.pdfStructure.setAcroFormDictionary(acroFormDict);
        Log.i((String)"PdfBox-Android", (String)"AcroForm dictionary has been created");
    }

    @Override
    public void createSignatureRectangle(PDSignatureField signatureField, PDVisibleSignDesigner properties) throws IOException {
        PDRectangle rect = new PDRectangle();
        rect.setUpperRightX(properties.getxAxis() + properties.getWidth());
        rect.setUpperRightY(properties.getTemplateHeight() - properties.getyAxis());
        rect.setLowerLeftY(properties.getTemplateHeight() - properties.getyAxis() - properties.getHeight());
        rect.setLowerLeftX(properties.getxAxis());
        signatureField.getWidgets().get(0).setRectangle(rect);
        this.pdfStructure.setSignatureRectangle(rect);
        Log.i((String)"PdfBox-Android", (String)"Signature rectangle has been created");
    }

    @Override
    public void createAffineTransform(byte[] params) {
        AffineTransform transform = new AffineTransform(params[0], params[1], params[2], params[3], params[4], params[5]);
        this.pdfStructure.setAffineTransform(transform);
        Log.i((String)"PdfBox-Android", (String)"Matrix has been added");
    }

    @Override
    public void createProcSetArray() {
        COSArray procSetArr = new COSArray();
        procSetArr.add(COSName.getPDFName("PDF"));
        procSetArr.add(COSName.getPDFName("Text"));
        procSetArr.add(COSName.getPDFName("ImageB"));
        procSetArr.add(COSName.getPDFName("ImageC"));
        procSetArr.add(COSName.getPDFName("ImageI"));
        this.pdfStructure.setProcSet(procSetArr);
        Log.i((String)"PdfBox-Android", (String)"ProcSet array has been created");
    }

    @Override
    public void createSignatureImage(PDDocument template, Bitmap image) throws IOException {
        this.pdfStructure.setImage(LosslessFactory.createFromImage(template, image));
        Log.i((String)"PdfBox-Android", (String)"Visible Signature Image has been created");
    }

    @Override
    public void createFormatterRectangle(byte[] params) {
        PDRectangle formatterRectangle = new PDRectangle();
        formatterRectangle.setUpperRightX(params[0]);
        formatterRectangle.setUpperRightY(params[1]);
        formatterRectangle.setLowerLeftX(params[2]);
        formatterRectangle.setLowerLeftY(params[3]);
        this.pdfStructure.setFormatterRectangle(formatterRectangle);
        Log.i((String)"PdfBox-Android", (String)"Formatter rectangle has been created");
    }

    @Override
    public void createHolderFormStream(PDDocument template) {
        PDStream holderForm = new PDStream(template);
        this.pdfStructure.setHolderFormStream(holderForm);
        Log.i((String)"PdfBox-Android", (String)"Holder form stream has been created");
    }

    @Override
    public void createHolderFormResources() {
        PDResources holderFormResources = new PDResources();
        this.pdfStructure.setHolderFormResources(holderFormResources);
        Log.i((String)"PdfBox-Android", (String)"Holder form resources have been created");
    }

    @Override
    public void createHolderForm(PDResources holderFormResources, PDStream holderFormStream, PDRectangle formrect) {
        PDFormXObject holderForm = new PDFormXObject(holderFormStream);
        holderForm.setResources(holderFormResources);
        holderForm.setBBox(formrect);
        holderForm.setFormType(1);
        this.pdfStructure.setHolderForm(holderForm);
        Log.i((String)"PdfBox-Android", (String)"Holder form has been created");
    }

    @Override
    public void createAppearanceDictionary(PDFormXObject holderForml, PDSignatureField signatureField) throws IOException {
        PDAppearanceDictionary appearance = new PDAppearanceDictionary();
        appearance.getCOSObject().setDirect(true);
        PDAppearanceStream appearanceStream = new PDAppearanceStream(holderForml.getCOSObject());
        appearance.setNormalAppearance(appearanceStream);
        signatureField.getWidgets().get(0).setAppearance(appearance);
        this.pdfStructure.setAppearanceDictionary(appearance);
        Log.i((String)"PdfBox-Android", (String)"PDF appearance dictionary has been created");
    }

    @Override
    public void createInnerFormStream(PDDocument template) {
        PDStream innerFormStream = new PDStream(template);
        this.pdfStructure.setInnterFormStream(innerFormStream);
        Log.i((String)"PdfBox-Android", (String)"Stream of another form (inner form - it will be inside holder form) has been created");
    }

    @Override
    public void createInnerFormResource() {
        PDResources innerFormResources = new PDResources();
        this.pdfStructure.setInnerFormResources(innerFormResources);
        Log.i((String)"PdfBox-Android", (String)"Resources of another form (inner form - it will be inside holder form)have been created");
    }

    @Override
    public void createInnerForm(PDResources innerFormResources, PDStream innerFormStream, PDRectangle formrect) {
        PDFormXObject innerForm = new PDFormXObject(innerFormStream);
        innerForm.setResources(innerFormResources);
        innerForm.setBBox(formrect);
        innerForm.setFormType(1);
        this.pdfStructure.setInnerForm(innerForm);
        Log.i((String)"PdfBox-Android", (String)"Another form (inner form - it will be inside holder form) has been created");
    }

    @Override
    public void insertInnerFormToHolderResources(PDFormXObject innerForm, PDResources holderFormResources) {
        COSName innerFormName = holderFormResources.add(innerForm, "FRM");
        this.pdfStructure.setInnerFormName(innerFormName);
        Log.i((String)"PdfBox-Android", (String)"Now inserted inner form inside holder form");
    }

    @Override
    public void createImageFormStream(PDDocument template) {
        PDStream imageFormStream = new PDStream(template);
        this.pdfStructure.setImageFormStream(imageFormStream);
        Log.i((String)"PdfBox-Android", (String)"Created image form stream");
    }

    @Override
    public void createImageFormResources() {
        PDResources imageFormResources = new PDResources();
        this.pdfStructure.setImageFormResources(imageFormResources);
        Log.i((String)"PdfBox-Android", (String)"Created image form resources");
    }

    @Override
    public void createImageForm(PDResources imageFormResources, PDResources innerFormResource, PDStream imageFormStream, PDRectangle formrect, AffineTransform at, PDImageXObject img) throws IOException {
        PDFormXObject imageForm = new PDFormXObject(imageFormStream);
        imageForm.setBBox(formrect);
        imageForm.setMatrix(at);
        imageForm.setResources(imageFormResources);
        imageForm.setFormType(1);
        imageFormResources.getCOSObject().setDirect(true);
        COSName imageFormName = innerFormResource.add(imageForm, "n");
        COSName imageName = imageFormResources.add(img, "img");
        this.pdfStructure.setImageForm(imageForm);
        this.pdfStructure.setImageFormName(imageFormName);
        this.pdfStructure.setImageName(imageName);
        Log.i((String)"PdfBox-Android", (String)"Created image form");
    }

    @Override
    public void injectProcSetArray(PDFormXObject innerForm, PDPage page, PDResources innerFormResources, PDResources imageFormResources, PDResources holderFormResources, COSArray procSet) {
        innerForm.getResources().getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        page.getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        innerFormResources.getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        imageFormResources.getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        holderFormResources.getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        Log.i((String)"PdfBox-Android", (String)"Inserted ProcSet to PDF");
    }

    @Override
    public void injectAppearanceStreams(PDStream holderFormStream, PDStream innerFormStream, PDStream imageFormStream, COSName imageObjectName, COSName imageName, COSName innerFormName, PDVisibleSignDesigner properties) throws IOException {
        String imgFormContent = "q 100 0 0 50 0 0 cm /" + imageName.getName() + " Do Q\n";
        String holderFormContent = "q 1 0 0 1 0 0 cm /" + innerFormName.getName() + " Do Q\n";
        String innerFormContent = "q 1 0 0 1 0 0 cm /" + imageObjectName.getName() + " Do Q\n";
        this.appendRawCommands(this.pdfStructure.getHolderFormStream().createOutputStream(), holderFormContent);
        this.appendRawCommands(this.pdfStructure.getInnerFormStream().createOutputStream(), innerFormContent);
        this.appendRawCommands(this.pdfStructure.getImageFormStream().createOutputStream(), imgFormContent);
        Log.i((String)"PdfBox-Android", (String)"Injected appearance stream to pdf");
    }

    public void appendRawCommands(OutputStream os, String commands) throws IOException {
        os.write(commands.getBytes("UTF-8"));
        os.close();
    }

    @Override
    public void createVisualSignature(PDDocument template) {
        this.pdfStructure.setVisualSignature(template.getDocument());
        Log.i((String)"PdfBox-Android", (String)"Visible signature has been created");
    }

    @Override
    public void createWidgetDictionary(PDSignatureField signatureField, PDResources holderFormResources) throws IOException {
        COSDictionary widgetDict = signatureField.getWidgets().get(0).getCOSObject();
        widgetDict.setNeedToBeUpdated(true);
        widgetDict.setItem(COSName.DR, (COSBase)holderFormResources.getCOSObject());
        this.pdfStructure.setWidgetDictionary(widgetDict);
        Log.i((String)"PdfBox-Android", (String)"WidgetDictionary has been created");
    }

    @Override
    public void closeTemplate(PDDocument template) throws IOException {
        template.close();
        this.pdfStructure.getTemplate().close();
    }
}

