/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.pdmodel.common.COSArrayList;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDTerminalField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PDButton
extends PDTerminalField {
    static final int FLAG_RADIO = 32768;
    static final int FLAG_PUSHBUTTON = 65536;
    static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public PDButton(PDAcroForm acroForm) {
        super(acroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.BTN);
    }

    PDButton(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public boolean isPushButton() {
        return this.getCOSObject().getFlag(COSName.FF, 65536);
    }

    public void setPushButton(boolean pushbutton) {
        this.getCOSObject().setFlag(COSName.FF, 65536, pushbutton);
    }

    public boolean isRadioButton() {
        return this.getCOSObject().getFlag(COSName.FF, 32768);
    }

    public void setRadioButton(boolean radiobutton) {
        this.getCOSObject().setFlag(COSName.FF, 32768, radiobutton);
    }

    public String getValue() {
        COSBase value = this.getInheritableAttribute(COSName.V);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    @Override
    public void setValue(String value) throws IOException {
        boolean hasExportValues;
        this.checkValue(value);
        boolean bl = hasExportValues = this.getExportValues().size() > 0;
        if (hasExportValues) {
            this.updateByOption(value);
        } else {
            this.updateByValue(value);
        }
        this.applyChange();
    }

    public String getDefaultValue() {
        COSBase value = this.getInheritableAttribute(COSName.DV);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    public void setDefaultValue(String value) {
        this.checkValue(value);
        this.getCOSObject().setName(COSName.DV, value);
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public List<String> getExportValues() {
        COSBase value = this.getInheritableAttribute(COSName.OPT);
        if (value instanceof COSString) {
            ArrayList<String> array = new ArrayList<String>();
            array.add(((COSString)value).getString());
            return array;
        }
        if (value instanceof COSArray) {
            return COSArrayList.convertCOSStringCOSArrayToList((COSArray)value);
        }
        return Collections.emptyList();
    }

    public void setExportValues(List<String> values) {
        if (values != null && !values.isEmpty()) {
            COSArray cosValues = COSArrayList.convertStringListToCOSStringCOSArray(values);
            this.getCOSObject().setItem(COSName.OPT, (COSBase)cosValues);
        } else {
            this.getCOSObject().removeItem(COSName.OPT);
        }
    }

    @Override
    void constructAppearances() throws IOException {
        List<String> exportValues = this.getExportValues();
        if (exportValues.size() > 0) {
            try {
                int optionsIndex = Integer.parseInt(this.getValue());
                if (optionsIndex < exportValues.size()) {
                    this.updateByOption(exportValues.get(optionsIndex));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.updateByValue(this.getValue());
        }
    }

    public Set<String> getOnValues() {
        HashSet<String> onValues = new HashSet<String>();
        if (this.getExportValues().size() > 0) {
            onValues.addAll(this.getExportValues());
            return onValues;
        }
        List<PDAnnotationWidget> widgets = this.getWidgets();
        for (PDAnnotationWidget widget : widgets) {
            PDAppearanceEntry normalAppearance;
            PDAppearanceDictionary apDictionary = widget.getAppearance();
            if (apDictionary == null || (normalAppearance = apDictionary.getNormalAppearance()) == null) continue;
            Set<COSName> entries = normalAppearance.getSubDictionary().keySet();
            for (COSName entry : entries) {
                if (COSName.Off.compareTo(entry) == 0) continue;
                onValues.add(entry.getName());
            }
        }
        return onValues;
    }

    void checkValue(String value) throws IllegalArgumentException {
        Set<String> onValues = this.getOnValues();
        if (COSName.Off.getName().compareTo(value) != 0 && !onValues.contains(value)) {
            throw new IllegalArgumentException("value '" + value + "' is not a valid option for the field " + this.getFullyQualifiedName() + ", valid values are: " + onValues + " and " + COSName.Off.getName());
        }
    }

    private void updateByValue(String value) throws IOException {
        this.getCOSObject().setName(COSName.V, value);
        for (PDAnnotationWidget widget : this.getWidgets()) {
            PDAppearanceEntry appearanceEntry = widget.getAppearance().getNormalAppearance();
            if (((COSDictionary)appearanceEntry.getCOSObject()).containsKey(value)) {
                widget.getCOSObject().setName(COSName.AS, value);
                continue;
            }
            widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
        }
    }

    private void updateByOption(String value) throws IOException {
        List<PDAnnotationWidget> widgets = this.getWidgets();
        List<String> options = this.getExportValues();
        if (widgets.size() != options.size()) {
            throw new IllegalArgumentException("The number of options doesn't match the number of widgets");
        }
        int optionsIndex = options.indexOf(value);
        this.getCOSObject().setName(COSName.V, String.valueOf(optionsIndex));
        for (int i = 0; i < widgets.size(); ++i) {
            PDAnnotationWidget widget = widgets.get(i);
            if (value.compareTo(options.get(i)) == 0) {
                widget.getCOSObject().setName(COSName.AS, String.valueOf(i));
                continue;
            }
            widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
        }
    }
}

