/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdfparser;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNull;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.cos.COSObjectKey;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.io.RandomAccessRead;
import com.tom_roush.pdfbox.pdfparser.BaseParser;
import com.tom_roush.pdfbox.pdfparser.EndstreamOutputStream;
import com.tom_roush.pdfbox.pdfparser.PDFObjectStreamParser;
import com.tom_roush.pdfbox.pdfparser.PDFXrefStreamParser;
import com.tom_roush.pdfbox.pdfparser.RandomAccessSource;
import com.tom_roush.pdfbox.pdfparser.XrefTrailerResolver;
import com.tom_roush.pdfbox.pdmodel.encryption.SecurityHandler;
import com.tom_roush.pdfbox.util.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class COSParser
extends BaseParser {
    private static final String PDF_HEADER = "%PDF-";
    private static final String FDF_HEADER = "%FDF-";
    private static final String PDF_DEFAULT_VERSION = "1.4";
    private static final String FDF_DEFAULT_VERSION = "1.0";
    private static final char[] XREF_TABLE = new char[]{'x', 'r', 'e', 'f'};
    private static final char[] XREF_STREAM = new char[]{'/', 'X', 'R', 'e', 'f'};
    private static final char[] STARTXREF = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    private static final byte[] ENDSTREAM = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    private static final byte[] ENDOBJ = new byte[]{101, 110, 100, 111, 98, 106};
    private static final long MINIMUM_SEARCH_OFFSET = 6L;
    private static final int X = 120;
    private static final int STRMBUFLEN = 2048;
    private final byte[] strmBuf = new byte[2048];
    protected final RandomAccessRead source;
    public static final String SYSPROP_PARSEMINIMAL = "com.tom_roush.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal";
    public static final String SYSPROP_EOFLOOKUPRANGE = "com.tom_roush.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private long trailerOffset;
    protected long fileLen;
    private boolean isLenient = true;
    protected boolean initialParseDone = false;
    private Map<COSObjectKey, Long> bfSearchCOSObjectKeyOffsets = null;
    private Long lastEOFMarker = null;
    private List<Long> bfSearchXRefTablesOffsets = null;
    private List<Long> bfSearchXRefStreamsOffsets = null;
    protected SecurityHandler securityHandler = null;
    private int readTrailBytes = 2048;
    protected XrefTrailerResolver xrefTrailerResolver = new XrefTrailerResolver();
    public static final String TMP_FILE_PREFIX = "tmpPDF";
    private static final int STREAMCOPYBUFLEN = 8192;
    private final byte[] streamCopyBuf = new byte[8192];

    public COSParser(RandomAccessRead source) {
        super(new RandomAccessSource(source));
        this.source = source;
    }

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected COSDictionary parseXref(long startXRefOffset) throws IOException {
        COSDictionary trailer;
        this.source.seek(startXRefOffset);
        long startXrefOffset = Math.max(0L, this.parseStartXref());
        long fixedOffset = this.checkXRefOffset(startXrefOffset);
        if (fixedOffset > -1L) {
            startXrefOffset = fixedOffset;
        }
        this.document.setStartXref(startXrefOffset);
        long prev = startXrefOffset;
        long lastPrev = -1L;
        while (prev > 0L && prev != lastPrev) {
            lastPrev = prev;
            this.source.seek(prev);
            this.skipSpaces();
            if (this.source.peek() == 120) {
                this.parseXrefTable(prev);
                this.trailerOffset = this.source.getPosition();
                if (this.isLenient) {
                    int nextCharacter = this.source.peek();
                    while (nextCharacter != 116 && COSParser.isDigit(nextCharacter)) {
                        if (this.source.getPosition() == this.trailerOffset) {
                            Log.w((String)"PdfBox-Android", (String)("Expected trailer object at position " + this.trailerOffset + ", keep trying"));
                        }
                        this.readLine();
                        nextCharacter = this.source.peek();
                    }
                }
                if (!this.parseTrailer()) {
                    throw new IOException("Expected trailer object at position: " + this.source.getPosition());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                if (trailer.containsKey(COSName.XREF_STM)) {
                    int streamOffset = trailer.getInt(COSName.XREF_STM);
                    fixedOffset = this.checkXRefOffset(streamOffset);
                    if (fixedOffset > -1L && fixedOffset != (long)streamOffset) {
                        Log.w((String)"PdfBox-Android", (String)("/XRefStm offset " + streamOffset + " is incorrect, corrected to " + fixedOffset));
                        streamOffset = (int)fixedOffset;
                        trailer.setInt(COSName.XREF_STM, streamOffset);
                    }
                    if (streamOffset > 0) {
                        this.source.seek(streamOffset);
                        this.skipSpaces();
                        try {
                            this.parseXrefObjStream(prev, false);
                        }
                        catch (IOException ex) {
                            if (this.isLenient) {
                                Log.e((String)"PdfBox-Android", (String)("Failed to parse /XRefStm at offset " + streamOffset), (Throwable)ex);
                            }
                            throw ex;
                        }
                    } else if (this.isLenient) {
                        Log.e((String)"PdfBox-Android", (String)("Skipped XRef stream due to a corrupt offset:" + streamOffset));
                    } else {
                        throw new IOException("Skipped XRef stream due to a corrupt offset:" + streamOffset);
                    }
                }
                if ((prev = trailer.getLong(COSName.PREV)) <= 0L || (fixedOffset = this.checkXRefOffset(prev)) <= -1L || fixedOffset == prev) continue;
                prev = fixedOffset;
                trailer.setLong(COSName.PREV, prev);
                continue;
            }
            if ((prev = this.parseXrefObjStream(prev, true)) <= 0L || (fixedOffset = this.checkXRefOffset(prev)) <= -1L || fixedOffset == prev) continue;
            prev = fixedOffset;
            trailer = this.xrefTrailerResolver.getCurrentTrailer();
            trailer.setLong(COSName.PREV, prev);
        }
        if (prev == lastPrev) {
            throw new IOException("/Prev loop at offset " + prev);
        }
        this.xrefTrailerResolver.setStartxref(startXrefOffset);
        trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        this.document.setIsXRefStream(XrefTrailerResolver.XRefType.STREAM == this.xrefTrailerResolver.getXrefType());
        this.checkXrefOffsets();
        this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
        return trailer;
    }

    private long parseXrefObjStream(long objByteOffset, boolean isStandalone) throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        COSDictionary dict = this.parseCOSDictionary();
        COSStream xrefStream = this.parseCOSStream(dict);
        this.parseXrefStream(xrefStream, objByteOffset, isStandalone);
        xrefStream.close();
        return dict.getLong(COSName.PREV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getStartxrefOffset() throws IOException {
        long skipBytes;
        byte[] buf;
        try {
            int readBytes;
            int trailByteCount = this.fileLen < (long)this.readTrailBytes ? (int)this.fileLen : this.readTrailBytes;
            buf = new byte[trailByteCount];
            skipBytes = this.fileLen - (long)trailByteCount;
            this.source.seek(skipBytes);
            for (int off = 0; off < trailByteCount; off += readBytes) {
                readBytes = this.source.read(buf, off, trailByteCount - off);
                if (readBytes >= 1) continue;
                throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
            }
        }
        finally {
            this.source.seek(0L);
        }
        int bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length);
        if (bufOff < 0) {
            if (this.isLenient) {
                bufOff = buf.length;
                Log.d((String)"PdfBox-Android", (String)("Missing end of file marker '" + new String(EOF_MARKER) + "'"));
            } else {
                throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
            }
        }
        bufOff = this.lastIndexOf(STARTXREF, buf, bufOff);
        long startXRefOffset = skipBytes + (long)bufOff;
        if (bufOff < 0) {
            if (this.isLenient) {
                Log.d((String)"PdfBox-Android", (String)"Can't find offset for startxref");
                return -1L;
            }
            throw new IOException("Missing 'startxref' marker.");
        }
        return startXRefOffset;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) {
        if (this.initialParseDone) {
            throw new IllegalArgumentException("Cannot change leniency after parsing");
        }
        this.isLenient = lenient;
    }

    private long getObjectId(COSObject obj) {
        return obj.getObjectNumber() << 32 | (long)obj.getGenerationNumber();
    }

    private void addNewToList(Queue<COSBase> toBeParsedList, Collection<COSBase> newObjects, Set<Long> addedObjects) {
        for (COSBase newObject : newObjects) {
            this.addNewToList(toBeParsedList, newObject, addedObjects);
        }
    }

    private void addNewToList(Queue<COSBase> toBeParsedList, COSBase newObject, Set<Long> addedObjects) {
        long objId;
        if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) {
            return;
        }
        toBeParsedList.add(newObject);
    }

    protected void parseDictObjects(COSDictionary dict, COSName ... excludeObjects) throws IOException {
        LinkedList<COSBase> toBeParsedList = new LinkedList<COSBase>();
        TreeMap<Long, List<COSObject>> objToBeParsed = new TreeMap<Long, List<COSObject>>();
        HashSet<Long> parsedObjects = new HashSet<Long>();
        HashSet<Long> addedObjects = new HashSet<Long>();
        this.addExcludedToList(excludeObjects, dict, parsedObjects);
        this.addNewToList(toBeParsedList, dict.getValues(), addedObjects);
        while (!toBeParsedList.isEmpty() || !objToBeParsed.isEmpty()) {
            COSBase baseObj;
            while ((baseObj = (COSBase)toBeParsedList.poll()) != null) {
                if (baseObj instanceof COSDictionary) {
                    this.addNewToList(toBeParsedList, ((COSDictionary)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSArray) {
                    for (COSBase cosBase : (COSArray)baseObj) {
                        this.addNewToList(toBeParsedList, cosBase, addedObjects);
                    }
                    continue;
                }
                if (!(baseObj instanceof COSObject)) continue;
                COSObject obj = (COSObject)baseObj;
                long objId = this.getObjectId(obj);
                COSObjectKey objKey = new COSObjectKey(obj.getObjectNumber(), obj.getGenerationNumber());
                if (parsedObjects.contains(objId)) continue;
                Long fileOffset = this.xrefTrailerResolver.getXrefTable().get(objKey);
                if (fileOffset != null && fileOffset != 0L) {
                    if (fileOffset > 0L) {
                        objToBeParsed.put(fileOffset, Collections.singletonList(obj));
                        continue;
                    }
                    fileOffset = this.xrefTrailerResolver.getXrefTable().get(new COSObjectKey((int)(-fileOffset.longValue()), 0));
                    if (fileOffset == null || fileOffset <= 0L) {
                        throw new IOException("Invalid object stream xref object reference for key '" + objKey + "': " + fileOffset);
                    }
                    ArrayList<COSObject> stmObjects = (ArrayList<COSObject>)objToBeParsed.get(fileOffset);
                    if (stmObjects == null) {
                        stmObjects = new ArrayList<COSObject>();
                        objToBeParsed.put(fileOffset, stmObjects);
                    }
                    stmObjects.add(obj);
                    continue;
                }
                COSObject pdfObject = this.document.getObjectFromPool(objKey);
                pdfObject.setObject(COSNull.NULL);
            }
            if (objToBeParsed.isEmpty()) break;
            for (COSObject obj : (List)objToBeParsed.remove(objToBeParsed.firstKey())) {
                COSBase parsedObj = this.parseObjectDynamically(obj, false);
                if (parsedObj == null) continue;
                obj.setObject(parsedObj);
                this.addNewToList(toBeParsedList, parsedObj, addedObjects);
                parsedObjects.add(this.getObjectId(obj));
            }
        }
    }

    private void addExcludedToList(COSName[] excludeObjects, COSDictionary dict, Set<Long> parsedObjects) {
        if (excludeObjects != null) {
            for (COSName objName : excludeObjects) {
                COSBase baseObj = dict.getItem(objName);
                if (!(baseObj instanceof COSObject)) continue;
                parsedObjects.add(this.getObjectId((COSObject)baseObj));
            }
        }
    }

    protected final COSBase parseObjectDynamically(COSObject obj, boolean requireExistingNotCompressedObj) throws IOException {
        return this.parseObjectDynamically(obj.getObjectNumber(), obj.getGenerationNumber(), requireExistingNotCompressedObj);
    }

    protected COSBase parseObjectDynamically(long objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() == null) {
            Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
            if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
                throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
            }
            if (offsetOrObjstmObNr == null && this.isLenient && this.bfSearchCOSObjectKeyOffsets == null) {
                this.bfSearchForObjects();
                if (this.bfSearchCOSObjectKeyOffsets != null && !this.bfSearchCOSObjectKeyOffsets.isEmpty()) {
                    Log.d((String)"PdfBox-Android", (String)"Add all new read objects from brute force search to the xref table");
                    Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
                    Set<Map.Entry<COSObjectKey, Long>> entries = this.bfSearchCOSObjectKeyOffsets.entrySet();
                    for (Map.Entry<COSObjectKey, Long> entry : entries) {
                        COSObjectKey key = entry.getKey();
                        if (xrefOffset.containsKey(key)) continue;
                        xrefOffset.put(key, entry.getValue());
                    }
                    offsetOrObjstmObNr = xrefOffset.get(objKey);
                }
            }
            if (offsetOrObjstmObNr == null) {
                pdfObject.setObject(COSNull.NULL);
            } else if (offsetOrObjstmObNr > 0L) {
                this.parseFileObject(offsetOrObjstmObNr, objKey, pdfObject);
            } else {
                this.parseObjectStream((int)(-offsetOrObjstmObNr.longValue()));
            }
        }
        return pdfObject.getObject();
    }

    private void parseFileObject(Long offsetOrObjstmObNr, COSObjectKey objKey, COSObject pdfObject) throws IOException {
        this.source.seek(offsetOrObjstmObNr);
        long readObjNr = this.readObjectNumber();
        int readObjGen = this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
            throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen + " at offset " + offsetOrObjstmObNr);
        }
        this.skipSpaces();
        COSBase pb = this.parseDirObject();
        String endObjectKey = this.readString();
        if (endObjectKey.equals("stream")) {
            COSStream stream;
            this.source.rewind(endObjectKey.getBytes(Charsets.ISO_8859_1).length);
            if (pb instanceof COSDictionary) {
                stream = this.parseCOSStream((COSDictionary)pb);
                if (this.securityHandler != null) {
                    this.securityHandler.decryptStream(stream, objKey.getNumber(), objKey.getGeneration());
                }
            } else {
                throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
            }
            pb = stream;
            this.skipSpaces();
            endObjectKey = this.readLine();
            if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                endObjectKey = this.readLine();
            }
        } else if (this.securityHandler != null) {
            this.securityHandler.decrypt(pb, objKey.getNumber(), objKey.getGeneration());
        }
        pdfObject.setObject(pb);
        if (!endObjectKey.startsWith("endobj")) {
            if (this.isLenient) {
                Log.w((String)"PdfBox-Android", (String)("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'"));
            } else {
                throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'");
            }
        }
    }

    private void parseObjectStream(int objstmObjNr) throws IOException {
        COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
        if (objstmBaseObj instanceof COSStream) {
            PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document);
            try {
                parser.parse();
            }
            catch (IOException exception) {
                if (this.isLenient) {
                    Log.d((String)"PdfBox-Android", (String)("Stop reading object stream " + objstmObjNr + " due to an exception"), (Throwable)exception);
                    return;
                }
                throw exception;
            }
            for (COSObject next : parser.getObjects()) {
                COSObjectKey stmObjKey = new COSObjectKey(next);
                Long offset = this.xrefTrailerResolver.getXrefTable().get(stmObjKey);
                if (offset == null || offset != (long)(-objstmObjNr)) continue;
                COSObject stmObj = this.document.getObjectFromPool(stmObjKey);
                stmObj.setObject(next.getObject());
            }
        }
    }

    private COSNumber getLength(COSBase lengthBaseObj, COSName streamType) throws IOException {
        if (lengthBaseObj == null) {
            return null;
        }
        COSNumber retVal = null;
        if (lengthBaseObj instanceof COSNumber) {
            retVal = (COSNumber)lengthBaseObj;
        } else if (lengthBaseObj instanceof COSObject) {
            COSObject lengthObj = (COSObject)lengthBaseObj;
            if (lengthObj.getObject() == null) {
                long curFileOffset = this.source.getPosition();
                boolean isObjectStream = COSName.OBJ_STM.equals(streamType);
                this.parseObjectDynamically(lengthObj, isObjectStream);
                this.source.seek(curFileOffset);
                if (lengthObj.getObject() == null) {
                    throw new IOException("Length object content was not read.");
                }
            }
            if (!(lengthObj.getObject() instanceof COSNumber)) {
                throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + lengthObj.getObject().getClass().getSimpleName());
            }
            retVal = (COSNumber)lengthObj.getObject();
        } else {
            throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSStream parseCOSStream(COSDictionary dic) throws IOException {
        OutputStream out;
        COSStream stream = this.document.createCOSStream(dic);
        this.readString();
        this.skipWhiteSpaces();
        COSNumber streamLengthObj = this.getLength(dic.getItem(COSName.LENGTH), dic.getCOSName(COSName.TYPE));
        if (streamLengthObj == null) {
            if (this.isLenient) {
                Log.w((String)"PdfBox-Android", (String)("The stream doesn't provide any stream length, using fallback readUntilEnd, at offset " + this.source.getPosition()));
            } else {
                throw new IOException("Missing length for stream.");
            }
        }
        if (streamLengthObj != null && this.validateStreamLength(streamLengthObj.longValue())) {
            out = stream.createRawOutputStream();
            try {
                this.readValidStream(out, streamLengthObj);
            }
            finally {
                out.close();
                stream.setItem(COSName.LENGTH, (COSBase)streamLengthObj);
            }
        }
        out = stream.createRawOutputStream();
        try {
            this.readUntilEndStream(new EndstreamOutputStream(out));
        }
        finally {
            out.close();
            if (streamLengthObj != null) {
                stream.setItem(COSName.LENGTH, (COSBase)streamLengthObj);
            }
        }
        String endStream = this.readString();
        if (endStream.equals("endobj") && this.isLenient) {
            Log.w((String)"PdfBox-Android", (String)("stream ends with 'endobj' instead of 'endstream' at offset " + this.source.getPosition()));
            this.source.rewind(ENDOBJ.length);
        } else if (endStream.length() > 9 && this.isLenient && endStream.substring(0, 9).equals("endstream")) {
            Log.w((String)"PdfBox-Android", (String)("stream ends with '" + endStream + "' instead of 'endstream' at offset " + this.source.getPosition()));
            this.source.rewind(endStream.substring(9).getBytes(Charsets.ISO_8859_1).length);
        } else if (!endStream.equals("endstream")) {
            throw new IOException("Error reading stream, expected='endstream' actual='" + endStream + "' at offset " + this.source.getPosition());
        }
        return stream;
    }

    private void readUntilEndStream(OutputStream out) throws IOException {
        int bufSize;
        int charMatchCount = 0;
        byte[] keyw = ENDSTREAM;
        int quickTestOffset = 5;
        while ((bufSize = this.source.read(this.strmBuf, charMatchCount, 2048 - charMatchCount)) > 0) {
            int contentBytes;
            int bIdx;
            int maxQuicktestIdx = (bufSize += charMatchCount) - 5;
            for (bIdx = charMatchCount; bIdx < bufSize; ++bIdx) {
                byte ch;
                int quickTestIdx = bIdx + 5;
                if (charMatchCount == 0 && quickTestIdx < maxQuicktestIdx && ((ch = this.strmBuf[quickTestIdx]) > 116 || ch < 97)) {
                    bIdx = quickTestIdx;
                    continue;
                }
                ch = this.strmBuf[bIdx];
                if (ch == keyw[charMatchCount]) {
                    if (++charMatchCount != keyw.length) continue;
                    ++bIdx;
                    break;
                }
                if (charMatchCount == 3 && ch == ENDOBJ[charMatchCount]) {
                    keyw = ENDOBJ;
                    ++charMatchCount;
                    continue;
                }
                charMatchCount = ch == 101 ? 1 : (ch == 110 && charMatchCount == 7 ? 2 : 0);
                keyw = ENDSTREAM;
            }
            if ((contentBytes = Math.max(0, bIdx - charMatchCount)) > 0) {
                out.write(this.strmBuf, 0, contentBytes);
            }
            if (charMatchCount == keyw.length) {
                this.source.rewind(bufSize - contentBytes);
                break;
            }
            System.arraycopy(keyw, 0, this.strmBuf, 0, charMatchCount);
        }
        out.flush();
    }

    private void readValidStream(OutputStream out, COSNumber streamLengthObj) throws IOException {
        int readBytes;
        for (long remainBytes = streamLengthObj.longValue(); remainBytes > 0L; remainBytes -= (long)readBytes) {
            int chunk = remainBytes > 8192L ? 8192 : (int)remainBytes;
            readBytes = this.source.read(this.streamCopyBuf, 0, chunk);
            if (readBytes <= 0) {
                throw new IOException("read error at offset " + this.source.getPosition() + ": expected " + chunk + " bytes, but read() returns " + readBytes);
            }
            out.write(this.streamCopyBuf, 0, readBytes);
        }
    }

    private boolean validateStreamLength(long streamLength) throws IOException {
        boolean streamLengthIsValid = true;
        long originOffset = this.source.getPosition();
        long expectedEndOfStream = originOffset + streamLength;
        if (expectedEndOfStream > this.fileLen) {
            streamLengthIsValid = false;
            Log.w((String)"PdfBox-Android", (String)("The end of the stream is out of range, using workaround to read the stream, stream start position: " + originOffset + ", length: " + streamLength + ", expected end position: " + expectedEndOfStream));
        } else {
            this.source.seek(expectedEndOfStream);
            this.skipSpaces();
            if (!this.isString(ENDSTREAM)) {
                streamLengthIsValid = false;
                Log.w((String)"PdfBox-Android", (String)("The end of the stream doesn't point to the correct offset, using workaround to read the stream, stream start position: " + originOffset + ", length: " + streamLength + ", expected end position: " + expectedEndOfStream));
            }
            this.source.seek(originOffset);
        }
        return streamLengthIsValid;
    }

    private long checkXRefOffset(long startXRefOffset) throws IOException {
        if (!this.isLenient) {
            return startXRefOffset;
        }
        this.source.seek(startXRefOffset);
        this.skipSpaces();
        if (this.source.peek() == 120 && this.isString(XREF_TABLE)) {
            return startXRefOffset;
        }
        if (startXRefOffset > 0L) {
            if (this.checkXRefStreamOffset(startXRefOffset)) {
                return startXRefOffset;
            }
            return this.calculateXRefFixedOffset(startXRefOffset, false);
        }
        return -1L;
    }

    private boolean checkXRefStreamOffset(long startXRefOffset) throws IOException {
        if (!this.isLenient || startXRefOffset == 0L) {
            return true;
        }
        this.source.seek(startXRefOffset - 1L);
        int nextValue = this.source.read();
        if (this.isWhitespace(nextValue)) {
            this.skipSpaces();
            if (this.isDigit()) {
                try {
                    this.readObjectNumber();
                    this.readGenerationNumber();
                    this.readExpectedString(OBJ_MARKER, true);
                    COSDictionary dict = this.parseCOSDictionary();
                    this.source.seek(startXRefOffset);
                    if (dict != null && "XRef".equals(dict.getNameAsString(COSName.TYPE))) {
                        return true;
                    }
                }
                catch (IOException exception) {
                    this.source.seek(startXRefOffset);
                }
            }
        }
        return false;
    }

    private long calculateXRefFixedOffset(long objectOffset, boolean streamsOnly) throws IOException {
        if (objectOffset < 0L) {
            Log.e((String)"PdfBox-Android", (String)("Invalid object offset " + objectOffset + " when searching for a xref table/stream"));
            return 0L;
        }
        long newOffset = this.bfSearchForXRef(objectOffset, streamsOnly);
        if (newOffset > -1L) {
            Log.d((String)"PdfBox-Android", (String)("Fixed reference for xref table/stream " + objectOffset + " -> " + newOffset));
            return newOffset;
        }
        Log.e((String)"PdfBox-Android", (String)("Can't find the object xref table/stream at offset " + objectOffset));
        return 0L;
    }

    private void checkXrefOffsets() throws IOException {
        if (!this.isLenient) {
            return;
        }
        Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
        if (xrefOffset != null) {
            boolean bruteForceSearch = false;
            for (Map.Entry<COSObjectKey, Long> objectEntry : xrefOffset.entrySet()) {
                COSObjectKey objectKey = objectEntry.getKey();
                Long objectOffset = objectEntry.getValue();
                if (objectOffset == null || objectOffset < 0L || this.checkObjectKeys(objectKey, objectOffset)) continue;
                Log.d((String)"PdfBox-Android", (String)"Stop checking xref offsets as at least one couldn't be dereferenced");
                bruteForceSearch = true;
                break;
            }
            if (bruteForceSearch) {
                this.bfSearchForObjects();
                if (this.bfSearchCOSObjectKeyOffsets != null && !this.bfSearchCOSObjectKeyOffsets.isEmpty()) {
                    ArrayList<COSObjectKey> objStreams = new ArrayList<COSObjectKey>();
                    for (COSObjectKey key : xrefOffset.keySet()) {
                        COSObjectKey objStream;
                        Long offset = xrefOffset.get(key);
                        if (offset == null || offset >= 0L || objStreams.contains(objStream = new COSObjectKey(-offset.longValue(), 0))) continue;
                        objStreams.add(new COSObjectKey(-offset.longValue(), 0));
                    }
                    if (!objStreams.isEmpty()) {
                        for (COSObjectKey key : objStreams) {
                            Set<Long> objects;
                            if (this.bfSearchCOSObjectKeyOffsets.containsKey(key)) {
                                objects = this.xrefTrailerResolver.getContainedObjectNumbers((int)key.getNumber());
                                for (Long objNr : objects) {
                                    COSObjectKey streamObjectKey = new COSObjectKey(objNr, 0);
                                    Long streamObjectOffset = this.bfSearchCOSObjectKeyOffsets.get(streamObjectKey);
                                    if (streamObjectOffset == null || streamObjectOffset <= 0L) continue;
                                    this.bfSearchCOSObjectKeyOffsets.remove(streamObjectKey);
                                }
                                continue;
                            }
                            objects = this.xrefTrailerResolver.getContainedObjectNumbers((int)key.getNumber());
                            for (Long objNr : objects) {
                                xrefOffset.remove(new COSObjectKey(objNr, 0));
                            }
                        }
                    }
                    Log.d((String)"PdfBox-Android", (String)"Replaced read xref table with the results of a brute force search");
                    xrefOffset.putAll(this.bfSearchCOSObjectKeyOffsets);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkObjectKeys(COSObjectKey objectKey, long offset) throws IOException {
        if (offset < 6L) {
            return false;
        }
        long objectNr = objectKey.getNumber();
        int objectGen = objectKey.getGeneration();
        long originOffset = this.source.getPosition();
        String objectString = this.createObjectString(objectNr, objectGen);
        try {
            this.source.seek(offset);
            if (this.isString(objectString.getBytes(Charsets.ISO_8859_1))) {
                this.source.seek(originOffset);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.source.seek(originOffset);
        }
        return false;
    }

    private String createObjectString(long objectID, int genID) {
        return Long.toString(objectID) + " " + Integer.toString(genID) + " obj";
    }

    private void bfSearchForObjects() throws IOException {
        if (this.bfSearchCOSObjectKeyOffsets == null) {
            this.bfSearchForLastEOFMarker();
            this.bfSearchCOSObjectKeyOffsets = new HashMap<COSObjectKey, Long>();
            long originOffset = this.source.getPosition();
            long currentOffset = 6L;
            String objString = " obj";
            char[] string = objString.toCharArray();
            do {
                this.source.seek(currentOffset);
                if (!this.isString(string)) continue;
                long tempOffset = currentOffset - 1L;
                this.source.seek(tempOffset);
                int genID = this.source.peek();
                if (!COSParser.isDigit(genID)) continue;
                genID -= 48;
                this.source.seek(--tempOffset);
                if (!this.isSpace()) continue;
                while (tempOffset > 6L && this.isSpace()) {
                    this.source.seek(--tempOffset);
                }
                boolean objectIDFound = false;
                while (tempOffset > 6L && this.isDigit()) {
                    this.source.seek(--tempOffset);
                    objectIDFound = true;
                }
                if (!objectIDFound) continue;
                this.source.read();
                long objectID = this.readObjectNumber();
                this.bfSearchCOSObjectKeyOffsets.put(new COSObjectKey(objectID, genID), tempOffset + 1L);
            } while (++currentOffset < this.lastEOFMarker && !this.source.isEOF());
            this.source.seek(originOffset);
        }
    }

    private long bfSearchForXRef(long xrefOffset, boolean streamsOnly) throws IOException {
        long newOffset = -1L;
        long newOffsetTable = -1L;
        long newOffsetStream = -1L;
        if (!streamsOnly) {
            this.bfSearchForXRefTables();
        }
        this.bfSearchForXRefStreams();
        if (!streamsOnly && this.bfSearchXRefTablesOffsets != null) {
            newOffsetTable = this.searchNearestValue(this.bfSearchXRefTablesOffsets, xrefOffset);
        }
        if (this.bfSearchXRefStreamsOffsets != null) {
            newOffsetStream = this.searchNearestValue(this.bfSearchXRefStreamsOffsets, xrefOffset);
        }
        if (newOffsetTable > -1L && newOffsetStream > -1L) {
            long differenceTable = xrefOffset - newOffsetTable;
            long differenceStream = xrefOffset - newOffsetStream;
            if (Math.abs(differenceTable) > Math.abs(differenceStream)) {
                newOffset = newOffsetStream;
                this.bfSearchXRefStreamsOffsets.remove(newOffsetStream);
            } else {
                newOffset = newOffsetTable;
                this.bfSearchXRefTablesOffsets.remove(newOffsetTable);
            }
        } else if (newOffsetTable > -1L) {
            newOffset = newOffsetTable;
            this.bfSearchXRefTablesOffsets.remove(newOffsetTable);
        } else if (newOffsetStream > -1L) {
            newOffset = newOffsetStream;
            this.bfSearchXRefStreamsOffsets.remove(newOffsetStream);
        }
        return newOffset;
    }

    private long searchNearestValue(List<Long> values, long offset) {
        long newValue = -1L;
        Long currentDifference = null;
        int currentOffsetIndex = -1;
        int numberOfOffsets = values.size();
        for (int i = 0; i < numberOfOffsets; ++i) {
            long newDifference = offset - values.get(i);
            if (currentDifference != null && Math.abs(currentDifference) <= Math.abs(newDifference)) continue;
            currentDifference = newDifference;
            currentOffsetIndex = i;
        }
        if (currentOffsetIndex > -1) {
            newValue = values.get(currentOffsetIndex);
        }
        return newValue;
    }

    private void bfSearchForLastEOFMarker() throws IOException {
        if (this.lastEOFMarker == null) {
            long originOffset = this.source.getPosition();
            this.source.seek(6L);
            while (!this.source.isEOF()) {
                if (this.isString(EOF_MARKER)) {
                    this.lastEOFMarker = this.source.getPosition();
                    this.source.seek(this.lastEOFMarker + 5L);
                }
                this.source.read();
            }
            this.source.seek(originOffset);
            if (this.lastEOFMarker == null) {
                this.lastEOFMarker = Long.MAX_VALUE;
            }
        }
    }

    private void bfSearchForXRefTables() throws IOException {
        if (this.bfSearchXRefTablesOffsets == null) {
            this.bfSearchXRefTablesOffsets = new Vector<Long>();
            long originOffset = this.source.getPosition();
            this.source.seek(6L);
            while (!this.source.isEOF()) {
                if (this.isString(XREF_TABLE)) {
                    long newOffset = this.source.getPosition();
                    this.source.seek(newOffset - 1L);
                    if (this.isWhitespace()) {
                        this.bfSearchXRefTablesOffsets.add(newOffset);
                    }
                    this.source.seek(newOffset + 4L);
                }
                this.source.read();
            }
            this.source.seek(originOffset);
        }
    }

    private void bfSearchForXRefStreams() throws IOException {
        if (this.bfSearchXRefStreamsOffsets == null) {
            this.bfSearchXRefStreamsOffsets = new Vector<Long>();
            long originOffset = this.source.getPosition();
            this.source.seek(6L);
            String objString = " obj";
            char[] string = objString.toCharArray();
            while (!this.source.isEOF()) {
                if (this.isString(XREF_STREAM)) {
                    long newOffset = -1L;
                    long xrefOffset = this.source.getPosition();
                    boolean objFound = false;
                    block1: for (int i = 1; i < 40 && !objFound; ++i) {
                        long currentOffset = xrefOffset - (long)(i * 10);
                        if (currentOffset <= 0L) continue;
                        this.source.seek(currentOffset);
                        for (int j = 0; j < 10; ++j) {
                            if (this.isString(string)) {
                                long tempOffset = currentOffset - 1L;
                                this.source.seek(tempOffset);
                                int genID = this.source.peek();
                                if (COSParser.isDigit(genID)) {
                                    genID -= 48;
                                    this.source.seek(--tempOffset);
                                    if (this.isSpace()) {
                                        int length = 0;
                                        this.source.seek(--tempOffset);
                                        while (tempOffset > 6L && this.isDigit()) {
                                            this.source.seek(--tempOffset);
                                            ++length;
                                        }
                                        if (length > 0) {
                                            this.source.read();
                                            newOffset = this.source.getPosition();
                                        }
                                    }
                                }
                                Log.d((String)"PdfBox-Android", (String)("Fixed reference for xref stream " + xrefOffset + " -> " + newOffset));
                                objFound = true;
                                continue block1;
                            }
                            ++currentOffset;
                            this.source.read();
                        }
                    }
                    if (newOffset > -1L) {
                        this.bfSearchXRefStreamsOffsets.add(newOffset);
                    }
                    this.source.seek(xrefOffset + 5L);
                }
                this.source.read();
            }
            this.source.seek(originOffset);
        }
    }

    protected final COSDictionary rebuildTrailer() throws IOException {
        COSDictionary trailer = null;
        this.bfSearchForObjects();
        if (this.bfSearchCOSObjectKeyOffsets != null) {
            this.xrefTrailerResolver.reset();
            this.xrefTrailerResolver.nextXrefObj(0L, XrefTrailerResolver.XRefType.TABLE);
            for (Map.Entry<COSObjectKey, Long> entry : this.bfSearchCOSObjectKeyOffsets.entrySet()) {
                this.xrefTrailerResolver.setXRef(entry.getKey(), entry.getValue());
            }
            this.xrefTrailerResolver.setStartxref(0L);
            trailer = this.xrefTrailerResolver.getTrailer();
            this.getDocument().setTrailer(trailer);
            for (Map.Entry<COSObjectKey, Long> entry : this.bfSearchCOSObjectKeyOffsets.entrySet()) {
                Long offset = entry.getValue();
                this.source.seek(offset);
                this.readObjectNumber();
                this.readGenerationNumber();
                this.readExpectedString(OBJ_MARKER, true);
                try {
                    COSDictionary dictionary = this.parseCOSDictionary();
                    if (dictionary == null) continue;
                    if (COSName.CATALOG.equals(dictionary.getCOSName(COSName.TYPE))) {
                        trailer.setItem(COSName.ROOT, (COSBase)this.document.getObjectFromPool(entry.getKey()));
                        continue;
                    }
                    if (!dictionary.containsKey(COSName.MOD_DATE) || !dictionary.containsKey(COSName.TITLE) && !dictionary.containsKey(COSName.AUTHOR) && !dictionary.containsKey(COSName.SUBJECT) && !dictionary.containsKey(COSName.KEYWORDS) && !dictionary.containsKey(COSName.CREATOR) && !dictionary.containsKey(COSName.PRODUCER) && !dictionary.containsKey(COSName.CREATION_DATE)) continue;
                    trailer.setItem(COSName.INFO, (COSBase)this.document.getObjectFromPool(entry.getKey()));
                }
                catch (IOException exception) {
                    Log.d((String)"PdfBox-Android", (String)("Skipped object " + entry.getKey() + ", either it's corrupt or not a dictionary"));
                }
            }
        }
        return trailer;
    }

    private long parseStartXref() throws IOException {
        long startXref = -1L;
        if (this.isString(STARTXREF)) {
            this.readString();
            this.skipSpaces();
            startXref = this.readLong();
        }
        return startXref;
    }

    private boolean isString(byte[] string) throws IOException {
        boolean bytesMatching = false;
        if (this.source.peek() == string[0]) {
            int numberOfBytes;
            int readMore;
            int length = string.length;
            byte[] bytesRead = new byte[length];
            for (numberOfBytes = this.source.read(bytesRead, 0, length); numberOfBytes < length && (readMore = this.source.read(bytesRead, numberOfBytes, length - numberOfBytes)) >= 0; numberOfBytes += readMore) {
            }
            if (Arrays.equals(string, bytesRead)) {
                bytesMatching = true;
            }
            this.source.rewind(numberOfBytes);
        }
        return bytesMatching;
    }

    private boolean isString(char[] string) throws IOException {
        boolean bytesMatching = true;
        long originOffset = this.source.getPosition();
        for (char c : string) {
            if (this.source.read() == c) continue;
            bytesMatching = false;
        }
        this.source.seek(originOffset);
        return bytesMatching;
    }

    private boolean parseTrailer() throws IOException {
        if (this.source.peek() != 116) {
            return false;
        }
        long currentOffset = this.source.getPosition();
        String nextLine = this.readLine();
        if (!nextLine.trim().equals("trailer")) {
            if (nextLine.startsWith("trailer")) {
                int len = "trailer".length();
                this.source.seek(currentOffset + (long)len);
            } else {
                return false;
            }
        }
        this.skipSpaces();
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        this.xrefTrailerResolver.setTrailer(parsedTrailer);
        this.skipSpaces();
        return true;
    }

    protected boolean parsePDFHeader() throws IOException {
        return this.parseHeader(PDF_HEADER, PDF_DEFAULT_VERSION);
    }

    protected boolean parseFDFHeader() throws IOException {
        return this.parseHeader(FDF_HEADER, FDF_DEFAULT_VERSION);
    }

    private boolean parseHeader(String headerMarker, String defaultVersion) throws IOException {
        String header = this.readLine();
        if (!header.contains(headerMarker)) {
            header = this.readLine();
            while (!(header.contains(headerMarker) || header.length() > 0 && Character.isDigit(header.charAt(0)))) {
                header = this.readLine();
            }
        }
        if (!header.contains(headerMarker)) {
            this.source.seek(0L);
            return false;
        }
        int headerStart = header.indexOf(headerMarker);
        if (headerStart > 0) {
            header = header.substring(headerStart, header.length());
        }
        if (header.startsWith(headerMarker) && !header.matches(headerMarker + "\\d.\\d")) {
            if (header.length() < headerMarker.length() + 3) {
                header = headerMarker + defaultVersion;
                Log.d((String)"PdfBox-Android", (String)("No version found, set to " + defaultVersion + " as default."));
            } else {
                String headerGarbage = header.substring(headerMarker.length() + 3, header.length()) + "\n";
                header = header.substring(0, headerMarker.length() + 3);
                this.source.rewind(headerGarbage.getBytes(Charsets.ISO_8859_1).length);
            }
        }
        float headerVersion = -1.0f;
        try {
            String[] headerParts = header.split("-");
            if (headerParts.length == 2) {
                headerVersion = Float.parseFloat(headerParts[1]);
            }
        }
        catch (NumberFormatException exception) {
            Log.d((String)"PdfBox-Android", (String)"Can't parse the header version.", (Throwable)exception);
        }
        if (headerVersion < 0.0f) {
            if (this.isLenient) {
                headerVersion = 1.7f;
            } else {
                throw new IOException("Error getting header version: " + header);
            }
        }
        this.document.setVersion(headerVersion);
        this.source.seek(0L);
        return true;
    }

    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        if (this.source.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.trim().equals("xref")) {
            return false;
        }
        String str = this.readString();
        byte[] b = str.getBytes(Charsets.ISO_8859_1);
        this.source.rewind(b.length);
        this.xrefTrailerResolver.nextXrefObj(startByteOffset, XrefTrailerResolver.XRefType.TABLE);
        if (str.startsWith("trailer")) {
            Log.w((String)"PdfBox-Android", (String)"skipping empty xref table");
            return false;
        }
        do {
            String currentLine;
            String[] splitString;
            if ((splitString = (currentLine = this.readLine()).split("\\s")).length != 2) {
                Log.w((String)"PdfBox-Android", (String)("Unexpected XRefTable Entry: " + currentLine));
                break;
            }
            long currObjID = Long.parseLong(splitString[0]);
            int count = Integer.parseInt(splitString[1]);
            this.skipSpaces();
            for (int i = 0; i < count && !this.source.isEOF() && !this.isEndOfName((char)this.source.peek()) && this.source.peek() != 116; ++i) {
                currentLine = this.readLine();
                splitString = currentLine.split("\\s");
                if (splitString.length < 3) {
                    Log.w((String)"PdfBox-Android", (String)("invalid xref line: " + currentLine));
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        long currOffset = Long.parseLong(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        COSObjectKey objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(e);
                    }
                } else if (!splitString[2].equals("f")) {
                    throw new IOException("Corrupt XRefTable Entry - ObjID:" + currObjID);
                }
                ++currObjID;
                this.skipSpaces();
            }
            this.skipSpaces();
        } while (this.isDigit());
        return true;
    }

    private void parseXrefStream(COSStream stream, long objByteOffset, boolean isStandalone) throws IOException {
        if (isStandalone) {
            this.xrefTrailerResolver.nextXrefObj(objByteOffset, XrefTrailerResolver.XRefType.STREAM);
            this.xrefTrailerResolver.setTrailer(stream);
        }
        PDFXrefStreamParser parser = new PDFXrefStreamParser(stream, this.document, this.xrefTrailerResolver);
        parser.parse();
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    protected COSBase parseTrailerValuesDynamically(COSDictionary trailer) throws IOException {
        for (COSBase trailerEntry : trailer.getValues()) {
            if (!(trailerEntry instanceof COSObject)) continue;
            COSObject tmpObj = (COSObject)trailerEntry;
            this.parseObjectDynamically(tmpObj, false);
        }
        COSObject root = (COSObject)trailer.getItem(COSName.ROOT);
        if (root == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        return this.parseObjectDynamically(root, false);
    }
}

