/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.rendering;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.rendering.ImageType;
import com.tom_roush.pdfbox.rendering.PageDrawer;
import com.tom_roush.pdfbox.rendering.PageDrawerParameters;
import java.io.IOException;

public class PDFRenderer {
    protected final PDDocument document;

    public PDFRenderer(PDDocument document) {
        this.document = document;
    }

    public Bitmap renderImage(int pageIndex) throws IOException {
        return this.renderImage(pageIndex, 1.0f);
    }

    public Bitmap renderImage(int pageIndex, float scale) throws IOException {
        return this.renderImage(pageIndex, scale, ImageType.RGB);
    }

    public Bitmap renderImageWithDPI(int pageIndex, float dpi) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, ImageType.RGB);
    }

    public Bitmap renderImageWithDPI(int pageIndex, float dpi, ImageType imageType) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, imageType);
    }

    public Bitmap renderImage(int pageIndex, float scale, ImageType imageType) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        PDRectangle cropbBox = page.getCropBox();
        float widthPt = cropbBox.getWidth();
        float heightPt = cropbBox.getHeight();
        int widthPx = Math.round(widthPt * scale);
        int heightPx = Math.round(heightPt * scale);
        int rotationAngle = page.getRotation();
        Bitmap image = rotationAngle == 90 || rotationAngle == 270 ? Bitmap.createBitmap((int)heightPx, (int)widthPx, (Bitmap.Config)imageType.toBitmapConfig()) : Bitmap.createBitmap((int)widthPx, (int)heightPx, (Bitmap.Config)imageType.toBitmapConfig());
        Paint paint = new Paint();
        Canvas canvas = new Canvas(image);
        if (imageType == ImageType.ARGB) {
            paint.setColor(0);
        } else {
            paint.setColor(-1);
        }
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(0.0f, 0.0f, (float)image.getWidth(), (float)image.getHeight(), paint);
        paint.reset();
        this.transform(canvas, page, scale);
        PageDrawerParameters parameters = new PageDrawerParameters(this, page);
        PageDrawer drawer = this.createPageDrawer(parameters);
        drawer.drawPage(paint, canvas, page.getCropBox());
        return image;
    }

    public void renderPageToGraphics(int pageIndex, Paint paint, Canvas canvas) throws IOException {
        this.renderPageToGraphics(pageIndex, paint, canvas, 1.0f);
    }

    public void renderPageToGraphics(int pageIndex, Paint paint, Canvas canvas, float scale) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        this.transform(canvas, page, scale);
        PDRectangle cropBox = page.getCropBox();
        canvas.drawRect(0.0f, 0.0f, cropBox.getWidth(), cropBox.getHeight(), paint);
        PageDrawerParameters parameters = new PageDrawerParameters(this, page);
        PageDrawer drawer = this.createPageDrawer(parameters);
        drawer.drawPage(paint, canvas, cropBox);
    }

    private void transform(Canvas canvas, PDPage page, float scale) {
        canvas.scale(scale, scale);
        int rotationAngle = page.getRotation();
        PDRectangle cropBox = page.getCropBox();
        if (rotationAngle != 0) {
            float translateX = 0.0f;
            float translateY = 0.0f;
            switch (rotationAngle) {
                case 90: {
                    translateX = cropBox.getHeight();
                    break;
                }
                case 270: {
                    translateY = cropBox.getWidth();
                    break;
                }
                case 180: {
                    translateX = cropBox.getWidth();
                    translateY = cropBox.getHeight();
                }
            }
            canvas.translate(translateX, translateY);
            canvas.rotate((float)rotationAngle);
        }
    }

    protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
        return new PageDrawer(parameters);
    }
}

