/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.harmony.javax.imageio.stream;

import com.tom_roush.harmony.javax.imageio.stream.ImageInputStreamImpl;
import com.tom_roush.harmony.javax.imageio.stream.RandomAccessMemoryCache;
import java.io.IOException;
import java.io.InputStream;

public class MemoryCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream is;
    private RandomAccessMemoryCache ramc = new RandomAccessMemoryCache();

    public MemoryCacheImageInputStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.is = stream;
    }

    @Override
    public int read() throws IOException {
        int count;
        int bytesAppended;
        this.bitOffset = 0;
        if (this.streamPos >= this.ramc.length() && (bytesAppended = this.ramc.appendData(this.is, count = (int)(this.streamPos - this.ramc.length() + 1L))) < count) {
            return -1;
        }
        int res = this.ramc.getData(this.streamPos);
        if (res >= 0) {
            ++this.streamPos;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res;
        this.bitOffset = 0;
        if (this.streamPos >= this.ramc.length()) {
            int count = (int)(this.streamPos - this.ramc.length() + (long)len);
            this.ramc.appendData(this.is, count);
        }
        if ((res = this.ramc.getData(b, off, len, this.streamPos)) > 0) {
            this.streamPos += (long)res;
        }
        return res;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.ramc.close();
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        super.flushBefore(pos);
        this.ramc.freeBefore(this.getFlushedPosition());
    }
}

