/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.multipdf;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.io.MemoryUsageSetting;
import com.tom_roush.pdfbox.multipdf.PDFCloneUtility;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDDocumentCatalog;
import com.tom_roush.pdfbox.pdmodel.PDDocumentInformation;
import com.tom_roush.pdfbox.pdmodel.PDDocumentNameDestinationDictionary;
import com.tom_roush.pdfbox.pdmodel.PDDocumentNameDictionary;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.PageMode;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDMetadata;
import com.tom_roush.pdfbox.pdmodel.common.PDNumberTreeNode;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import com.tom_roush.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import com.tom_roush.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PDFMergerUtility {
    private static final String STRUCTURETYPE_DOCUMENT = "Document";
    private final List<InputStream> sources = new ArrayList<InputStream>();
    private final List<FileInputStream> fileInputStreams = new ArrayList<FileInputStream>();
    private String destinationFileName;
    private OutputStream destinationStream;
    private boolean ignoreAcroFormErrors = false;
    private PDDocumentInformation destinationDocumentInformation = null;
    private PDMetadata destinationMetadata = null;
    private int nextFieldNum = 1;

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public void setDestinationFileName(String destination) {
        this.destinationFileName = destination;
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    public void setDestinationStream(OutputStream destStream) {
        this.destinationStream = destStream;
    }

    public PDDocumentInformation getDestinationDocumentInformation() {
        return this.destinationDocumentInformation;
    }

    public void setDestinationDocumentInformation(PDDocumentInformation info) {
        this.destinationDocumentInformation = info;
    }

    public PDMetadata getDestinationMetadata() {
        return this.destinationMetadata;
    }

    public void setDestinationMetadata(PDMetadata meta) {
        this.destinationMetadata = meta;
    }

    public void addSource(String source) throws FileNotFoundException {
        this.addSource(new File(source));
    }

    public void addSource(File source) throws FileNotFoundException {
        FileInputStream stream = new FileInputStream(source);
        this.sources.add(stream);
        this.fileInputStreams.add(stream);
    }

    public void addSource(InputStream source) {
        this.sources.add(source);
    }

    public void addSources(List<InputStream> sourcesList) {
        this.sources.addAll(sourcesList);
    }

    @Deprecated
    public void mergeDocuments() throws IOException {
        this.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeDocuments(MemoryUsageSetting memUsageSetting) throws IOException {
        PDDocument destination = null;
        if (this.sources != null && this.sources.size() > 0) {
            ArrayList<PDDocument> tobeclosed = new ArrayList<PDDocument>();
            try {
                MemoryUsageSetting partitionedMemSetting = memUsageSetting != null ? memUsageSetting.getPartitionedCopy(this.sources.size() + 1) : MemoryUsageSetting.setupMainMemoryOnly();
                Iterator<InputStream> sit = this.sources.iterator();
                destination = new PDDocument(partitionedMemSetting);
                while (sit.hasNext()) {
                    InputStream sourceFile = sit.next();
                    PDDocument source = PDDocument.load(sourceFile, partitionedMemSetting);
                    tobeclosed.add(source);
                    this.appendDocument(destination, source);
                }
                if (this.destinationDocumentInformation != null) {
                    destination.setDocumentInformation(this.destinationDocumentInformation);
                }
                if (this.destinationMetadata != null) {
                    destination.getDocumentCatalog().setMetadata(this.destinationMetadata);
                }
                if (this.destinationStream == null) {
                    destination.save(this.destinationFileName);
                } else {
                    destination.save(this.destinationStream);
                }
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
                for (PDDocument doc : tobeclosed) {
                    doc.close();
                }
                for (FileInputStream stream : this.fileInputStreams) {
                    stream.close();
                }
            }
        }
    }

    public void appendDocument(PDDocument destination, PDDocument source) throws IOException {
        PDFCloneUtility cloner;
        PDDocumentCatalog srcCatalog;
        PDDocumentCatalog destCatalog;
        block46: {
            if (source.getDocument().isClosed()) {
                throw new IOException("Error: source PDF is closed.");
            }
            if (destination.getDocument().isClosed()) {
                throw new IOException("Error: destination PDF is closed.");
            }
            destCatalog = destination.getDocumentCatalog();
            srcCatalog = source.getDocumentCatalog();
            if (this.isDynamicXfa(srcCatalog.getAcroForm())) {
                throw new IOException("Error: can't merge source document containing dynamic XFA form content.");
            }
            PDDocumentInformation destInfo = destination.getDocumentInformation();
            PDDocumentInformation srcInfo = source.getDocumentInformation();
            destInfo.getCOSObject().mergeInto(srcInfo.getCOSObject());
            float destVersion = destination.getVersion();
            float srcVersion = source.getVersion();
            if (destVersion < srcVersion) {
                destination.setVersion(srcVersion);
            }
            if (destCatalog.getOpenAction() == null) {
                destCatalog.setOpenAction(srcCatalog.getOpenAction());
            }
            cloner = new PDFCloneUtility(destination);
            try {
                PDAcroForm destAcroForm = destCatalog.getAcroForm();
                PDAcroForm srcAcroForm = srcCatalog.getAcroForm();
                if (destAcroForm == null && srcAcroForm != null) {
                    destCatalog.getCOSObject().setItem(COSName.ACRO_FORM, cloner.cloneForNewDocument(srcAcroForm.getCOSObject()));
                } else if (srcAcroForm != null) {
                    this.mergeAcroForm(cloner, destAcroForm, srcAcroForm);
                }
            }
            catch (IOException e) {
                if (this.ignoreAcroFormErrors) break block46;
                throw new IOException(e);
            }
        }
        COSArray destThreads = (COSArray)destCatalog.getCOSObject().getDictionaryObject(COSName.THREADS);
        COSArray srcThreads = (COSArray)cloner.cloneForNewDocument(destCatalog.getCOSObject().getDictionaryObject(COSName.THREADS));
        if (destThreads == null) {
            destCatalog.getCOSObject().setItem(COSName.THREADS, (COSBase)srcThreads);
        } else {
            destThreads.addAll(srcThreads);
        }
        PDDocumentNameDictionary destNames = destCatalog.getNames();
        PDDocumentNameDictionary srcNames = srcCatalog.getNames();
        if (srcNames != null) {
            if (destNames == null) {
                destCatalog.getCOSObject().setItem(COSName.NAMES, cloner.cloneForNewDocument(srcNames));
            } else {
                cloner.cloneMerge(srcNames, destNames);
            }
        }
        PDDocumentNameDestinationDictionary destDests = destCatalog.getDests();
        PDDocumentNameDestinationDictionary srcDests = srcCatalog.getDests();
        if (srcDests != null) {
            if (destDests == null) {
                destCatalog.getCOSObject().setItem(COSName.DESTS, cloner.cloneForNewDocument(srcDests));
            } else {
                cloner.cloneMerge(srcDests, destDests);
            }
        }
        PDDocumentOutline destOutline = destCatalog.getDocumentOutline();
        PDDocumentOutline srcOutline = srcCatalog.getDocumentOutline();
        if (srcOutline != null) {
            if (destOutline == null || destOutline.getFirstChild() == null) {
                PDDocumentOutline cloned = new PDDocumentOutline((COSDictionary)cloner.cloneForNewDocument(srcOutline));
                destCatalog.setDocumentOutline(cloned);
            } else {
                PDOutlineItem destLastOutlineItem = destOutline.getFirstChild();
                while (destLastOutlineItem.getNextSibling() != null) {
                    destLastOutlineItem = destLastOutlineItem.getNextSibling();
                }
                for (PDOutlineItem item : srcOutline.children()) {
                    COSDictionary clonedDict = (COSDictionary)cloner.cloneForNewDocument(item);
                    clonedDict.removeItem(COSName.PREV);
                    clonedDict.removeItem(COSName.NEXT);
                    PDOutlineItem clonedItem = new PDOutlineItem(clonedDict);
                    destLastOutlineItem.insertSiblingAfter(clonedItem);
                    destLastOutlineItem = destLastOutlineItem.getNextSibling();
                }
            }
        }
        PageMode destPageMode = destCatalog.getPageMode();
        PageMode srcPageMode = srcCatalog.getPageMode();
        if (destPageMode == null) {
            destCatalog.setPageMode(srcPageMode);
        }
        COSDictionary destLabels = (COSDictionary)destCatalog.getCOSObject().getDictionaryObject(COSName.PAGE_LABELS);
        COSDictionary srcLabels = (COSDictionary)srcCatalog.getCOSObject().getDictionaryObject(COSName.PAGE_LABELS);
        if (srcLabels != null) {
            COSArray destNums;
            int destPageCount = destination.getNumberOfPages();
            if (destLabels == null) {
                destLabels = new COSDictionary();
                destNums = new COSArray();
                destLabels.setItem(COSName.NUMS, (COSBase)destNums);
                destCatalog.getCOSObject().setItem(COSName.PAGE_LABELS, (COSBase)destLabels);
            } else {
                destNums = (COSArray)destLabels.getDictionaryObject(COSName.NUMS);
            }
            COSArray srcNums = (COSArray)srcLabels.getDictionaryObject(COSName.NUMS);
            if (srcNums != null) {
                for (int i = 0; i < srcNums.size(); i += 2) {
                    COSNumber labelIndex = (COSNumber)srcNums.getObject(i);
                    long labelIndexValue = labelIndex.intValue();
                    destNums.add(COSInteger.get(labelIndexValue + (long)destPageCount));
                    destNums.add(cloner.cloneForNewDocument(srcNums.getObject(i + 1)));
                }
            }
        }
        COSStream destMetadata = (COSStream)destCatalog.getCOSObject().getDictionaryObject(COSName.METADATA);
        COSStream srcMetadata = (COSStream)srcCatalog.getCOSObject().getDictionaryObject(COSName.METADATA);
        if (destMetadata == null && srcMetadata != null) {
            PDStream newStream = new PDStream(destination, (InputStream)srcMetadata.createInputStream(), (COSName)null);
            newStream.getCOSObject().mergeInto(srcMetadata);
            destCatalog.getCOSObject().setItem(COSName.METADATA, (COSObjectable)newStream);
        }
        COSDictionary destOCP = (COSDictionary)destCatalog.getCOSObject().getDictionaryObject(COSName.OCPROPERTIES);
        COSDictionary srcOCP = (COSDictionary)srcCatalog.getCOSObject().getDictionaryObject(COSName.OCPROPERTIES);
        if (destOCP == null && srcOCP != null) {
            destCatalog.getCOSObject().setItem(COSName.OCPROPERTIES, cloner.cloneForNewDocument(srcOCP));
        }
        this.mergeOutputIntents(cloner, srcCatalog, destCatalog);
        boolean mergeStructTree = false;
        int destParentTreeNextKey = -1;
        COSDictionary destParentTreeDict = null;
        COSArray destNumbersArray = null;
        COSArray srcNumbersArray = null;
        PDMarkInfo destMark = destCatalog.getMarkInfo();
        PDStructureTreeRoot destStructTree = destCatalog.getStructureTreeRoot();
        PDMarkInfo srcMark = srcCatalog.getMarkInfo();
        PDStructureTreeRoot srcStructTree = srcCatalog.getStructureTreeRoot();
        if (destStructTree != null) {
            PDNumberTreeNode destParentTree = destStructTree.getParentTree();
            destParentTreeNextKey = destStructTree.getParentTreeNextKey();
            if (destParentTree != null && (destNumbersArray = (COSArray)(destParentTreeDict = destParentTree.getCOSObject()).getDictionaryObject(COSName.NUMS)) != null) {
                COSDictionary srcParentTreeDict;
                Object srcParentTree;
                if (destParentTreeNextKey < 0) {
                    destParentTreeNextKey = destNumbersArray.size() / 2;
                }
                if (destParentTreeNextKey > 0 && srcStructTree != null && (srcParentTree = srcStructTree.getParentTree()) != null && (srcNumbersArray = (COSArray)(srcParentTreeDict = ((PDNumberTreeNode)srcParentTree).getCOSObject()).getDictionaryObject(COSName.NUMS)) != null) {
                    mergeStructTree = true;
                }
            }
            if (destMark != null && destMark.isMarked() && !mergeStructTree) {
                destMark.setMarked(false);
            }
            if (!mergeStructTree) {
                destCatalog.setStructureTreeRoot(null);
            }
        }
        HashMap<COSDictionary, COSDictionary> objMapping = new HashMap<COSDictionary, COSDictionary>();
        for (PDPage page : srcCatalog.getPages()) {
            PDPage newPage = new PDPage((COSDictionary)cloner.cloneForNewDocument(page.getCOSObject()));
            newPage.setCropBox(page.getCropBox());
            newPage.setMediaBox(page.getMediaBox());
            newPage.setRotation(page.getRotation());
            PDResources resources = page.getResources();
            if (resources != null) {
                newPage.setResources(new PDResources((COSDictionary)cloner.cloneForNewDocument(resources)));
            } else {
                newPage.setResources(new PDResources());
            }
            if (mergeStructTree) {
                this.updateStructParentEntries(newPage, destParentTreeNextKey);
                objMapping.put(page.getCOSObject(), newPage.getCOSObject());
                List<PDAnnotation> oldAnnots = page.getAnnotations();
                List<PDAnnotation> newAnnots = newPage.getAnnotations();
                for (int i = 0; i < oldAnnots.size(); ++i) {
                    objMapping.put(oldAnnots.get(i).getCOSObject(), newAnnots.get(i).getCOSObject());
                }
            }
            destination.addPage(newPage);
        }
        if (mergeStructTree) {
            this.updatePageReferences(srcNumbersArray, objMapping);
            for (int i = 0; i < srcNumbersArray.size() / 2; ++i) {
                destNumbersArray.add(COSInteger.get(destParentTreeNextKey + i));
                destNumbersArray.add(srcNumbersArray.getObject(i * 2 + 1));
            }
            destParentTreeDict.setItem(COSName.NUMS, (COSBase)destNumbersArray);
            PDNumberTreeNode newParentTreeNode = new PDNumberTreeNode(destParentTreeDict, COSBase.class);
            destStructTree.setParentTree(newParentTreeNode);
            destStructTree.setParentTreeNextKey(destParentTreeNextKey += srcNumbersArray.size() / 2);
            COSDictionary kDictLevel0 = new COSDictionary();
            COSArray newKArray = new COSArray();
            COSArray destKArray = destStructTree.getKArray();
            COSArray srcKArray = srcStructTree.getKArray();
            if (destKArray != null && srcKArray != null) {
                this.updateParentEntry(destKArray, kDictLevel0);
                newKArray.addAll(destKArray);
                if (mergeStructTree) {
                    this.updateParentEntry(srcKArray, kDictLevel0);
                }
                newKArray.addAll(srcKArray);
            }
            kDictLevel0.setItem(COSName.K, (COSBase)newKArray);
            kDictLevel0.setItem(COSName.P, (COSObjectable)destStructTree);
            kDictLevel0.setItem(COSName.S, (COSBase)new COSString(STRUCTURETYPE_DOCUMENT));
            destStructTree.setK(kDictLevel0);
        }
    }

    private void mergeOutputIntents(PDFCloneUtility cloner, PDDocumentCatalog srcCatalog, PDDocumentCatalog destCatalog) throws IOException {
        List<PDOutputIntent> srcOutputIntents = srcCatalog.getOutputIntents();
        List<PDOutputIntent> dstOutputIntents = destCatalog.getOutputIntents();
        for (PDOutputIntent srcOI : srcOutputIntents) {
            String srcOCI = srcOI.getOutputConditionIdentifier();
            if (srcOCI != null && !"Custom".equals(srcOCI)) {
                boolean skip = false;
                for (PDOutputIntent dstOI : dstOutputIntents) {
                    if (!dstOI.getOutputConditionIdentifier().equals(srcOCI)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            destCatalog.addOutputIntent(new PDOutputIntent((COSDictionary)cloner.cloneForNewDocument(srcOI)));
            dstOutputIntents.add(srcOI);
        }
    }

    private void mergeAcroForm(PDFCloneUtility cloner, PDAcroForm destAcroForm, PDAcroForm srcAcroForm) throws IOException {
        List<PDField> srcFields = srcAcroForm.getFields();
        if (srcFields != null) {
            String prefix = "dummyFieldName";
            int prefixLength = "dummyFieldName".length();
            for (PDField destField : destAcroForm.getFieldTree()) {
                String fieldName = destField.getPartialName();
                if (!fieldName.startsWith("dummyFieldName")) continue;
                this.nextFieldNum = Math.max(this.nextFieldNum, Integer.parseInt(fieldName.substring(prefixLength, fieldName.length())) + 1);
            }
            COSArray destFields = (COSArray)destAcroForm.getCOSObject().getItem(COSName.FIELDS);
            for (PDField srcField : srcAcroForm.getFieldTree()) {
                COSDictionary dstField = (COSDictionary)cloner.cloneForNewDocument(srcField.getCOSObject());
                if (destAcroForm.getField(srcField.getFullyQualifiedName()) != null) {
                    dstField.setString(COSName.T, "dummyFieldName" + this.nextFieldNum++);
                }
                destFields.add(dstField);
            }
            destAcroForm.getCOSObject().setItem(COSName.FIELDS, (COSBase)destFields);
        }
    }

    public boolean isIgnoreAcroFormErrors() {
        return this.ignoreAcroFormErrors;
    }

    public void setIgnoreAcroFormErrors(boolean ignoreAcroFormErrorsValue) {
        this.ignoreAcroFormErrors = ignoreAcroFormErrorsValue;
    }

    private void updatePageReferences(COSDictionary parentTreeEntry, Map<COSDictionary, COSDictionary> objMapping) {
        COSBase kSubEntry;
        COSBase obj;
        COSBase page = parentTreeEntry.getDictionaryObject(COSName.PG);
        if (page instanceof COSDictionary && objMapping.containsKey(page)) {
            parentTreeEntry.setItem(COSName.PG, (COSBase)objMapping.get(page));
        }
        if ((obj = parentTreeEntry.getDictionaryObject(COSName.OBJ)) instanceof COSDictionary && objMapping.containsKey(obj)) {
            parentTreeEntry.setItem(COSName.OBJ, (COSBase)objMapping.get(obj));
        }
        if ((kSubEntry = parentTreeEntry.getDictionaryObject(COSName.K)) instanceof COSArray) {
            this.updatePageReferences((COSArray)kSubEntry, objMapping);
        } else if (kSubEntry instanceof COSDictionary) {
            this.updatePageReferences((COSDictionary)kSubEntry, objMapping);
        }
    }

    private void updatePageReferences(COSArray parentTreeEntry, Map<COSDictionary, COSDictionary> objMapping) {
        for (int i = 0; i < parentTreeEntry.size(); ++i) {
            COSBase subEntry = parentTreeEntry.getObject(i);
            if (subEntry instanceof COSArray) {
                this.updatePageReferences((COSArray)subEntry, objMapping);
                continue;
            }
            if (!(subEntry instanceof COSDictionary)) continue;
            this.updatePageReferences((COSDictionary)subEntry, objMapping);
        }
    }

    private void updateParentEntry(COSArray kArray, COSDictionary newParent) {
        for (int i = 0; i < kArray.size(); ++i) {
            COSDictionary dictEntry;
            COSBase subEntry = kArray.getObject(i);
            if (!(subEntry instanceof COSDictionary) || (dictEntry = (COSDictionary)subEntry).getDictionaryObject(COSName.P) == null) continue;
            dictEntry.setItem(COSName.P, (COSBase)newParent);
        }
    }

    private void updateStructParentEntries(PDPage page, int structParentOffset) throws IOException {
        page.setStructParents(page.getStructParents() + structParentOffset);
        List<PDAnnotation> annots = page.getAnnotations();
        ArrayList<PDAnnotation> newannots = new ArrayList<PDAnnotation>();
        for (PDAnnotation annot : annots) {
            annot.setStructParent(annot.getStructParent() + structParentOffset);
            newannots.add(annot);
        }
        page.setAnnotations(newannots);
    }

    private boolean isDynamicXfa(PDAcroForm acroForm) {
        return acroForm != null && acroForm.xfaIsDynamic();
    }
}

