/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdfparser;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNull;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.io.RandomAccessRead;
import com.tom_roush.pdfbox.io.ScratchFile;
import com.tom_roush.pdfbox.pdfparser.COSParser;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.encryption.AccessPermission;
import com.tom_roush.pdfbox.pdmodel.encryption.DecryptionMaterial;
import com.tom_roush.pdfbox.pdmodel.encryption.InvalidPasswordException;
import com.tom_roush.pdfbox.pdmodel.encryption.PDEncryption;
import com.tom_roush.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import com.tom_roush.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;

public class PDFParser
extends COSParser {
    private String password = "";
    private InputStream keyStoreInputStream = null;
    private String keyAlias = null;
    private PDEncryption encryption = null;
    private AccessPermission accessPermission;

    public PDFParser(RandomAccessRead source) throws IOException {
        this(source, "", ScratchFile.getMainMemoryOnlyInstance());
    }

    public PDFParser(RandomAccessRead source, ScratchFile scratchFile) throws IOException {
        this(source, "", scratchFile);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword) throws IOException {
        this(source, decryptionPassword, ScratchFile.getMainMemoryOnlyInstance());
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, ScratchFile scratchFile) throws IOException {
        this(source, decryptionPassword, null, null, scratchFile);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias) throws IOException {
        this(source, decryptionPassword, keyStore, alias, ScratchFile.getMainMemoryOnlyInstance());
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias, ScratchFile scratchFile) throws IOException {
        super(source);
        this.fileLen = source.length();
        this.password = decryptionPassword;
        this.keyStoreInputStream = keyStore;
        this.keyAlias = alias;
        this.init(scratchFile);
    }

    private void init(ScratchFile scratchFile) throws IOException {
        String eofLookupRangeStr = System.getProperty("com.tom_roush.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                Log.w((String)"PdfBox-Android", (String)("System property com.tom_roush.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(scratchFile);
    }

    public PDDocument getPDDocument() throws IOException {
        PDDocument doc = new PDDocument(this.getDocument(), this.source, this.accessPermission);
        doc.setEncryptionDictionary(this.encryption);
        return doc;
    }

    protected void initialParse() throws InvalidPasswordException, IOException {
        COSObject catalogObj;
        COSDictionary trailer = null;
        long startXRefOffset = this.getStartxrefOffset();
        boolean rebuildTrailer = false;
        if (startXRefOffset > -1L) {
            try {
                trailer = this.parseXref(startXRefOffset);
            }
            catch (IOException exception) {
                if (this.isLenient()) {
                    rebuildTrailer = true;
                }
                throw exception;
            }
        } else if (this.isLenient()) {
            rebuildTrailer = true;
        }
        if (this.isLenient() && trailer != null && trailer.getItem(COSName.ROOT) == null) {
            rebuildTrailer = true;
        }
        if (rebuildTrailer) {
            trailer = this.rebuildTrailer();
        }
        this.prepareDecryption();
        COSBase base = this.parseTrailerValuesDynamically(trailer);
        if (!(base instanceof COSDictionary)) {
            throw new IOException("Expected root dictionary, but got this: " + base);
        }
        COSDictionary root = (COSDictionary)base;
        if (this.isLenient() && !root.containsKey(COSName.TYPE)) {
            root.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        }
        if ((catalogObj = this.document.getCatalog()) != null && catalogObj.getObject() instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)catalogObj.getObject(), null);
            COSBase infoBase = trailer.getDictionaryObject(COSName.INFO);
            if (infoBase instanceof COSDictionary) {
                this.parseDictObjects((COSDictionary)infoBase, null);
            }
            this.document.setDecrypted();
        }
        this.initialParseDone = true;
    }

    public void parse() throws InvalidPasswordException, IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parsePDFHeader() && !this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            if (!this.initialParseDone) {
                this.initialParse();
            }
            exceptionOccurred = false;
        }
        finally {
            IOUtils.closeQuietly(this.keyStoreInputStream);
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }

    private void prepareDecryption() throws InvalidPasswordException, IOException {
        COSBase trailerEncryptItem = this.document.getTrailer().getItem(COSName.ENCRYPT);
        if (trailerEncryptItem != null && !(trailerEncryptItem instanceof COSNull)) {
            if (trailerEncryptItem instanceof COSObject) {
                COSObject trailerEncryptObj = (COSObject)trailerEncryptItem;
                this.parseDictionaryRecursive(trailerEncryptObj);
            }
            try {
                DecryptionMaterial decryptionMaterial;
                this.encryption = new PDEncryption(this.document.getEncryptionDictionary());
                if (this.keyStoreInputStream != null) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(this.keyStoreInputStream, this.password.toCharArray());
                    decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.keyAlias, this.password);
                } else {
                    decryptionMaterial = new StandardDecryptionMaterial(this.password);
                }
                this.securityHandler = this.encryption.getSecurityHandler();
                this.securityHandler.prepareForDecryption(this.encryption, this.document.getDocumentID(), decryptionMaterial);
                this.accessPermission = this.securityHandler.getCurrentAccessPermission();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption", e);
            }
        }
    }

    private void parseDictionaryRecursive(COSObject dictionaryObject) throws IOException {
        this.parseObjectDynamically(dictionaryObject, true);
        COSDictionary dictionary = (COSDictionary)dictionaryObject.getObject();
        for (COSBase value : dictionary.getValues()) {
            COSObject object;
            if (!(value instanceof COSObject) || (object = (COSObject)value).getObject() != null) continue;
            this.parseDictionaryRecursive(object);
        }
    }
}

