/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font;

import com.tom_roush.fontbox.afm.AFMParser;
import com.tom_roush.fontbox.afm.FontMetrics;
import com.tom_roush.pdfbox.android.PDFBoxResourceLoader;
import com.tom_roush.pdfbox.pdmodel.font.PDType1Font;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class Standard14Fonts {
    private static final Set<String> STANDARD_14_NAMES = new HashSet<String>(34);
    private static final Map<String, String> STANDARD_14_MAPPING = new HashMap<String, String>(34);
    private static final Map<String, FontMetrics> STANDARD14_AFM_MAP = new HashMap<String, FontMetrics>(34);

    private Standard14Fonts() {
    }

    private static void addAFM(String fontName) throws IOException {
        Standard14Fonts.addAFM(fontName, fontName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAFM(String fontName, String afmName) throws IOException {
        InputStream afmStream;
        STANDARD_14_NAMES.add(fontName);
        STANDARD_14_MAPPING.put(fontName, afmName);
        if (STANDARD14_AFM_MAP.containsKey(afmName)) {
            STANDARD14_AFM_MAP.put(fontName, STANDARD14_AFM_MAP.get(afmName));
        }
        String resourceName = "com/tom_roush/pdfbox/resources/afm/" + afmName + ".afm";
        if (PDFBoxResourceLoader.isReady()) {
            afmStream = PDFBoxResourceLoader.getStream(resourceName);
        } else {
            URL url = PDType1Font.class.getClassLoader().getResource(resourceName);
            if (url != null) {
                afmStream = url.openStream();
            } else {
                throw new IOException(resourceName + " not found");
            }
        }
        try {
            AFMParser parser = new AFMParser(afmStream);
            FontMetrics metric = parser.parse(true);
            STANDARD14_AFM_MAP.put(fontName, metric);
        }
        finally {
            afmStream.close();
        }
    }

    public static FontMetrics getAFM(String baseName) {
        return STANDARD14_AFM_MAP.get(baseName);
    }

    public static boolean containsName(String baseName) {
        return STANDARD_14_NAMES.contains(baseName);
    }

    public static Set<String> getNames() {
        return Collections.unmodifiableSet(STANDARD_14_NAMES);
    }

    public static String getMappedFontName(String baseName) {
        return STANDARD_14_MAPPING.get(baseName);
    }

    static {
        try {
            Standard14Fonts.addAFM("Courier-Bold");
            Standard14Fonts.addAFM("Courier-BoldOblique");
            Standard14Fonts.addAFM("Courier");
            Standard14Fonts.addAFM("Courier-Oblique");
            Standard14Fonts.addAFM("Helvetica");
            Standard14Fonts.addAFM("Helvetica-Bold");
            Standard14Fonts.addAFM("Helvetica-BoldOblique");
            Standard14Fonts.addAFM("Helvetica-Oblique");
            Standard14Fonts.addAFM("Symbol");
            Standard14Fonts.addAFM("Times-Bold");
            Standard14Fonts.addAFM("Times-BoldItalic");
            Standard14Fonts.addAFM("Times-Italic");
            Standard14Fonts.addAFM("Times-Roman");
            Standard14Fonts.addAFM("ZapfDingbats");
            Standard14Fonts.addAFM("CourierCourierNew", "Courier");
            Standard14Fonts.addAFM("CourierNew", "Courier");
            Standard14Fonts.addAFM("CourierNew,Italic", "Courier-Oblique");
            Standard14Fonts.addAFM("CourierNew,Bold", "Courier-Bold");
            Standard14Fonts.addAFM("CourierNew,BoldItalic", "Courier-BoldOblique");
            Standard14Fonts.addAFM("Arial", "Helvetica");
            Standard14Fonts.addAFM("Arial,Italic", "Helvetica-Oblique");
            Standard14Fonts.addAFM("Arial,Bold", "Helvetica-Bold");
            Standard14Fonts.addAFM("Arial,BoldItalic", "Helvetica-BoldOblique");
            Standard14Fonts.addAFM("TimesNewRoman", "Times-Roman");
            Standard14Fonts.addAFM("TimesNewRoman,Italic", "Times-Italic");
            Standard14Fonts.addAFM("TimesNewRoman,Bold", "Times-Bold");
            Standard14Fonts.addAFM("TimesNewRoman,BoldItalic", "Times-BoldItalic");
            Standard14Fonts.addAFM("Symbol,Italic", "Symbol");
            Standard14Fonts.addAFM("Symbol,Bold", "Symbol");
            Standard14Fonts.addAFM("Symbol,BoldItalic", "Symbol");
            Standard14Fonts.addAFM("Times", "Times-Roman");
            Standard14Fonts.addAFM("Times,Italic", "Times-Italic");
            Standard14Fonts.addAFM("Times,Bold", "Times-Bold");
            Standard14Fonts.addAFM("Times,BoldItalic", "Times-BoldItalic");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

