/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.FilterFactory;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImageXObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JPEGFactory {
    private JPEGFactory() {
    }

    public static PDImageXObject createFromStream(PDDocument document, InputStream stream) throws IOException {
        return JPEGFactory.createFromByteArray(document, IOUtils.toByteArray(stream));
    }

    public static PDImageXObject createFromByteArray(PDDocument document, byte[] byteArray) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(byteArray);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)byteStream, null, (BitmapFactory.Options)options);
        byteStream.reset();
        PDImageXObject pdImage = new PDImageXObject(document, byteStream, COSName.DCT_DECODE, options.outWidth, options.outHeight, 8, PDDeviceRGB.INSTANCE);
        return pdImage;
    }

    public static PDImageXObject createFromImage(PDDocument document, Bitmap image) throws IOException {
        return JPEGFactory.createFromImage(document, image, 0.75f);
    }

    public static PDImageXObject createFromImage(PDDocument document, Bitmap image, float quality) throws IOException {
        return JPEGFactory.createFromImage(document, image, quality, 72);
    }

    public static PDImageXObject createFromImage(PDDocument document, Bitmap image, float quality, int dpi) throws IOException {
        return JPEGFactory.createJPEG(document, image, quality, dpi);
    }

    private static Bitmap getAlphaImage(Bitmap image) throws IOException {
        if (!image.hasAlpha()) {
            return null;
        }
        return image.extractAlpha();
    }

    private static PDImageXObject createJPEG(PDDocument document, Bitmap image, float quality, int dpi) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JPEGFactory.encodeImageToJPEGStream(image, quality, dpi, baos);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(baos.toByteArray());
        PDImageXObject pdImage = new PDImageXObject(document, byteStream, COSName.DCT_DECODE, image.getWidth(), image.getHeight(), 8, PDDeviceRGB.INSTANCE);
        if (image.hasAlpha()) {
            PDImageXObject xAlpha = JPEGFactory.createAlphaFromARGBImage(document, image);
            pdImage.getCOSObject().setItem(COSName.SMASK, (COSObjectable)xAlpha);
        }
        return pdImage;
    }

    private static PDImageXObject createAlphaFromARGBImage(PDDocument document, Bitmap image) throws IOException {
        if (!image.hasAlpha()) {
            return null;
        }
        int[] pixels = new int[image.getHeight() * image.getWidth()];
        image.getPixels(pixels, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int bpc = 8;
        for (int pixel : pixels) {
            bos.write(Color.alpha((int)pixel));
        }
        PDImageXObject pdImage = JPEGFactory.prepareImageXObject(document, bos.toByteArray(), image.getWidth(), image.getHeight(), bpc, PDDeviceGray.INSTANCE);
        return pdImage;
    }

    private static PDImageXObject prepareImageXObject(PDDocument document, byte[] byteArray, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Filter filter = FilterFactory.INSTANCE.getFilter(COSName.FLATE_DECODE);
        filter.encode(new ByteArrayInputStream(byteArray), baos, new COSDictionary(), 0);
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(baos.toByteArray());
        return new PDImageXObject(document, encodedByteStream, COSName.FLATE_DECODE, width, height, bitsPerComponent, initColorSpace);
    }

    private static void encodeImageToJPEGStream(Bitmap image, float quality, int dpi, OutputStream out) throws IOException {
        image.compress(Bitmap.CompressFormat.JPEG, (int)(quality * 100.0f), out);
    }

    private static Bitmap getColorImage(Bitmap image) {
        if (!image.hasAlpha()) {
            return image;
        }
        if (!image.getConfig().name().contains("RGB")) {
            throw new UnsupportedOperationException("only RGB color spaces are implemented");
        }
        Bitmap rgbImage = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Paint alphaPaint = new Paint();
        alphaPaint.setAlpha(0);
        Canvas canvas = new Canvas(rgbImage);
        canvas.drawBitmap(image, 0.0f, 0.0f, alphaPaint);
        return rgbImage;
    }
}

