/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.annotation;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationLine;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationPopup;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationRubberStamp;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquareCircle;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationTextMarkup;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationUnknown;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import java.io.IOException;
import java.util.Calendar;

public abstract class PDAnnotation
implements COSObjectable {
    private static final int FLAG_INVISIBLE = 1;
    private static final int FLAG_HIDDEN = 2;
    private static final int FLAG_PRINTED = 4;
    private static final int FLAG_NO_ZOOM = 8;
    private static final int FLAG_NO_ROTATE = 16;
    private static final int FLAG_NO_VIEW = 32;
    private static final int FLAG_READ_ONLY = 64;
    private static final int FLAG_LOCKED = 128;
    private static final int FLAG_TOGGLE_NO_VIEW = 256;
    private final COSDictionary dictionary;

    public static PDAnnotation createAnnotation(COSBase base) throws IOException {
        PDAnnotation annot = null;
        if (base instanceof COSDictionary) {
            COSDictionary annotDic = (COSDictionary)base;
            String subtype = annotDic.getNameAsString(COSName.SUBTYPE);
            if ("FileAttachment".equals(subtype)) {
                annot = new PDAnnotationFileAttachment(annotDic);
            } else if ("Line".equals(subtype)) {
                annot = new PDAnnotationLine(annotDic);
            } else if ("Link".equals(subtype)) {
                annot = new PDAnnotationLink(annotDic);
            } else if ("Popup".equals(subtype)) {
                annot = new PDAnnotationPopup(annotDic);
            } else if ("Stamp".equals(subtype)) {
                annot = new PDAnnotationRubberStamp(annotDic);
            } else if ("Square".equals(subtype) || "Circle".equals(subtype)) {
                annot = new PDAnnotationSquareCircle(annotDic);
            } else if ("Text".equals(subtype)) {
                annot = new PDAnnotationText(annotDic);
            } else if ("Highlight".equals(subtype) || "Underline".equals(subtype) || "Squiggly".equals(subtype) || "StrikeOut".equals(subtype)) {
                annot = new PDAnnotationTextMarkup(annotDic);
            } else if ("Link".equals(subtype)) {
                annot = new PDAnnotationLink(annotDic);
            } else if ("Widget".equals(subtype)) {
                annot = new PDAnnotationWidget(annotDic);
            } else if ("FreeText".equals(subtype) || "Polygon".equals(subtype) || "PolyLine".equals(subtype) || "Caret".equals(subtype) || "Ink".equals(subtype) || "Sound".equals(subtype)) {
                annot = new PDAnnotationMarkup(annotDic);
            } else {
                annot = new PDAnnotationUnknown(annotDic);
                Log.d((String)"PdfBox-Android", (String)("Unknown or unsupported annotation subtype " + subtype));
            }
        } else {
            throw new IOException("Error: Unknown annotation type " + base);
        }
        return annot;
    }

    public PDAnnotation() {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.TYPE, (COSBase)COSName.ANNOT);
    }

    public PDAnnotation(COSDictionary dict) {
        this.dictionary = dict;
        this.dictionary.setItem(COSName.TYPE, (COSBase)COSName.ANNOT);
    }

    public PDRectangle getRectangle() {
        COSArray rectArray = (COSArray)this.dictionary.getDictionaryObject(COSName.RECT);
        PDRectangle rectangle = null;
        if (rectArray != null) {
            if (rectArray.size() == 4 && rectArray.getObject(0) instanceof COSNumber && rectArray.getObject(1) instanceof COSNumber && rectArray.getObject(2) instanceof COSNumber && rectArray.getObject(3) instanceof COSNumber) {
                rectangle = new PDRectangle(rectArray);
            } else {
                Log.w((String)"PdfBox-Android", (String)(rectArray + " is not a rectangle array, returning null"));
            }
        }
        return rectangle;
    }

    public void setRectangle(PDRectangle rectangle) {
        this.dictionary.setItem(COSName.RECT, (COSBase)rectangle.getCOSArray());
    }

    public int getAnnotationFlags() {
        return this.getCOSObject().getInt(COSName.F, 0);
    }

    public void setAnnotationFlags(int flags) {
        this.getCOSObject().setInt(COSName.F, flags);
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public COSName getAppearanceState() {
        COSName name = (COSName)this.getCOSObject().getDictionaryObject(COSName.AS);
        if (name != null) {
            return name;
        }
        return null;
    }

    public void setAppearanceState(String as) {
        if (as == null) {
            this.getCOSObject().removeItem(COSName.AS);
        } else {
            this.getCOSObject().setItem(COSName.AS, (COSBase)COSName.getPDFName(as));
        }
    }

    public PDAppearanceDictionary getAppearance() {
        COSDictionary apDic = (COSDictionary)this.dictionary.getDictionaryObject(COSName.AP);
        if (apDic != null) {
            return new PDAppearanceDictionary(apDic);
        }
        return null;
    }

    public void setAppearance(PDAppearanceDictionary appearance) {
        COSDictionary ap = null;
        if (appearance != null) {
            ap = appearance.getCOSObject();
        }
        this.dictionary.setItem(COSName.AP, (COSBase)ap);
    }

    public PDAppearanceStream getNormalAppearanceStream() {
        PDAppearanceDictionary appearanceDict = this.getAppearance();
        if (appearanceDict == null) {
            return null;
        }
        PDAppearanceEntry normalAppearance = appearanceDict.getNormalAppearance();
        if (normalAppearance == null) {
            return null;
        }
        if (normalAppearance.isSubDictionary()) {
            COSName state = this.getAppearanceState();
            return normalAppearance.getSubDictionary().get(state);
        }
        return normalAppearance.getAppearanceStream();
    }

    public boolean isInvisible() {
        return this.getCOSObject().getFlag(COSName.F, 1);
    }

    public void setInvisible(boolean invisible) {
        this.getCOSObject().setFlag(COSName.F, 1, invisible);
    }

    public boolean isHidden() {
        return this.getCOSObject().getFlag(COSName.F, 2);
    }

    public void setHidden(boolean hidden) {
        this.getCOSObject().setFlag(COSName.F, 2, hidden);
    }

    public boolean isPrinted() {
        return this.getCOSObject().getFlag(COSName.F, 4);
    }

    public void setPrinted(boolean printed) {
        this.getCOSObject().setFlag(COSName.F, 4, printed);
    }

    public boolean isNoZoom() {
        return this.getCOSObject().getFlag(COSName.F, 8);
    }

    public void setNoZoom(boolean noZoom) {
        this.getCOSObject().setFlag(COSName.F, 8, noZoom);
    }

    public boolean isNoRotate() {
        return this.getCOSObject().getFlag(COSName.F, 16);
    }

    public void setNoRotate(boolean noRotate) {
        this.getCOSObject().setFlag(COSName.F, 16, noRotate);
    }

    public boolean isNoView() {
        return this.getCOSObject().getFlag(COSName.F, 32);
    }

    public void setNoView(boolean noView) {
        this.getCOSObject().setFlag(COSName.F, 32, noView);
    }

    public boolean isReadOnly() {
        return this.getCOSObject().getFlag(COSName.F, 64);
    }

    public void setReadOnly(boolean readOnly) {
        this.getCOSObject().setFlag(COSName.F, 64, readOnly);
    }

    public boolean isLocked() {
        return this.getCOSObject().getFlag(COSName.F, 128);
    }

    public void setLocked(boolean locked) {
        this.getCOSObject().setFlag(COSName.F, 128, locked);
    }

    public boolean isToggleNoView() {
        return this.getCOSObject().getFlag(COSName.F, 256);
    }

    public void setToggleNoView(boolean toggleNoView) {
        this.getCOSObject().setFlag(COSName.F, 256, toggleNoView);
    }

    public String getContents() {
        return this.dictionary.getString(COSName.CONTENTS);
    }

    public void setContents(String value) {
        this.dictionary.setString(COSName.CONTENTS, value);
    }

    public String getModifiedDate() {
        return this.getCOSObject().getString(COSName.M);
    }

    public void setModifiedDate(String m) {
        this.getCOSObject().setString(COSName.M, m);
    }

    public void setModifiedDate(Calendar c) {
        this.getCOSObject().setDate(COSName.M, c);
    }

    public String getAnnotationName() {
        return this.getCOSObject().getString(COSName.NM);
    }

    public void setAnnotationName(String nm) {
        this.getCOSObject().setString(COSName.NM, nm);
    }

    public int getStructParent() {
        return this.getCOSObject().getInt(COSName.STRUCT_PARENT, 0);
    }

    public void setStructParent(int structParent) {
        this.getCOSObject().setInt(COSName.STRUCT_PARENT, structParent);
    }

    public COSArray getBorder() {
        COSArray border;
        COSBase base = this.getCOSObject().getDictionaryObject(COSName.BORDER);
        if (base instanceof COSArray) {
            border = (COSArray)base;
            if (border.size() < 3) {
                COSArray newBorder = new COSArray();
                newBorder.addAll(border);
                border = newBorder;
                while (border.size() < 3) {
                    border.add(COSInteger.ZERO);
                }
            }
        } else {
            border = new COSArray();
            border.add(COSInteger.ZERO);
            border.add(COSInteger.ZERO);
            border.add(COSInteger.ONE);
        }
        return border;
    }

    public void setBorder(COSArray borderArray) {
        this.getCOSObject().setItem(COSName.BORDER, (COSBase)borderArray);
    }

    public void setColor(PDColor c) {
        this.getCOSObject().setItem(COSName.C, (COSBase)c.toCOSArray());
    }

    public PDColor getColor() {
        return this.getColor(COSName.C);
    }

    protected PDColor getColor(COSName itemName) {
        COSBase c = this.getCOSObject().getItem(itemName);
        if (c instanceof COSArray) {
            PDDeviceColorSpace colorSpace = null;
            switch (((COSArray)c).size()) {
                case 1: {
                    colorSpace = PDDeviceGray.INSTANCE;
                    break;
                }
                case 3: {
                    colorSpace = PDDeviceRGB.INSTANCE;
                    break;
                }
                case 4: {
                    break;
                }
            }
            return new PDColor((COSArray)c, (PDColorSpace)colorSpace);
        }
        return null;
    }

    public String getSubtype() {
        return this.getCOSObject().getNameAsString(COSName.SUBTYPE);
    }

    public void setPage(PDPage page) {
        this.getCOSObject().setItem(COSName.P, (COSObjectable)page);
    }

    public PDPage getPage() {
        COSDictionary p = (COSDictionary)this.getCOSObject().getDictionaryObject(COSName.P);
        if (p != null) {
            return new PDPage(p);
        }
        return null;
    }
}

