/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.annotation;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDFormXObject;

public class PDAppearanceCharacteristicsDictionary
implements COSObjectable {
    private final COSDictionary dictionary;

    public PDAppearanceCharacteristicsDictionary(COSDictionary dict) {
        this.dictionary = dict;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public int getRotation() {
        return this.getCOSObject().getInt(COSName.R, 0);
    }

    public void setRotation(int rotation) {
        this.getCOSObject().setInt(COSName.R, rotation);
    }

    public PDColor getBorderColour() {
        return this.getColor(COSName.BC);
    }

    public void setBorderColour(PDColor c) {
        this.getCOSObject().setItem(COSName.BC, (COSBase)c.toCOSArray());
    }

    public PDColor getBackground() {
        return this.getColor(COSName.BG);
    }

    public void setBackground(PDColor c) {
        this.getCOSObject().setItem(COSName.BG, (COSBase)c.toCOSArray());
    }

    public String getNormalCaption() {
        return this.getCOSObject().getString("CA");
    }

    public void setNormalCaption(String caption) {
        this.getCOSObject().setString("CA", caption);
    }

    public String getRolloverCaption() {
        return this.getCOSObject().getString("RC");
    }

    public void setRolloverCaption(String caption) {
        this.getCOSObject().setString("RC", caption);
    }

    public String getAlternateCaption() {
        return this.getCOSObject().getString("AC");
    }

    public void setAlternateCaption(String caption) {
        this.getCOSObject().setString("AC", caption);
    }

    public PDFormXObject getNormalIcon() {
        COSBase i = this.getCOSObject().getDictionaryObject("I");
        if (i instanceof COSStream) {
            return new PDFormXObject((COSStream)i);
        }
        return null;
    }

    public PDFormXObject getRolloverIcon() {
        COSBase i = this.getCOSObject().getDictionaryObject("RI");
        if (i instanceof COSStream) {
            return new PDFormXObject((COSStream)i);
        }
        return null;
    }

    public PDFormXObject getAlternateIcon() {
        COSBase i = this.getCOSObject().getDictionaryObject("IX");
        if (i instanceof COSStream) {
            return new PDFormXObject((COSStream)i);
        }
        return null;
    }

    private PDColor getColor(COSName itemName) {
        COSBase c = this.getCOSObject().getItem(itemName);
        if (c instanceof COSArray) {
            PDDeviceColorSpace colorSpace;
            switch (((COSArray)c).size()) {
                case 1: {
                    colorSpace = PDDeviceGray.INSTANCE;
                    break;
                }
                case 3: {
                    colorSpace = PDDeviceRGB.INSTANCE;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new PDColor((COSArray)c, (PDColorSpace)colorSpace);
        }
        return null;
    }
}

