/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdfparser;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSObjectKey;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdfparser.BaseParser;
import com.tom_roush.pdfbox.pdfparser.InputStreamSource;
import com.tom_roush.pdfbox.pdfparser.XrefTrailerResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class PDFXrefStreamParser
extends BaseParser {
    private final COSStream stream;
    private final XrefTrailerResolver xrefTrailerResolver;

    public PDFXrefStreamParser(COSStream stream, COSDocument document, XrefTrailerResolver resolver) throws IOException {
        super(new InputStreamSource(stream.createInputStream()));
        this.document = document;
        this.stream = stream;
        this.xrefTrailerResolver = resolver;
    }

    public void parse() throws IOException {
        COSBase w = this.stream.getDictionaryObject(COSName.W);
        if (!(w instanceof COSArray)) {
            throw new IOException("/W array is missing in Xref stream");
        }
        COSArray xrefFormat = (COSArray)w;
        COSArray indexArray = (COSArray)this.stream.getDictionaryObject(COSName.INDEX);
        if (indexArray == null) {
            indexArray = new COSArray();
            indexArray.add(COSInteger.ZERO);
            indexArray.add(this.stream.getDictionaryObject(COSName.SIZE));
        }
        ArrayList<Long> objNums = new ArrayList<Long>();
        Iterator<COSBase> indexIter = indexArray.iterator();
        while (indexIter.hasNext()) {
            long objID = ((COSInteger)indexIter.next()).longValue();
            int size = ((COSInteger)indexIter.next()).intValue();
            for (int i = 0; i < size; ++i) {
                objNums.add(objID + (long)i);
            }
        }
        Iterator objIter = objNums.iterator();
        int w0 = xrefFormat.getInt(0);
        int w1 = xrefFormat.getInt(1);
        int w2 = xrefFormat.getInt(2);
        int lineSize = w0 + w1 + w2;
        while (!this.seqSource.isEOF() && objIter.hasNext()) {
            int type;
            byte[] currLine = new byte[lineSize];
            this.seqSource.read(currLine);
            if (w0 == 0) {
                type = 1;
            } else {
                type = 0;
                for (int i = 0; i < w0; ++i) {
                    type += (currLine[i] & 0xFF) << (w0 - i - 1) * 8;
                }
            }
            Long objID = (Long)objIter.next();
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    int offset = 0;
                    for (int i = 0; i < w1; ++i) {
                        offset += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                    }
                    int genNum = 0;
                    for (int i = 0; i < w2; ++i) {
                        genNum += (currLine[i + w0 + w1] & 0xFF) << (w2 - i - 1) * 8;
                    }
                    COSObjectKey objKey = new COSObjectKey(objID, genNum);
                    this.xrefTrailerResolver.setXRef(objKey, offset);
                    break;
                }
                case 2: {
                    int objstmObjNr = 0;
                    for (int i = 0; i < w1; ++i) {
                        objstmObjNr += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                    }
                    COSObjectKey objKey = new COSObjectKey(objID, 0);
                    this.xrefTrailerResolver.setXRef(objKey, -objstmObjNr);
                    break;
                }
            }
        }
    }
}

