/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font;

import com.tom_roush.fontbox.ttf.TrueTypeFont;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType2;
import com.tom_roush.pdfbox.pdmodel.font.PDType0Font;
import com.tom_roush.pdfbox.pdmodel.font.ToUnicodeWriter;
import com.tom_roush.pdfbox.pdmodel.font.TrueTypeEmbedder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class PDCIDFontType2Embedder
extends TrueTypeEmbedder {
    private final PDDocument document;
    private final PDType0Font parent;
    private final COSDictionary dict;
    private final COSDictionary cidFont;

    PDCIDFontType2Embedder(PDDocument document, COSDictionary dict, TrueTypeFont ttf, boolean embedSubset, PDType0Font parent) throws IOException {
        super(document, dict, ttf, embedSubset);
        this.document = document;
        this.dict = dict;
        this.parent = parent;
        dict.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE0);
        dict.setName(COSName.BASE_FONT, this.fontDescriptor.getFontName());
        dict.setItem(COSName.ENCODING, (COSBase)COSName.IDENTITY_H);
        this.cidFont = this.createCIDFont();
        COSArray descendantFonts = new COSArray();
        descendantFonts.add(this.cidFont);
        dict.setItem(COSName.DESCENDANT_FONTS, (COSBase)descendantFonts);
        if (!embedSubset) {
            this.buildToUnicodeCMap(null);
        }
    }

    @Override
    protected void buildSubset(InputStream ttfSubset, String tag, Map<Integer, Integer> gidToCid) throws IOException {
        HashMap<Integer, Integer> cidToGid = new HashMap<Integer, Integer>(gidToCid.size());
        for (Map.Entry<Integer, Integer> entry : gidToCid.entrySet()) {
            int newGID = entry.getKey();
            int oldGID = entry.getValue();
            cidToGid.put(oldGID, newGID);
        }
        this.buildToUnicodeCMap(gidToCid);
        this.buildFontFile2(ttfSubset);
        this.addNameTag(tag);
        this.buildWidths(cidToGid);
        this.buildCIDToGIDMap(cidToGid);
        this.buildCIDSet(cidToGid);
    }

    private void buildToUnicodeCMap(Map<Integer, Integer> newGIDToOldCID) throws IOException {
        float version;
        ToUnicodeWriter toUniWriter = new ToUnicodeWriter();
        boolean hasSurrogates = false;
        int max = this.ttf.getMaximumProfile().getNumGlyphs();
        for (int gid = 1; gid <= max; ++gid) {
            int cid;
            if (newGIDToOldCID != null) {
                if (!newGIDToOldCID.containsKey(gid)) continue;
                cid = newGIDToOldCID.get(gid);
            } else {
                cid = gid;
            }
            List<Integer> codes = this.cmap.getCharCodes(cid);
            if (codes == null) continue;
            int codePoint = codes.get(0);
            if (codePoint > 65535) {
                hasSurrogates = true;
            }
            toUniWriter.add(cid, new String(new int[]{codePoint}, 0, 1));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        toUniWriter.writeTo(out);
        ByteArrayInputStream cMapStream = new ByteArrayInputStream(out.toByteArray());
        PDStream stream = new PDStream(this.document, (InputStream)cMapStream, COSName.FLATE_DECODE);
        if (hasSurrogates && (double)(version = this.document.getVersion()) < 1.5) {
            this.document.setVersion(1.5f);
        }
        this.dict.setItem(COSName.TO_UNICODE, (COSObjectable)stream);
    }

    private COSDictionary toCIDSystemInfo(String registry, String ordering, int supplement) {
        COSDictionary info = new COSDictionary();
        info.setString(COSName.REGISTRY, registry);
        info.setString(COSName.ORDERING, ordering);
        info.setInt(COSName.SUPPLEMENT, supplement);
        return info;
    }

    private COSDictionary createCIDFont() throws IOException {
        COSDictionary cidFont = new COSDictionary();
        cidFont.setItem(COSName.TYPE, (COSBase)COSName.FONT);
        cidFont.setItem(COSName.SUBTYPE, (COSBase)COSName.CID_FONT_TYPE2);
        cidFont.setName(COSName.BASE_FONT, this.fontDescriptor.getFontName());
        COSDictionary info = this.toCIDSystemInfo("Adobe", "Identity", 0);
        cidFont.setItem(COSName.CIDSYSTEMINFO, (COSBase)info);
        cidFont.setItem(COSName.FONT_DESC, (COSBase)this.fontDescriptor.getCOSObject());
        this.buildWidths(cidFont);
        cidFont.setItem(COSName.CID_TO_GID_MAP, (COSBase)COSName.IDENTITY);
        return cidFont;
    }

    private void addNameTag(String tag) throws IOException {
        String name = this.fontDescriptor.getFontName();
        String newName = tag + name;
        this.dict.setName(COSName.BASE_FONT, newName);
        this.fontDescriptor.setFontName(newName);
        this.cidFont.setName(COSName.BASE_FONT, newName);
    }

    private void buildCIDToGIDMap(Map<Integer, Integer> cidToGid) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int cidMax = Collections.max(cidToGid.keySet());
        for (int i = 0; i <= cidMax; ++i) {
            int gid = cidToGid.containsKey(i) ? cidToGid.get(i) : 0;
            out.write(new byte[]{(byte)(gid >> 8 & 0xFF), (byte)(gid & 0xFF)});
        }
        byte[] byteArray = out.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
        PDStream stream = new PDStream(this.document, (InputStream)input, COSName.FLATE_DECODE);
        stream.getCOSObject().setInt(COSName.LENGTH1, byteArray.length);
        this.cidFont.setItem(COSName.CID_TO_GID_MAP, (COSObjectable)stream);
    }

    private void buildCIDSet(Map<Integer, Integer> cidToGid) throws IOException {
        byte[] bytes = new byte[Collections.max(cidToGid.keySet()) / 8 + 1];
        for (int cid : cidToGid.keySet()) {
            int mask = 1 << 7 - cid % 8;
            int n = cid / 8;
            bytes[n] = (byte)(bytes[n] | mask);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        PDStream stream = new PDStream(this.document, (InputStream)input, COSName.FLATE_DECODE);
        this.fontDescriptor.setCIDSet(stream);
    }

    private void buildWidths(Map<Integer, Integer> cidToGid) throws IOException {
        float scaling = 1000.0f / (float)this.ttf.getHeader().getUnitsPerEm();
        COSArray widths = new COSArray();
        COSArray ws = new COSArray();
        int prev = Integer.MIN_VALUE;
        TreeSet<Integer> keys = new TreeSet<Integer>(cidToGid.keySet());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int cid = (Integer)iterator.next();
            int gid = cidToGid.get(cid);
            long width = Math.round((float)this.ttf.getHorizontalMetrics().getAdvanceWidth(gid) * scaling);
            if (width == 1000L) continue;
            if (prev != cid - 1) {
                ws = new COSArray();
                widths.add(COSInteger.get(cid));
                widths.add(ws);
            }
            ws.add(COSInteger.get(width));
            prev = cid;
        }
        this.cidFont.setItem(COSName.W, (COSBase)widths);
    }

    private void buildWidths(COSDictionary cidFont) throws IOException {
        int cidMax = this.ttf.getNumberOfGlyphs();
        int[] gidwidths = new int[cidMax * 2];
        for (int cid = 0; cid < cidMax; ++cid) {
            gidwidths[cid * 2] = cid;
            gidwidths[cid * 2 + 1] = this.ttf.getHorizontalMetrics().getAdvanceWidth(cid);
        }
        cidFont.setItem(COSName.W, (COSBase)this.getWidths(gidwidths));
    }

    private COSArray getWidths(int[] widths) throws IOException {
        if (widths.length == 0) {
            throw new IllegalArgumentException("length of widths must be > 0");
        }
        float scaling = 1000.0f / (float)this.ttf.getHeader().getUnitsPerEm();
        long lastCid = widths[0];
        long lastValue = Math.round((float)widths[1] * scaling);
        COSArray inner = null;
        COSArray outer = new COSArray();
        outer.add(COSInteger.get(lastCid));
        State state = State.FIRST;
        for (int i = 2; i < widths.length; i += 2) {
            long cid = widths[i];
            long value = Math.round((float)widths[i + 1] * scaling);
            switch (state) {
                case FIRST: {
                    if (cid == lastCid + 1L && value == lastValue) {
                        state = State.SERIAL;
                        break;
                    }
                    if (cid == lastCid + 1L) {
                        state = State.BRACKET;
                        inner = new COSArray();
                        inner.add(COSInteger.get(lastValue));
                        break;
                    }
                    inner = new COSArray();
                    inner.add(COSInteger.get(lastValue));
                    outer.add(inner);
                    outer.add(COSInteger.get(cid));
                    break;
                }
                case BRACKET: {
                    if (cid == lastCid + 1L && value == lastValue) {
                        state = State.SERIAL;
                        outer.add(inner);
                        outer.add(COSInteger.get(lastCid));
                        break;
                    }
                    if (cid == lastCid + 1L) {
                        inner.add(COSInteger.get(lastValue));
                        break;
                    }
                    state = State.FIRST;
                    inner.add(COSInteger.get(lastValue));
                    outer.add(inner);
                    outer.add(COSInteger.get(cid));
                    break;
                }
                case SERIAL: {
                    if (cid == lastCid + 1L && value == lastValue) break;
                    outer.add(COSInteger.get(lastCid));
                    outer.add(COSInteger.get(lastValue));
                    outer.add(COSInteger.get(cid));
                    state = State.FIRST;
                }
            }
            lastValue = value;
            lastCid = cid;
        }
        switch (state) {
            case FIRST: {
                inner = new COSArray();
                inner.add(COSInteger.get(lastValue));
                outer.add(inner);
                break;
            }
            case BRACKET: {
                inner.add(COSInteger.get(lastValue));
                outer.add(inner);
                break;
            }
            case SERIAL: {
                outer.add(COSInteger.get(lastCid));
                outer.add(COSInteger.get(lastValue));
            }
        }
        return outer;
    }

    public PDCIDFont getCIDFont() throws IOException {
        return new PDCIDFontType2(this.cidFont, this.parent, this.ttf);
    }

    static enum State {
        FIRST,
        BRACKET,
        SERIAL;

    }
}

