/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.state;

import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.graphics.PDLineDashPattern;
import com.tom_roush.pdfbox.pdmodel.graphics.blend.BlendMode;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDSoftMask;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDTextState;
import com.tom_roush.pdfbox.pdmodel.graphics.state.RenderingIntent;
import com.tom_roush.pdfbox.util.Matrix;

public class PDGraphicsState
implements Cloneable {
    private boolean isClippingPathDirty;
    private Region clippingPath;
    private Matrix currentTransformationMatrix = new Matrix();
    private PDColor strokingColor = PDDeviceGray.INSTANCE.getInitialColor();
    private PDColor nonStrokingColor = PDDeviceGray.INSTANCE.getInitialColor();
    private PDColorSpace strokingColorSpace = PDDeviceGray.INSTANCE;
    private PDColorSpace nonStrokingColorSpace = PDDeviceGray.INSTANCE;
    private PDTextState textState = new PDTextState();
    private float lineWidth = 1.0f;
    private Paint.Cap lineCap = Paint.Cap.BUTT;
    private Paint.Join lineJoin = Paint.Join.MITER;
    private float miterLimit = 10.0f;
    private PDLineDashPattern lineDashPattern = new PDLineDashPattern();
    private RenderingIntent renderingIntent;
    private boolean strokeAdjustment = false;
    private BlendMode blendMode = BlendMode.COMPATIBLE;
    private PDSoftMask softMask;
    private double alphaConstant = 1.0;
    private double nonStrokingAlphaConstant = 1.0;
    private boolean alphaSource = false;
    private boolean overprint = false;
    private boolean nonStrokingOverprint = false;
    private double overprintMode = 0.0;
    private COSBase transfer = null;
    private double flatness = 1.0;
    private double smoothness = 0.0;

    public PDGraphicsState(PDRectangle page) {
        RectF bounds = new RectF();
        page.toGeneralPath().computeBounds(bounds, true);
        this.clippingPath = new Region();
        Rect boundsRounded = new Rect();
        bounds.round(boundsRounded);
        this.clippingPath.setPath(page.toGeneralPath(), new Region(boundsRounded));
    }

    public Matrix getCurrentTransformationMatrix() {
        return this.currentTransformationMatrix;
    }

    public void setCurrentTransformationMatrix(Matrix value) {
        this.currentTransformationMatrix = value;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
    }

    public Paint.Cap getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(Paint.Cap value) {
        this.lineCap = value;
    }

    public Paint.Join getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(Paint.Join value) {
        this.lineJoin = value;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(float value) {
        this.miterLimit = value;
    }

    public boolean isStrokeAdjustment() {
        return this.strokeAdjustment;
    }

    public void setStrokeAdjustment(boolean value) {
        this.strokeAdjustment = value;
    }

    public double getAlphaConstant() {
        return this.alphaConstant;
    }

    public void setAlphaConstant(double value) {
        this.alphaConstant = value;
    }

    @Deprecated
    public double getNonStrokeAlphaConstants() {
        return this.nonStrokingAlphaConstant;
    }

    @Deprecated
    public void setNonStrokeAlphaConstants(double value) {
        this.nonStrokingAlphaConstant = value;
    }

    public double getNonStrokeAlphaConstant() {
        return this.nonStrokingAlphaConstant;
    }

    public void setNonStrokeAlphaConstant(double value) {
        this.nonStrokingAlphaConstant = value;
    }

    public boolean isAlphaSource() {
        return this.alphaSource;
    }

    public void setAlphaSource(boolean value) {
        this.alphaSource = value;
    }

    public PDSoftMask getSoftMask() {
        return this.softMask;
    }

    public void setSoftMask(PDSoftMask softMask) {
        this.softMask = softMask;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    public boolean isOverprint() {
        return this.overprint;
    }

    public void setOverprint(boolean value) {
        this.overprint = value;
    }

    public boolean isNonStrokingOverprint() {
        return this.nonStrokingOverprint;
    }

    public void setNonStrokingOverprint(boolean value) {
        this.nonStrokingOverprint = value;
    }

    public double getOverprintMode() {
        return this.overprintMode;
    }

    public void setOverprintMode(double value) {
        this.overprintMode = value;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double value) {
        this.flatness = value;
    }

    public double getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(double value) {
        this.smoothness = value;
    }

    public PDTextState getTextState() {
        return this.textState;
    }

    public void setTextState(PDTextState value) {
        this.textState = value;
    }

    public PDLineDashPattern getLineDashPattern() {
        return this.lineDashPattern;
    }

    public void setLineDashPattern(PDLineDashPattern value) {
        this.lineDashPattern = value;
    }

    public RenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(RenderingIntent value) {
        this.renderingIntent = value;
    }

    public PDGraphicsState clone() {
        try {
            PDGraphicsState clone = (PDGraphicsState)super.clone();
            clone.textState = this.textState.clone();
            clone.currentTransformationMatrix = this.currentTransformationMatrix.clone();
            clone.strokingColor = this.strokingColor;
            clone.nonStrokingColor = this.nonStrokingColor;
            clone.lineDashPattern = this.lineDashPattern;
            clone.clippingPath = this.clippingPath;
            clone.isClippingPathDirty = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public PDColor getStrokingColor() {
        return this.strokingColor;
    }

    public void setStrokingColor(PDColor color) {
        this.strokingColor = color;
    }

    public PDColor getNonStrokingColor() {
        return this.nonStrokingColor;
    }

    public void setNonStrokingColor(PDColor color) {
        this.nonStrokingColor = color;
    }

    public PDColorSpace getStrokingColorSpace() {
        return this.strokingColorSpace;
    }

    public void setStrokingColorSpace(PDColorSpace colorSpace) {
        this.strokingColorSpace = colorSpace;
    }

    public PDColorSpace getNonStrokingColorSpace() {
        return this.nonStrokingColorSpace;
    }

    public void setNonStrokingColorSpace(PDColorSpace colorSpace) {
        this.nonStrokingColorSpace = colorSpace;
    }

    public void intersectClippingPath(Path path) {
        RectF bounds = new RectF();
        path.computeBounds(bounds, true);
        Region r = new Region();
        Rect boundsRounded = new Rect();
        bounds.round(boundsRounded);
        r.setPath(path, new Region(boundsRounded));
        this.intersectClippingPath(r);
    }

    public void intersectClippingPath(Region area) {
        if (!this.isClippingPathDirty) {
            Region cloned;
            this.clippingPath = cloned = new Region(area);
            this.isClippingPathDirty = true;
        }
        this.clippingPath.op(area, Region.Op.INTERSECT);
    }

    public Region getCurrentClippingPath() {
        return this.clippingPath;
    }

    public COSBase getTransfer() {
        return this.transfer;
    }

    public void setTransfer(COSBase transfer) {
        this.transfer = transfer;
    }
}

