/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSArrayList;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.fdf.FDFField;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PDNonTerminalField
extends PDField {
    public PDNonTerminalField(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDNonTerminalField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    @Override
    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.getCOSObject().getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    @Override
    void importFDF(FDFField fdfField) throws IOException {
        super.importFDF(fdfField);
        List<FDFField> fdfKids = fdfField.getKids();
        List<PDField> children = this.getChildren();
        for (int i = 0; fdfKids != null && i < fdfKids.size(); ++i) {
            for (COSObjectable cOSObjectable : children) {
                if (!(cOSObjectable instanceof PDField)) continue;
                PDField pdChild = (PDField)cOSObjectable;
                FDFField fdfChild = fdfKids.get(i);
                String fdfName = fdfChild.getPartialFieldName();
                if (fdfName == null || !fdfName.equals(pdChild.getPartialName())) continue;
                pdChild.importFDF(fdfChild);
            }
        }
    }

    @Override
    FDFField exportFDF() throws IOException {
        FDFField fdfField = new FDFField();
        fdfField.setPartialFieldName(this.getPartialName());
        fdfField.setValue(this.getValue());
        List<PDField> children = this.getChildren();
        ArrayList<FDFField> fdfChildren = new ArrayList<FDFField>();
        for (PDField child : children) {
            fdfChildren.add(child.exportFDF());
        }
        fdfField.setKids(fdfChildren);
        return fdfField;
    }

    public List<PDField> getChildren() {
        ArrayList<PDField> children = new ArrayList<PDField>();
        COSArray kids = (COSArray)this.getCOSObject().getDictionaryObject(COSName.KIDS);
        for (int i = 0; i < kids.size(); ++i) {
            PDField field;
            COSBase kid = kids.getObject(i);
            if (!(kid instanceof COSDictionary) || (field = PDField.fromDictionary(this.getAcroForm(), (COSDictionary)kid, this)) == null) continue;
            children.add(field);
        }
        return children;
    }

    public void setChildren(List<PDField> children) {
        COSArray kidsArray = COSArrayList.converterToCOSArray(children);
        this.getCOSObject().setItem(COSName.KIDS, (COSBase)kidsArray);
    }

    @Override
    public String getFieldType() {
        return this.getCOSObject().getNameAsString(COSName.FT);
    }

    public COSBase getValue() {
        return this.getCOSObject().getDictionaryObject(COSName.V);
    }

    @Override
    public String getValueAsString() {
        COSBase fieldValue = this.getCOSObject().getDictionaryObject(COSName.V);
        return fieldValue != null ? fieldValue.toString() : "";
    }

    public void setValue(COSBase object) throws IOException {
        this.getCOSObject().setItem(COSName.V, object);
    }

    @Override
    public void setValue(String value) throws IOException {
        this.getCOSObject().setString(COSName.V, value);
    }

    public COSBase getDefaultValue() {
        return this.getCOSObject().getDictionaryObject(COSName.DV);
    }

    public void setDefaultValue(COSBase value) {
        this.getCOSObject().setItem(COSName.V, value);
    }

    @Override
    public List<PDAnnotationWidget> getWidgets() {
        return Collections.emptyList();
    }
}

