/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.cos;

import android.util.Log;
import com.tom_roush.pdfbox.android.PDFBoxConfig;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSInputStream;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSOutputStream;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.cos.ICOSVisitor;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.FilterFactory;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.io.RandomAccess;
import com.tom_roush.pdfbox.io.RandomAccessInputStream;
import com.tom_roush.pdfbox.io.RandomAccessOutputStream;
import com.tom_roush.pdfbox.io.ScratchFile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class COSStream
extends COSDictionary
implements Closeable {
    private RandomAccess randomAccess;
    private final ScratchFile scratchFile;
    private boolean isWriting;

    public COSStream() {
        this(ScratchFile.getMainMemoryOnlyInstance());
    }

    public COSStream(ScratchFile scratchFile) {
        this.setInt(COSName.LENGTH, 0);
        this.scratchFile = scratchFile != null ? scratchFile : ScratchFile.getMainMemoryOnlyInstance();
    }

    private void checkClosed() throws IOException {
        if (this.randomAccess != null && this.randomAccess.isClosed()) {
            throw new IOException("COSStream has been closed and cannot be read. Perhaps its enclosing PDDocument has been closed?");
        }
    }

    @Deprecated
    public InputStream getFilteredStream() throws IOException {
        return this.createRawInputStream();
    }

    private void ensureRandomAccessExists(boolean forInputStream) throws IOException {
        if (this.randomAccess == null) {
            if (forInputStream && PDFBoxConfig.isDebugEnabled()) {
                Log.d((String)"PdfBox-Android", (String)"Create InputStream called without data being written before to stream.");
            }
            this.randomAccess = this.scratchFile.createBuffer();
        }
    }

    public InputStream createRawInputStream() throws IOException {
        this.checkClosed();
        if (this.isWriting) {
            throw new IllegalStateException("Cannot read while there is an open stream writer");
        }
        this.ensureRandomAccessExists(true);
        return new RandomAccessInputStream(this.randomAccess);
    }

    @Deprecated
    public InputStream getUnfilteredStream() throws IOException {
        return this.createInputStream();
    }

    public COSInputStream createInputStream() throws IOException {
        this.checkClosed();
        if (this.isWriting) {
            throw new IllegalStateException("Cannot read while there is an open stream writer");
        }
        this.ensureRandomAccessExists(true);
        RandomAccessInputStream input = new RandomAccessInputStream(this.randomAccess);
        return COSInputStream.create(this.getFilterList(), this, input, this.scratchFile);
    }

    @Deprecated
    public OutputStream createUnfilteredStream() throws IOException {
        return this.createOutputStream();
    }

    public OutputStream createOutputStream() throws IOException {
        return this.createOutputStream(null);
    }

    public OutputStream createOutputStream(COSBase filters) throws IOException {
        this.checkClosed();
        if (this.isWriting) {
            throw new IllegalStateException("Cannot have more than one open stream writer.");
        }
        if (filters != null) {
            this.setItem(COSName.FILTER, filters);
        }
        this.randomAccess = this.scratchFile.createBuffer();
        RandomAccessOutputStream randomOut = new RandomAccessOutputStream(this.randomAccess);
        COSOutputStream cosOut = new COSOutputStream(this.getFilterList(), this, randomOut, this.scratchFile);
        this.isWriting = true;
        return new FilterOutputStream(cosOut){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                super.close();
                COSStream.this.setInt(COSName.LENGTH, (int)COSStream.this.randomAccess.length());
                COSStream.this.isWriting = false;
            }
        };
    }

    @Deprecated
    public OutputStream createFilteredStream() throws IOException {
        return this.createRawOutputStream();
    }

    public OutputStream createRawOutputStream() throws IOException {
        this.checkClosed();
        if (this.isWriting) {
            throw new IllegalStateException("Cannot have more than one open stream writer.");
        }
        this.randomAccess = this.scratchFile.createBuffer();
        RandomAccessOutputStream out = new RandomAccessOutputStream(this.randomAccess);
        this.isWriting = true;
        return new FilterOutputStream(out){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                super.close();
                COSStream.this.setInt(COSName.LENGTH, (int)COSStream.this.randomAccess.length());
                COSStream.this.isWriting = false;
            }
        };
    }

    private List<Filter> getFilterList() throws IOException {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        COSBase filters = this.getFilters();
        if (filters instanceof COSName) {
            filterList.add(FilterFactory.INSTANCE.getFilter((COSName)filters));
        } else if (filters instanceof COSArray) {
            COSArray filterArray = (COSArray)filters;
            for (int i = 0; i < filterArray.size(); ++i) {
                COSName filterName = (COSName)filterArray.get(i);
                filterList.add(FilterFactory.INSTANCE.getFilter(filterName));
            }
        }
        return filterList;
    }

    public long getLength() {
        if (this.isWriting) {
            throw new IllegalStateException("There is an open OutputStream associated with this COSStream. It must be closed before queryinglength of this COSStream.");
        }
        return this.getInt(COSName.LENGTH, 0);
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    @Deprecated
    public void setFilters(COSBase filters) throws IOException {
        this.setItem(COSName.FILTER, filters);
    }

    @Deprecated
    public String getString() {
        return this.toTextString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toTextString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        COSInputStream input = null;
        try {
            input = this.createInputStream();
            IOUtils.copy(input, out);
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        COSString string = new COSString(out.toByteArray());
        return string.getString();
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return visitor.visitFromStream(this);
    }

    @Override
    public void close() throws IOException {
        if (this.randomAccess != null) {
            this.randomAccess.close();
        }
    }
}

