/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.state;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.function.PDFunction;
import com.tom_roush.pdfbox.pdmodel.graphics.PDXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;

public final class PDSoftMask
implements COSObjectable {
    private final COSDictionary dictionary;
    private COSName subType = null;
    private PDTransparencyGroup group = null;
    private COSArray backdropColor = null;
    private PDFunction transferFunction = null;
    private Matrix ctm;

    public static PDSoftMask create(COSBase dictionary) {
        if (dictionary instanceof COSName) {
            if (COSName.NONE.equals(dictionary)) {
                return null;
            }
            Log.w((String)"PdfBox-Android", (String)("Invalid SMask " + dictionary));
            return null;
        }
        if (dictionary instanceof COSDictionary) {
            return new PDSoftMask((COSDictionary)dictionary);
        }
        Log.w((String)"PdfBox-Android", (String)("Invalid SMask " + dictionary));
        return null;
    }

    public PDSoftMask(COSDictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public COSName getSubType() {
        if (this.subType == null) {
            this.subType = (COSName)this.getCOSObject().getDictionaryObject(COSName.S);
        }
        return this.subType;
    }

    public PDTransparencyGroup getGroup() throws IOException {
        PDXObject x;
        COSBase cosGroup;
        if (this.group == null && (cosGroup = this.getCOSObject().getDictionaryObject(COSName.G)) != null && (x = PDXObject.createXObject(cosGroup, null)) instanceof PDTransparencyGroup) {
            this.group = (PDTransparencyGroup)x;
        }
        return this.group;
    }

    public COSArray getBackdropColor() {
        if (this.backdropColor == null) {
            this.backdropColor = (COSArray)this.getCOSObject().getDictionaryObject(COSName.BC);
        }
        return this.backdropColor;
    }

    public PDFunction getTransferFunction() throws IOException {
        COSBase cosTF;
        if (this.transferFunction == null && (cosTF = this.getCOSObject().getDictionaryObject(COSName.TR)) != null) {
            this.transferFunction = PDFunction.create(cosTF);
        }
        return this.transferFunction;
    }

    void setInitialTransformationMatrix(Matrix ctm) {
        this.ctm = ctm;
    }

    public Matrix getInitialTransformationMatrix() {
        return this.ctm;
    }
}

