/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class COSFilterInputStream
extends FilterInputStream {
    private final int[] byteRange;
    private long position = 0L;

    public COSFilterInputStream(InputStream in, int[] byteRange) {
        super(in);
        this.byteRange = byteRange;
    }

    public COSFilterInputStream(byte[] in, int[] byteRange) {
        super(new ByteArrayInputStream(in));
        this.byteRange = byteRange;
    }

    @Override
    public int read() throws IOException {
        this.nextAvailable();
        int i = super.read();
        if (i > -1) {
            ++this.position;
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    private boolean inRange() throws IOException {
        long pos = this.position;
        for (int i = 0; i < this.byteRange.length / 2; ++i) {
            if ((long)this.byteRange[i * 2] > pos || (long)(this.byteRange[i * 2] + this.byteRange[i * 2 + 1]) <= pos) continue;
            return true;
        }
        return false;
    }

    private void nextAvailable() throws IOException {
        while (!this.inRange()) {
            ++this.position;
            if (super.read() >= 0) continue;
            break;
        }
    }

    public byte[] toByteArray() throws IOException {
        int c;
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((c = this.read(buffer)) != -1) {
            byteOS.write(buffer, 0, c);
        }
        return byteOS.toByteArray();
    }
}

