/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.Predictor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

final class FlateFilter
extends Filter {
    private static final int BUFFER_SIZE = 16384;

    FlateFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        int predictor = -1;
        COSDictionary decodeParams = this.getDecodeParams(parameters, index);
        if (decodeParams != null) {
            predictor = decodeParams.getInt(COSName.PREDICTOR);
        }
        try {
            if (predictor > 1) {
                int colors = Math.min(decodeParams.getInt(COSName.COLORS, 1), 32);
                int bitsPerPixel = decodeParams.getInt(COSName.BITS_PER_COMPONENT, 8);
                int columns = decodeParams.getInt(COSName.COLUMNS, 1);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.decompress(encoded, baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                Predictor.decodePredictor(predictor, colors, bitsPerPixel, columns, bais, decoded);
                decoded.flush();
                baos.reset();
                bais.reset();
            } else {
                this.decompress(encoded, decoded);
            }
        }
        catch (DataFormatException e) {
            Log.e((String)"PdfBox-Android", (String)"FlateFilter: stop reading corrupt stream due to a DataFormatException");
            throw new IOException(e);
        }
        return new DecodeResult(parameters);
    }

    private void decompress(InputStream in, OutputStream out) throws IOException, DataFormatException {
        byte[] buf = new byte[2048];
        in.read(buf, 0, 2);
        int read = in.read(buf);
        if (read > 0) {
            Inflater inflater = new Inflater(true);
            inflater.setInput(buf, 0, read);
            byte[] res = new byte[1024];
            boolean dataWritten = false;
            while (true) {
                int resRead = 0;
                try {
                    resRead = inflater.inflate(res);
                }
                catch (DataFormatException exception) {
                    if (dataWritten) {
                        Log.w((String)"PdfBox-Android", (String)"FlateFilter: premature end of stream due to a DataFormatException");
                        break;
                    }
                    throw exception;
                }
                if (resRead != 0) {
                    out.write(res, 0, resRead);
                    dataWritten = true;
                    continue;
                }
                if (inflater.finished() || inflater.needsDictionary() || in.available() == 0) break;
                read = in.read(buf);
                inflater.setInput(buf, 0, read);
            }
            inflater.end();
        }
        out.flush();
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        int compressionLevel = -1;
        try {
            compressionLevel = Integer.parseInt(System.getProperty("com.tom_roush.pdfbox.filter.deflatelevel", "-1"));
        }
        catch (NumberFormatException ex) {
            Log.w((String)"PdfBox-Android", (String)ex.getMessage(), (Throwable)ex);
        }
        compressionLevel = Math.max(-1, Math.min(9, compressionLevel));
        Deflater deflater = new Deflater(compressionLevel);
        DeflaterOutputStream out = new DeflaterOutputStream(encoded, deflater);
        int mayRead = input.available();
        if (mayRead > 0) {
            int amountRead;
            byte[] buffer = new byte[Math.min(mayRead, 16384)];
            while ((amountRead = input.read(buffer, 0, Math.min(mayRead, 16384))) != -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        out.close();
        encoded.flush();
    }
}

