/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.rendering;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.util.Log;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.pdfbox.contentstream.PDFGraphicsStreamEngine;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.common.function.PDFunction;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType0;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType2;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDTrueTypeFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType0Font;
import com.tom_roush.pdfbox.pdmodel.font.PDType1CFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType1Font;
import com.tom_roush.pdfbox.pdmodel.graphics.PDLineDashPattern;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImage;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.PDShading;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDSoftMask;
import com.tom_roush.pdfbox.pdmodel.graphics.state.RenderingMode;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.AnnotationFilter;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import com.tom_roush.pdfbox.rendering.CIDType0Glyph2D;
import com.tom_roush.pdfbox.rendering.Glyph2D;
import com.tom_roush.pdfbox.rendering.PDFRenderer;
import com.tom_roush.pdfbox.rendering.PageDrawerParameters;
import com.tom_roush.pdfbox.rendering.TTFGlyph2D;
import com.tom_roush.pdfbox.rendering.Type1Glyph2D;
import com.tom_roush.pdfbox.util.Matrix;
import com.tom_roush.pdfbox.util.Vector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageDrawer
extends PDFGraphicsStreamEngine {
    private final PDFRenderer renderer;
    private final boolean subsamplingAllowed;
    private Paint paint;
    private Canvas canvas;
    private AffineTransform xform;
    private PDRectangle pageSize;
    private int pageRotation;
    private boolean flipTG = false;
    private Path.FillType clipWindingRule = null;
    private Path linePath = new Path();
    private Region lastClip;
    private List<Path> textClippings;
    private final Map<PDFont, Glyph2D> fontGlyph2D = new HashMap<PDFont, Glyph2D>();
    private PointF currentPoint = new PointF();
    private AnnotationFilter annotationFilter = new AnnotationFilter(){

        @Override
        public boolean accept(PDAnnotation annotation) {
            return true;
        }
    };

    public PageDrawer(PageDrawerParameters parameters) throws IOException {
        super(parameters.getPage());
        this.renderer = parameters.getRenderer();
        this.subsamplingAllowed = parameters.isSubsamplingAllowed();
    }

    public AnnotationFilter getAnnotationFilter() {
        return this.annotationFilter;
    }

    public void setAnnotationFilter(AnnotationFilter annotationFilter) {
        this.annotationFilter = annotationFilter;
    }

    public final PDFRenderer getRenderer() {
        return this.renderer;
    }

    protected final Canvas getCanvas() {
        return this.canvas;
    }

    protected final Path getLinePath() {
        return this.linePath;
    }

    private void setRenderingHints() {
        this.paint.setAntiAlias(true);
    }

    public void drawPage(Paint p, Canvas c, PDRectangle pageSize) throws IOException {
        this.paint = p;
        this.canvas = c;
        this.xform = new AffineTransform(this.canvas.getMatrix());
        this.pageSize = pageSize;
        this.pageRotation = this.getPage().getRotation() % 360;
        this.setRenderingHints();
        this.canvas.translate(0.0f, pageSize.getHeight());
        this.canvas.scale(1.0f, -1.0f);
        this.canvas.translate(-pageSize.getLowerLeftX(), -pageSize.getLowerLeftY());
        this.canvas.save();
        this.processPage(this.getPage());
        for (PDAnnotation annotation : this.getPage().getAnnotations(this.annotationFilter)) {
            this.showAnnotation(annotation);
        }
    }

    private float clampColor(float color) {
        return color < 0.0f ? 0.0f : (color > 1.0f ? 1.0f : color);
    }

    private int getColor(PDColor color) throws IOException {
        PDColorSpace colorSpace = color.getColorSpace();
        float[] floats = colorSpace.toRGB(color.getComponents());
        int r = Math.round(floats[0] * 255.0f);
        int g = Math.round(floats[1] * 255.0f);
        int b = Math.round(floats[2] * 255.0f);
        return Color.rgb((int)r, (int)g, (int)b);
    }

    private void setClip() {
        Region clippingPath = this.getGraphicsState().getCurrentClippingPath();
        if (clippingPath != this.lastClip) {
            this.lastClip = clippingPath;
        }
    }

    @Override
    public void beginText() throws IOException {
        this.setClip();
        this.beginTextClip();
    }

    @Override
    public void endText() throws IOException {
        this.endTextClip();
    }

    private void beginTextClip() {
        this.textClippings = new ArrayList<Path>();
    }

    private void endTextClip() {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        if (renderingMode.isClip() && !this.textClippings.isEmpty()) {
            Path path = new Path();
            for (Path shape : this.textClippings) {
                path.addPath(shape);
            }
            state.intersectClippingPath(path);
            this.textClippings = new ArrayList<Path>();
            this.lastClip = null;
        }
    }

    @Override
    protected void showFontGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        AffineTransform at = textRenderingMatrix.createAffineTransform();
        at.concatenate(font.getFontMatrix().createAffineTransform());
        Glyph2D glyph2D = this.createGlyph2D(font);
        this.drawGlyph2D(glyph2D, font, code, displacement, at);
    }

    private void drawGlyph2D(Glyph2D glyph2D, PDFont font, int code, Vector displacement, AffineTransform at) throws IOException {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        Path path = glyph2D.getPathForCharacterCode(code);
        if (path != null) {
            float fontWidth;
            if (!font.isEmbedded() && !font.isVertical() && !font.isStandard14() && font.hasExplicitWidth(code) && (fontWidth = font.getWidthFromFont(code)) > 0.0f && (double)Math.abs(fontWidth - displacement.getX() * 1000.0f) > 1.0E-4) {
                float pdfWidth = displacement.getX() * 1000.0f;
                at.scale(pdfWidth / fontWidth, 1.0);
            }
            path.transform(at.toMatrix());
            if (renderingMode.isFill()) {
                this.paint.setColor(this.getNonStrokingColor());
                this.setClip();
                this.paint.setStyle(Paint.Style.FILL);
                this.canvas.drawPath(path, this.paint);
            }
            if (renderingMode.isStroke()) {
                this.paint.setColor(this.getStrokingColor());
                this.setClip();
                this.paint.setStyle(Paint.Style.STROKE);
                this.canvas.drawPath(path, this.paint);
            }
            if (renderingMode.isClip()) {
                // empty if block
            }
        }
    }

    private Glyph2D createGlyph2D(PDFont font) throws IOException {
        Glyph2D glyph2D = this.fontGlyph2D.get(font);
        if (glyph2D != null) {
            return glyph2D;
        }
        if (font instanceof PDTrueTypeFont) {
            PDTrueTypeFont ttfFont = (PDTrueTypeFont)font;
            glyph2D = new TTFGlyph2D(ttfFont);
        } else if (font instanceof PDType1Font) {
            PDType1Font pdType1Font = (PDType1Font)font;
            glyph2D = new Type1Glyph2D(pdType1Font);
        } else if (font instanceof PDType1CFont) {
            PDType1CFont type1CFont = (PDType1CFont)font;
            glyph2D = new Type1Glyph2D(type1CFont);
        } else if (font instanceof PDType0Font) {
            PDType0Font type0Font = (PDType0Font)font;
            if (type0Font.getDescendantFont() instanceof PDCIDFontType2) {
                glyph2D = new TTFGlyph2D(type0Font);
            } else if (type0Font.getDescendantFont() instanceof PDCIDFontType0) {
                PDCIDFontType0 cidType0Font = (PDCIDFontType0)type0Font.getDescendantFont();
                glyph2D = new CIDType0Glyph2D(cidType0Font);
            }
        } else {
            throw new IllegalStateException("Bad font type: " + font.getClass().getSimpleName());
        }
        if (glyph2D != null) {
            this.fontGlyph2D.put(font, glyph2D);
        }
        if (glyph2D == null) {
            throw new UnsupportedOperationException("No font for " + font.getName());
        }
        return glyph2D;
    }

    @Override
    public void appendRectangle(PointF p0, PointF p1, PointF p2, PointF p3) {
        this.linePath.moveTo(p0.x, p0.y);
        this.linePath.lineTo(p1.x, p1.y);
        this.linePath.lineTo(p2.x, p2.y);
        this.linePath.lineTo(p3.x, p3.y);
        this.linePath.close();
    }

    private int getStrokingColor() throws IOException {
        return this.getColor(this.getGraphicsState().getStrokingColor());
    }

    private int getNonStrokingColor() throws IOException {
        return this.getColor(this.getGraphicsState().getNonStrokingColor());
    }

    private void setStroke() {
        int i;
        PDGraphicsState state = this.getGraphicsState();
        float lineWidth = this.transformWidth(state.getLineWidth());
        if ((double)lineWidth < 0.25) {
            lineWidth = 0.25f;
        }
        PDLineDashPattern dashPattern = state.getLineDashPattern();
        int phaseStart = dashPattern.getPhase();
        float[] dashArray = dashPattern.getDashArray();
        for (i = 0; i < dashArray.length; ++i) {
            float w = this.transformWidth(dashArray[i]);
            dashArray[i] = Math.max(w, 0.062f);
        }
        phaseStart = (int)this.transformWidth(phaseStart);
        if (dashArray.length == 0 || Float.isInfinite(phaseStart) || Float.isNaN(phaseStart)) {
            dashArray = null;
        } else {
            for (i = 0; i < dashArray.length; ++i) {
                if (!Float.isInfinite(dashArray[i]) && !Float.isNaN(dashArray[i])) continue;
                dashArray = null;
                break;
            }
        }
        this.paint.setStrokeWidth(lineWidth);
        this.paint.setStrokeCap(state.getLineCap());
        this.paint.setStrokeJoin(state.getLineJoin());
        if (dashArray != null) {
            this.paint.setPathEffect((PathEffect)new DashPathEffect(dashArray, (float)phaseStart));
        }
    }

    @Override
    public void strokePath() throws IOException {
        this.setStroke();
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.getStrokingColor());
        this.setClip();
        this.canvas.drawPath(this.linePath, this.paint);
        this.linePath.reset();
    }

    @Override
    public void fillPath(Path.FillType windingRule) throws IOException {
        boolean noAntiAlias;
        this.paint.setColor(this.getNonStrokingColor());
        this.setClip();
        this.linePath.setFillType(windingRule);
        RectF bounds = new RectF();
        this.linePath.computeBounds(bounds, true);
        boolean bl = noAntiAlias = this.isRectangular(this.linePath) && bounds.width() > 1.0f && bounds.height() > 1.0f;
        if (noAntiAlias) {
            this.paint.setAntiAlias(false);
        }
        this.paint.setStyle(Paint.Style.FILL);
        this.canvas.drawPath(this.linePath, this.paint);
        this.linePath.reset();
        if (noAntiAlias) {
            this.setRenderingHints();
        }
    }

    private boolean isRectangular(Path path) {
        RectF rect = new RectF();
        return path.isRect(rect);
    }

    @Override
    public void fillAndStrokePath(Path.FillType windingRule) throws IOException {
        Path path = new Path(this.linePath);
        this.fillPath(windingRule);
        this.linePath = path;
        this.strokePath();
    }

    @Override
    public void clip(Path.FillType windingRule) {
        this.clipWindingRule = windingRule;
    }

    @Override
    public void moveTo(float x, float y) {
        this.currentPoint.set(x, y);
        this.linePath.moveTo(x, y);
    }

    @Override
    public void lineTo(float x, float y) {
        this.currentPoint.set(x, y);
        this.linePath.lineTo(x, y);
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.currentPoint.set(x3, y3);
        this.linePath.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public PointF getCurrentPoint() {
        return this.currentPoint;
    }

    @Override
    public void closePath() {
        this.linePath.close();
    }

    @Override
    public void endPath() {
        this.linePath.reset();
    }

    @Override
    public void drawImage(PDImage pdImage) throws IOException {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        AffineTransform at = ctm.createAffineTransform();
        if (!pdImage.getInterpolate()) {
            boolean isScaledUp;
            boolean bl = isScaledUp = (long)pdImage.getWidth() < Math.round(at.getScaleX()) || (long)pdImage.getHeight() < Math.round(at.getScaleY());
            if (isScaledUp || pdImage.isStencil()) {
                // empty if block
            }
        }
        if (!pdImage.isStencil()) {
            if (this.subsamplingAllowed) {
                int subsampling = this.getSubsampling(pdImage, at);
                this.drawBitmap(pdImage.getImage(null, subsampling), at);
            } else {
                this.drawBitmap(pdImage.getImage(), at);
            }
        }
        if (!pdImage.getInterpolate()) {
            this.setRenderingHints();
        }
    }

    private int getSubsampling(PDImage pdImage, AffineTransform at) {
        double scale = Math.abs(at.getDeterminant() * this.xform.getDeterminant());
        int subsampling = (int)Math.floor(Math.sqrt((double)(pdImage.getWidth() * pdImage.getHeight()) / scale));
        if (subsampling > 8) {
            subsampling = 8;
        }
        if (subsampling < 1) {
            subsampling = 1;
        }
        if (subsampling > pdImage.getWidth() || subsampling > pdImage.getHeight()) {
            subsampling = Math.min(pdImage.getWidth(), pdImage.getHeight());
        }
        return subsampling;
    }

    private void drawBitmap(Bitmap image, AffineTransform at) throws IOException {
        this.setClip();
        AffineTransform imageTransform = new AffineTransform(at);
        PDSoftMask softMask = this.getGraphicsState().getSoftMask();
        if (softMask != null) {
            imageTransform.scale(1.0, -1.0);
            imageTransform.translate(0.0, -1.0);
            RectF rectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
        } else {
            COSBase transfer = this.getGraphicsState().getTransfer();
            if (transfer instanceof COSArray || transfer instanceof COSDictionary) {
                image = this.applyTransferFunction(image, transfer);
            }
            int width = image.getWidth();
            int height = image.getHeight();
            imageTransform.scale(1.0 / (double)width, -1.0 / (double)height);
            imageTransform.translate(0.0, -height);
            this.canvas.drawBitmap(image, imageTransform.toMatrix(), this.paint);
        }
    }

    private Bitmap applyTransferFunction(Bitmap image, COSBase transfer) throws IOException {
        Integer[] bMap;
        Integer[] gMap;
        Integer[] rMap;
        PDFunction bf;
        PDFunction gf;
        PDFunction rf;
        Bitmap bim = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (transfer instanceof COSArray) {
            COSArray ar = (COSArray)transfer;
            rf = PDFunction.create(ar.getObject(0));
            gf = PDFunction.create(ar.getObject(1));
            bf = PDFunction.create(ar.getObject(2));
            rMap = new Integer[256];
            gMap = new Integer[256];
            bMap = new Integer[256];
        } else {
            gf = rf = PDFunction.create(transfer);
            bf = rf;
            gMap = rMap = new Integer[256];
            bMap = rMap;
        }
        float[] input = new float[1];
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int bo;
                int go;
                int ro;
                int rgb = image.getPixel(x, y);
                int ri = rgb >> 16 & 0xFF;
                int gi = rgb >> 8 & 0xFF;
                int bi = rgb & 0xFF;
                if (rMap[ri] != null) {
                    ro = rMap[ri];
                } else {
                    input[0] = (float)(ri & 0xFF) / 255.0f;
                    ro = (int)(rf.eval(input)[0] * 255.0f);
                    rMap[ri] = ro;
                }
                if (gMap[gi] != null) {
                    go = gMap[gi];
                } else {
                    input[0] = (float)(gi & 0xFF) / 255.0f;
                    go = (int)(gf.eval(input)[0] * 255.0f);
                    gMap[gi] = go;
                }
                if (bMap[bi] != null) {
                    bo = bMap[bi];
                } else {
                    input[0] = (float)(bi & 0xFF) / 255.0f;
                    bo = (int)(bf.eval(input)[0] * 255.0f);
                    bMap[bi] = bo;
                }
                bim.setPixel(x, y, rgb & 0xFF000000 | ro << 16 | go << 8 | bo);
            }
        }
        return bim;
    }

    @Override
    public void shadingFill(COSName shadingName) throws IOException {
        PDShading shading = this.getResources().getShading(shadingName);
        if (shading == null) {
            Log.e((String)"PdfBox-Android", (String)("shading " + shadingName + " does not exist in resources dictionary"));
            return;
        }
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        PDRectangle bbox = shading.getBBox();
    }

    @Override
    public void showAnnotation(PDAnnotation annotation) throws IOException {
        this.lastClip = null;
        if (annotation.isNoView()) {
            return;
        }
        if (annotation.isHidden()) {
            return;
        }
        super.showAnnotation(annotation);
        if (annotation.getAppearance() == null) {
            if (annotation instanceof PDAnnotationLink) {
                this.drawAnnotationLinkBorder((PDAnnotationLink)annotation);
            }
            if (annotation instanceof PDAnnotationMarkup && annotation.getSubtype().equals("Ink")) {
                this.drawAnnotationInk((PDAnnotationMarkup)annotation);
            }
        }
    }

    private AnnotationBorder getAnnotationBorder(PDAnnotation annotation, PDBorderStyleDictionary borderStyle) {
        AnnotationBorder ab = new AnnotationBorder();
        COSArray border = annotation.getBorder();
        if (borderStyle == null) {
            COSBase base3;
            if (border.getObject(2) instanceof COSNumber) {
                ab.width = ((COSNumber)border.getObject(2)).floatValue();
            }
            if (border.size() > 3 && (base3 = border.getObject(3)) instanceof COSArray) {
                AnnotationBorder.access$202(ab, ((COSArray)base3).toFloatArray());
            }
        } else {
            ab.width = borderStyle.getWidth();
            if (borderStyle.getStyle().equals("D")) {
                AnnotationBorder.access$202(ab, borderStyle.getDashStyle().getDashArray());
            }
            if (borderStyle.getStyle().equals("U")) {
                ab.underline = true;
            }
        }
        ab.color = annotation.getColor();
        if (ab.color == null) {
            ab.color = new PDColor(new float[]{0.0f}, (PDColorSpace)PDDeviceGray.INSTANCE);
        }
        if (ab.dashArray != null) {
            boolean allZero = true;
            for (float f : ab.dashArray) {
                if (f == 0.0f) continue;
                allZero = false;
                break;
            }
            if (allZero) {
                AnnotationBorder.access$202(ab, null);
            }
        }
        return ab;
    }

    private void drawAnnotationLinkBorder(PDAnnotationLink link) throws IOException {
        AnnotationBorder ab = this.getAnnotationBorder(link, link.getBorderStyle());
        if (ab.width == 0.0f || ab.color.getComponents().length == 0) {
            return;
        }
        PDRectangle rectangle = link.getRectangle();
        Paint strokePaint = new Paint(this.paint);
        strokePaint.setColor(this.getColor(ab.color));
        this.setStroke(strokePaint, ab.width, Paint.Cap.BUTT, Paint.Join.MITER, 10.0f, ab.dashArray, 0.0f);
        this.canvas.restore();
        if (ab.underline) {
            this.canvas.drawLine(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getLowerLeftX() + rectangle.getWidth(), rectangle.getLowerLeftY(), strokePaint);
        } else {
            this.canvas.drawRect(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getWidth(), rectangle.getHeight(), strokePaint);
        }
    }

    private void drawAnnotationInk(PDAnnotationMarkup inkAnnotation) throws IOException {
        if (!inkAnnotation.getCOSObject().containsKey(COSName.INKLIST)) {
            return;
        }
        COSBase base = inkAnnotation.getCOSObject().getDictionaryObject(COSName.INKLIST);
        if (!(base instanceof COSArray)) {
            return;
        }
        AnnotationBorder ab = this.getAnnotationBorder(inkAnnotation, inkAnnotation.getBorderStyle());
        if (ab.width == 0.0f || ab.color.getComponents().length == 0) {
            return;
        }
        Paint strokePaint = new Paint(this.paint);
        strokePaint.setColor(this.getColor(ab.color));
        this.setStroke(strokePaint, ab.width, Paint.Cap.BUTT, Paint.Join.MITER, 10.0f, ab.dashArray, 0.0f);
        this.canvas.restore();
        COSArray pathsArray = (COSArray)base;
        for (COSBase cOSBase : pathsArray.toList()) {
            if (!(cOSBase instanceof COSArray)) continue;
            COSArray pathArray = (COSArray)cOSBase;
            int nPoints = pathArray.size() / 2;
            Path path = new Path();
            for (int i = 0; i < nPoints; ++i) {
                COSBase bx = pathArray.getObject(i * 2);
                COSBase by = pathArray.getObject(i * 2 + 1);
                if (!(bx instanceof COSNumber) || !(by instanceof COSNumber)) continue;
                float x = ((COSNumber)bx).floatValue();
                float y = ((COSNumber)by).floatValue();
                if (i == 0) {
                    path.moveTo(x, y);
                    continue;
                }
                path.lineTo(x, y);
            }
            this.canvas.drawPath(path, strokePaint);
        }
    }

    public void setStroke(Paint p, float width, Paint.Cap cap, Paint.Join join, float miterLimit, float[] dash, float dash_phase) {
        p.setStrokeWidth(width);
        p.setStrokeCap(cap);
        p.setStrokeJoin(join);
        p.setStrokeMiter(miterLimit);
        p.setPathEffect((PathEffect)new DashPathEffect(dash, dash_phase));
    }

    @Override
    public void showTransparencyGroup(PDTransparencyGroup form) throws IOException {
        PDSoftMask softMask;
        TransparencyGroup group = new TransparencyGroup(form, false, this.getGraphicsState().getCurrentTransformationMatrix(), null);
        this.setClip();
        Matrix m = new Matrix(this.xform);
        float xScale = Math.abs(m.getScalingFactorX());
        float yScale = Math.abs(m.getScalingFactorY());
        if (this.flipTG) {
            // empty if block
        }
        if ((softMask = this.getGraphicsState().getSoftMask()) != null) {
            // empty if block
        }
    }

    private final class TransparencyGroup {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TransparencyGroup(PDTransparencyGroup form, boolean isSoftMask, Matrix ctm, PDColor backdropColor) throws IOException {
            Matrix transform = Matrix.concatenate(ctm, form.getMatrix());
            Path transformedBox = form.getBBox().transform(transform);
            Matrix m = new Matrix(PageDrawer.this.xform);
            AffineTransform dpiTransform = AffineTransform.getScaleInstance(Math.abs(m.getScalingFactorX()), Math.abs(m.getScalingFactorY()));
            if (this.isGray(form.getGroup().getColorSpace())) {
                // empty if block
            }
            if (!isSoftMask || backdropColor != null) {
                // empty if block
            }
            boolean oldFlipTG = PageDrawer.this.flipTG;
            PageDrawer.this.flipTG = false;
            AffineTransform xformOriginal = PageDrawer.this.xform;
            PageDrawer.this.xform = AffineTransform.getScaleInstance(m.getScalingFactorX(), m.getScalingFactorY());
            PDRectangle pageSizeOriginal = PageDrawer.this.pageSize;
            int pageRotationOriginal = PageDrawer.this.pageRotation;
            PageDrawer.this.pageRotation = 0;
            Path.FillType clipWindingRuleOriginal = PageDrawer.this.clipWindingRule;
            PageDrawer.this.clipWindingRule = null;
            Path linePathOriginal = PageDrawer.this.linePath;
            PageDrawer.this.linePath = new Path();
            PageDrawer.this.setRenderingHints();
            try {
                if (isSoftMask) {
                    PageDrawer.this.processSoftMask(form);
                } else {
                    PageDrawer.this.processTransparencyGroup(form);
                }
            }
            finally {
                PageDrawer.this.flipTG = oldFlipTG;
                PageDrawer.this.clipWindingRule = clipWindingRuleOriginal;
                PageDrawer.this.linePath = linePathOriginal;
                PageDrawer.this.pageSize = pageSizeOriginal;
                PageDrawer.this.xform = xformOriginal;
                PageDrawer.this.pageRotation = pageRotationOriginal;
            }
        }

        private boolean isGray(PDColorSpace colorSpace) {
            return colorSpace instanceof PDDeviceGray;
        }
    }

    private static class AnnotationBorder {
        private float[] dashArray = null;
        private boolean underline = false;
        private float width = 0.0f;
        private PDColor color;

        private AnnotationBorder() {
        }

        static /* synthetic */ float[] access$202(AnnotationBorder x0, float[] x1) {
            x0.dashArray = x1;
            return x1;
        }
    }
}

