/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j;

import com.toomasr.sgf4j.parser.Game;
import com.toomasr.sgf4j.parser.GameNode;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    private final String originalGame;
    private static final Set<String> generalProps = new HashSet<String>();
    private static final Set<String> nodeProps;
    private Stack<GameNode> treeStack = new Stack();

    public Parser(String game) {
        this.originalGame = game;
    }

    public Game parse() {
        Game game = new Game(this.originalGame);
        GameNode parentNode = null;
        int moveNo = 1;
        int id = 10000;
        for (int i = 0; i < this.originalGame.length(); ++i) {
            char chr = this.originalGame.charAt(i);
            if (';' == chr && (i == 0 || this.originalGame.charAt(i - 1) != '\\')) {
                GameNode node;
                String nodeContents = this.consumeUntil(this.originalGame, i);
                i += nodeContents.length();
                if ((node = this.parseToken(nodeContents, parentNode, game, id++)).isMove()) {
                    node.setMoveNo(moveNo++);
                }
                if (parentNode == null) {
                    parentNode = node;
                    game.setRootNode(parentNode);
                    continue;
                }
                if (node.isEmpty()) continue;
                parentNode.addChild(node);
                parentNode = node;
                continue;
            }
            if ('(' == chr && parentNode != null) {
                this.treeStack.push(parentNode);
                continue;
            }
            if (')' != chr || this.treeStack.size() <= 0) continue;
            parentNode = this.treeStack.pop();
            moveNo = parentNode.getMoveNo() + 1;
        }
        return game;
    }

    private String consumeUntil(String gameStr, int i) {
        StringBuffer rtrn = new StringBuffer();
        boolean insideComment = false;
        boolean insideValue = false;
        for (int j = i + 1; j < gameStr.length(); ++j) {
            char chr = gameStr.charAt(j);
            if (insideComment) {
                if (']' == chr && gameStr.charAt(j - 1) != '\\') {
                    insideComment = false;
                }
                rtrn.append(chr);
                continue;
            }
            if ('C' == chr && '[' == gameStr.charAt(j + 1)) {
                insideComment = true;
                rtrn.append(chr);
                continue;
            }
            if ('[' == chr) {
                insideValue = true;
                rtrn.append(chr);
                continue;
            }
            if (']' == chr) {
                insideValue = false;
                rtrn.append(chr);
                continue;
            }
            if (insideValue) {
                rtrn.append(chr);
                continue;
            }
            if ('\n' == chr || '\r' == chr) continue;
            if (';' == chr || ')' == chr || '(' == chr) break;
            rtrn.append(chr);
        }
        return rtrn.toString().trim();
    }

    private GameNode parseToken(String token, GameNode parentNode, Game game, int id) {
        GameNode rtrnNode = new GameNode(parentNode);
        rtrnNode.setId(id);
        token = Parser.prepareToken("'" + token + "'");
        Pattern p = Pattern.compile("([a-zA-Z]{1,})((\\[[^\\]]*\\]){1,})");
        Matcher m = p.matcher(token);
        while (m.find()) {
            String group = m.group();
            if (group.length() == 0) continue;
            String key = m.group(1);
            String value = m.group(2);
            if (value.startsWith("[")) {
                value = value.substring(1, value.length() - 1);
            }
            value = Parser.normaliseToken(value);
            if ("AB".equals(key) || "AW".equals(key)) {
                CharSequence[] list = value.split("\\]\\[");
                if (parentNode == null) {
                    game.addProperty(key, String.join((CharSequence)",", list));
                    continue;
                }
                rtrnNode.addProperty(key, String.join((CharSequence)",", list));
                continue;
            }
            if ("C".equals(key) || "N".equals(key)) {
                if (parentNode == null) {
                    game.addProperty(key, value);
                    continue;
                }
                rtrnNode.addProperty(key, value);
                continue;
            }
            if (generalProps.contains(key) || nodeProps.contains(key)) {
                boolean addedToGame = false;
                if (generalProps.contains(key) && parentNode == null) {
                    game.addProperty(key, this.cleanValue(value));
                    addedToGame = true;
                }
                if (!nodeProps.contains(key) || addedToGame) continue;
                rtrnNode.addProperty(key, this.cleanValue(value));
                continue;
            }
            log.info("Not able to parse property '" + m.group(1) + "'=" + m.group(2) + ". Found it from " + m.group(0));
        }
        return rtrnNode;
    }

    private String cleanValue(String value) {
        String cleaned = value.replaceAll("\\\\;", ";");
        return cleaned;
    }

    private static String prepareToken(String token) {
        token = token.replaceAll("\\\\\\[", "@@@@@");
        token = token.replaceAll("\\\\\\]", "#####");
        return token;
    }

    public static String normaliseToken(String token) {
        token = token.replaceAll("@@@@@", "\\\\\\[");
        token = token.replaceAll("#####", "\\\\\\]");
        return token;
    }

    static {
        generalProps.add("AP");
        generalProps.add("BR");
        generalProps.add("WR");
        generalProps.add("KM");
        generalProps.add("GKM");
        generalProps.add("PBX");
        generalProps.add("PB");
        generalProps.add("PW");
        generalProps.add("PX");
        generalProps.add("PY");
        generalProps.add("CA");
        generalProps.add("FF");
        generalProps.add("GM");
        generalProps.add("SZ");
        generalProps.add("AN");
        generalProps.add("EV");
        generalProps.add("EVX");
        generalProps.add("RO");
        generalProps.add("RU");
        generalProps.add("TM");
        generalProps.add("OT");
        generalProps.add("DT");
        generalProps.add("DTX");
        generalProps.add("PC");
        generalProps.add("RE");
        generalProps.add("ER");
        generalProps.add("ST");
        generalProps.add("GC");
        generalProps.add("CP");
        generalProps.add("SO");
        generalProps.add("WT");
        generalProps.add("BT");
        generalProps.add("US");
        generalProps.add("PM");
        generalProps.add("FG");
        generalProps.add("GN");
        generalProps.add("TB");
        generalProps.add("TW");
        generalProps.add("MN");
        generalProps.add("HA");
        generalProps.add("AB");
        generalProps.add("AW");
        generalProps.add("AE");
        generalProps.add("PL");
        generalProps.add("KGSDE");
        generalProps.add("KGSSW");
        generalProps.add("KGSSB");
        generalProps.add("CH");
        generalProps.add("WC");
        generalProps.add("LT");
        generalProps.add("BC");
        generalProps.add("ID");
        generalProps.add("OH");
        generalProps.add("LC");
        generalProps.add("RD");
        generalProps.add("TL");
        generalProps.add("GK");
        generalProps.add("WL");
        generalProps.add("BL");
        generalProps.add("MULTIGOGM");
        generalProps.add("MULTIGOBM");
        generalProps.add("HO");
        generalProps.add("GOGGPFF");
        generalProps.add("GOGGPAP");
        generalProps.add("L");
        generalProps.add("B");
        generalProps.add("BS");
        generalProps.add("WS");
        generalProps.add("MU");
        generalProps.add("LZ");
        nodeProps = new HashSet<String>();
        nodeProps.add("B");
        nodeProps.add("W");
        nodeProps.add("CR");
        nodeProps.add("MA");
        nodeProps.add("SQ");
        nodeProps.add("SL");
        nodeProps.add("LB");
        nodeProps.add("TR");
        nodeProps.add("OW");
        nodeProps.add("OB");
        nodeProps.add("WL");
        nodeProps.add("BL");
        nodeProps.add("C");
        nodeProps.add("N");
        nodeProps.add("L");
        nodeProps.add("WV");
        nodeProps.add("VW");
        nodeProps.add("TE");
    }
}

