/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j;

import com.toomasr.sgf4j.Parser;
import com.toomasr.sgf4j.parser.Game;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Sgf {
    private Parser parser;
    private Game game;

    private Sgf(String sgf) {
        this.parser = new Parser(sgf);
        this.game = this.parser.parse();
        this.game.postProcess();
    }

    public static Game createFromPath(Path path, String charSet) {
        try {
            String gameAsString = new String(Files.readAllBytes(path), charSet);
            return Sgf.createFromString(gameAsString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Game createFromPath(Path path) {
        try {
            String gameAsString = new String(Files.readAllBytes(path), "UTF-8");
            return Sgf.createFromString(gameAsString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Game createFromString(String gameAsString) {
        Sgf rtrn = new Sgf(gameAsString);
        return rtrn.getGame();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Game createFromInputStream(InputStream in) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8").newDecoder()));){
            String line;
            StringBuilder out = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
            Sgf rtrn = new Sgf(out.toString());
            Game game = rtrn.getGame();
            return game;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToFile(Game game, Path destination) {
        Sgf.writeToFile(game, destination, "UTF-8");
    }

    public static void writeToFile(Game game, Path destination, String encoding, boolean keepOriginal) {
        if (keepOriginal) {
            Path copyOfOriginal = Paths.get(destination.toString() + ".orig." + System.currentTimeMillis(), new String[0]);
            try {
                Files.copy(destination, copyOfOriginal, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Sgf.writeToFile(game, destination, encoding);
    }

    public static void writeToFile(Game game, Path destination, String encoding) {
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(destination.toFile()), Charset.forName(encoding).newEncoder());){
            osw.write(game.getGeneratedSgf());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File writeToFile(String sgf) {
        FilterOutputStream bos = null;
        try {
            File tmpFile = File.createTempFile("sgf4j-test-", ".sgf");
            bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
            bos.write(sgf.getBytes());
            File file = tmpFile;
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Game getGame() {
        return this.game;
    }
}

