/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j.board;

import com.toomasr.sgf4j.board.StoneState;

public class Square {
    private StoneState color;
    public int x;
    public int y;

    public Square(StoneState color, int x, int y) {
        this.color = color;
        this.x = x;
        this.y = y;
    }

    public Square(char colorChar, int x, int y) {
        if ('-' == colorChar) {
            this.color = StoneState.EMPTY;
        } else if ('o' == colorChar) {
            this.color = StoneState.WHITE;
        } else if ('x' == colorChar) {
            this.color = StoneState.BLACK;
        }
        this.x = x;
        this.y = y;
    }

    public Square(int x, int y) {
        this(StoneState.EMPTY, x, y);
    }

    public String toString() {
        if (this.color.equals((Object)StoneState.WHITE)) {
            return "o";
        }
        if (this.color.equals((Object)StoneState.BLACK)) {
            return "x";
        }
        return "-";
    }

    public boolean isEmpty() {
        return this.color.equals((Object)StoneState.EMPTY);
    }

    public boolean isOfColor(StoneState theColor) {
        return this.color.equals((Object)theColor);
    }

    public StoneState getColor() {
        return this.color;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Square other = (Square)obj;
        if (this.color != other.color) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }
}

