/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j.board;

import com.toomasr.sgf4j.board.BoardListener;
import com.toomasr.sgf4j.board.Group;
import com.toomasr.sgf4j.board.Square;
import com.toomasr.sgf4j.board.StoneState;
import com.toomasr.sgf4j.parser.GameNode;
import com.toomasr.sgf4j.parser.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VirtualBoard {
    private int size = 19;
    private Square[][] vBoard = new Square[this.size][this.size];
    private List<BoardListener> boardListeners = new ArrayList<BoardListener>();
    private Map<GameNode, Set<Group>> moveToRemovedGroups = new HashMap<GameNode, Set<Group>>();

    public VirtualBoard() {
        this.initEmptyBoard();
    }

    private void initEmptyBoard() {
        for (int i = 0; i < this.vBoard.length; ++i) {
            for (int j = 0; j < this.vBoard.length; ++j) {
                this.vBoard[i][j] = new Square(StoneState.EMPTY, i, j);
            }
        }
    }

    public void makeMove(GameNode move, GameNode prevMove) {
        if (move.getMoveString() != null && !move.isPass() && !move.isPlacementMove()) {
            int x = move.getCoords()[0];
            int y = move.getCoords()[1];
            this.vBoard[x][y] = new Square(move.getColorAsEnum(), x, y);
            Set<Group> removedGroups = this.removeDeadGroupsForOppColor(move.getColorAsEnum());
            this.moveToRemovedGroups.put(move, removedGroups);
            this.placeStone(move);
        }
        this.playMove(move, prevMove);
    }

    public void undoMove(GameNode moveNode, GameNode prevMove) {
        Set<Group> removedGroups;
        if (!moveNode.isPass() && !moveNode.isPlacementMove()) {
            String currMoveStr = moveNode.getMoveString();
            int[] moveCoords = Util.alphaToCoords(currMoveStr);
            this.removeStone(moveCoords[0], moveCoords[1]);
        }
        if ((removedGroups = this.moveToRemovedGroups.get(moveNode)) != null) {
            for (Group group : removedGroups) {
                for (Square square : group.stones) {
                    this.placeStone(square);
                }
            }
        }
        for (BoardListener boardListener : this.boardListeners) {
            boardListener.undoMove(moveNode, prevMove);
        }
    }

    public void placeStone(StoneState color, int x, int y) {
        this.vBoard[x][y] = new Square(color, x, y);
        for (BoardListener boardListener : this.boardListeners) {
            boardListener.placeStone(x, y, color);
        }
    }

    public void playMove(GameNode move, GameNode prevMove) {
        for (BoardListener boardListener : this.boardListeners) {
            boardListener.playMove(move, prevMove);
        }
    }

    public void placeStone(Square sq) {
        this.placeStone(sq.getColor(), sq.x, sq.y);
    }

    public void placeStone(GameNode gameNode) {
        this.placeStone(gameNode.getColorAsEnum(), gameNode.getCoords()[0], gameNode.getCoords()[1]);
    }

    public void placeWhiteStone(int i, int j) {
        this.placeStone(new Square(StoneState.WHITE, i, j));
    }

    public void placeBlackStone(int i, int j) {
        this.placeStone(new Square(StoneState.BLACK, i, j));
    }

    public Set<Group> removeDeadGroupsForOppColor(StoneState color) {
        return this.removeDeadGroups(this.oppColor(color));
    }

    public Set<Group> removeDeadGroups(StoneState color) {
        Set<Group> groups = this.findDistinctGroups(color);
        HashSet<Group> rtrn = new HashSet<Group>();
        for (Group group : groups) {
            if (!group.isDead(this.vBoard)) continue;
            this.removeStones(group);
            rtrn.add(group);
        }
        return rtrn;
    }

    public void removeStone(int x, int y) {
        this.vBoard[x][y] = new Square(x, y);
        for (BoardListener boardListener : this.boardListeners) {
            boardListener.removeStone(x, y);
        }
    }

    public void removeStones(Group group) {
        for (Square square : group.stones) {
            this.removeStone(square.x, square.y);
        }
    }

    protected Set<Group> findDistinctGroups(StoneState color) {
        HashSet<Square> alreadyChecked = new HashSet<Square>();
        HashSet<Group> groups = new HashSet<Group>();
        Group activeGroup = new Group();
        for (int i = 0; i < this.vBoard.length; ++i) {
            for (int j = 0; j < this.vBoard[i].length; ++j) {
                if (!this.vBoard[i][j].isOfColor(color) || alreadyChecked.contains(this.vBoard[i][j])) continue;
                this.populateGroup(i, j, color, activeGroup);
                alreadyChecked.addAll(activeGroup.stones);
                groups.add(activeGroup);
                activeGroup = new Group();
            }
        }
        return groups;
    }

    private void populateGroup(int i, int j, StoneState color, Group activeGroup) {
        if (this.vBoard[i][j].isOfColor(color) && !activeGroup.contains(this.vBoard[i][j])) {
            activeGroup.addStone(this.vBoard[i][j]);
            if (i - 1 > -1) {
                this.populateGroup(i - 1, j, color, activeGroup);
            }
            if (i + 1 < 19) {
                this.populateGroup(i + 1, j, color, activeGroup);
            }
            if (j - 1 > -1) {
                this.populateGroup(i, j - 1, color, activeGroup);
            }
            if (j + 1 < 19) {
                this.populateGroup(i, j + 1, color, activeGroup);
            }
        } else {
            return;
        }
    }

    public StoneState oppColor(StoneState color) {
        if (color.equals((Object)StoneState.EMPTY)) {
            throw new RuntimeException("Wrong argument for oppColor");
        }
        if (color.equals((Object)StoneState.WHITE)) {
            return StoneState.BLACK;
        }
        return StoneState.WHITE;
    }

    public void printBoard() {
        for (int i = 0; i < this.vBoard.length; ++i) {
            for (int j = 0; j < this.vBoard[i].length; ++j) {
                System.out.print(this.vBoard[i][j]);
            }
            System.out.println();
        }
    }

    public Square getCoord(int x, int y) {
        return this.vBoard[x][y];
    }

    public static VirtualBoard setUpFromStringBoard(String board) {
        VirtualBoard rtrn = new VirtualBoard();
        String[] lines = board.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            for (int j = 0; j < lines[i].length(); ++j) {
                Square sq = new Square(lines[i].charAt(j), i, j);
                rtrn.placeStone(sq);
            }
        }
        return rtrn;
    }

    public void fastForwardTo(GameNode fwdTo) {
        ArrayList<GameNode> movesToPlay = new ArrayList<GameNode>();
        GameNode node = fwdTo;
        do {
            movesToPlay.add(node);
        } while ((node = node.getParentNode()) != null);
        this.initEmptyBoard();
        for (BoardListener boardListener : this.boardListeners) {
            boardListener.initInitialPosition();
        }
        GameNode prevMove = null;
        for (int i = movesToPlay.size() - 1; i > -1; --i) {
            node = (GameNode)movesToPlay.get(i);
            this.makeMove(node, prevMove);
            prevMove = node;
        }
    }

    public Square[][] getBoard() {
        return this.vBoard;
    }

    public void addBoardListener(BoardListener listener) {
        this.boardListeners.add(listener);
    }
}

