/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j.parser;

import com.toomasr.sgf4j.Sgf;
import com.toomasr.sgf4j.parser.GameNode;
import com.toomasr.sgf4j.parser.MoveTimingInfo;
import com.toomasr.sgf4j.parser.VisualDepthHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Game {
    private static final Logger log = LoggerFactory.getLogger(Game.class);
    private Map<String, String> properties = new HashMap<String, String>();
    private GameNode rootNode;
    private int noMoves = 0;
    private int noNodes = 0;
    private String originalSgf = null;
    private MoveTimingInfo wTimings = new MoveTimingInfo(0, 0, 0, 0);
    private MoveTimingInfo bTimings = new MoveTimingInfo(0, 0, 0, 0);
    private boolean timingInfoFound = false;

    public Game() {
    }

    public Game(String originalSgf) {
        this.originalSgf = originalSgf;
    }

    public void addProperty(String key, String value) {
        if (this.properties.get(key) != null) {
            String current = this.properties.get(key);
            this.properties.put(key, current + "," + value);
        } else {
            this.properties.put(key, value);
        }
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.properties.get(key) == null) {
            return defaultValue;
        }
        return this.properties.get(key);
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public String toString() {
        return this.properties.toString();
    }

    public void setRootNode(GameNode rootNode) {
        this.rootNode = rootNode;
    }

    public GameNode getRootNode() {
        return this.rootNode;
    }

    public int getNoMoves() {
        return this.noMoves;
    }

    public void setNoMoves(int noMoves) {
        this.noMoves = noMoves;
    }

    public void calculateTimingMetrics() {
        GameNode node = this.getRootNode();
        double prevBL = -1.0;
        int prevBlTime = 0;
        double prevWL = -1.0;
        int prevWlTime = 0;
        ArrayList<Integer> blackTimings = new ArrayList<Integer>();
        ArrayList<Integer> whiteTimings = new ArrayList<Integer>();
        node = this.getRootNode();
        do {
            double curDouble2;
            String bl = node.getProperty("BL");
            String wl = node.getProperty("WL");
            if (bl != null) {
                try {
                    curDouble2 = Double.parseDouble(bl);
                    if (prevBL != -1.0) {
                        prevBlTime = (int)Math.round(prevBL - curDouble2);
                    }
                    if (prevBlTime < 0) {
                        prevBlTime = (int)Math.round(prevBL);
                    }
                    prevBL = curDouble2;
                    node.addProperty("TimeSpentOnMove", prevBlTime + "");
                    blackTimings.add(prevBlTime);
                }
                catch (NumberFormatException curDouble2) {
                    // empty catch block
                }
            }
            if (wl == null) continue;
            try {
                curDouble2 = Double.parseDouble(wl);
                if (prevWL != -1.0) {
                    prevWlTime = (int)Math.round(prevWL - curDouble2);
                }
                if (prevWlTime < 0) {
                    prevWlTime = (int)Math.round(prevWL);
                }
                prevWL = curDouble2;
                node.addProperty("TimeSpentOnMove", prevWlTime + "");
                whiteTimings.add(prevWlTime);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        } while ((node = node.getNextNode()) != null);
        if (whiteTimings.size() > 0 || blackTimings.size() > 0) {
            this.wTimings = this.calculateTimings(whiteTimings);
            this.bTimings = this.calculateTimings(blackTimings);
        }
    }

    private MoveTimingInfo calculateTimings(List<Integer> timings) {
        int max = 0;
        int min = Integer.MAX_VALUE;
        long sum = 0L;
        for (int timing : timings) {
            if (timing > max) {
                max = timing;
            }
            if (timing < min) {
                min = timing;
            }
            sum += (long)timing;
        }
        Collections.sort(timings);
        int median = timings.get(timings.size() / 2);
        if (timings.size() % 2 == 0) {
            median = (timings.size() / 2 + (timings.size() / 2 - 1)) / 2;
        }
        MoveTimingInfo rtrn = new MoveTimingInfo(min, max, (int)sum / timings.size(), median);
        return rtrn;
    }

    public void postProcess() {
        if (this.getRootNode().isMove()) {
            GameNode oldRoot = this.getRootNode();
            GameNode newRoot = new GameNode(null);
            newRoot.addChild(oldRoot);
            this.setRootNode(newRoot);
        }
        GameNode node = this.getRootNode();
        node = this.getRootNode();
        do {
            if (node.isMove()) {
                ++this.noMoves;
            }
            ++this.noNodes;
            if (node.getProperty("BL") == null && node.getProperty("WL") == null) continue;
            this.timingInfoFound = true;
        } while ((node = node.getNextNode()) != null);
        this.numberTheMoves(this.getRootNode(), 1, 0);
        VisualDepthHelper helper = new VisualDepthHelper();
        helper.calculateVisualDepth(this.getLastMove(), 1);
        if (this.timingInfoFound) {
            this.calculateTimingMetrics();
        }
    }

    private void heuristicalBranchReorder(GameNode node) {
        do {
            GameNode tmpNode = node.getNextNode();
            Set<GameNode> children = node.getChildren();
            if (!node.isMove() || tmpNode == null) continue;
            GameNode newMainLine = null;
            for (GameNode gameNode : children) {
                if (!gameNode.getSgfComment().toLowerCase().contains("answer")) continue;
                newMainLine = gameNode;
            }
            if (newMainLine == null) continue;
            children.remove(newMainLine);
            children.add(node.getNextNode());
            node.getNextNode().setPrevNode(null);
            node.setNextNode(newMainLine);
            newMainLine.setPrevNode(node);
        } while ((node = node.getNextNode()) != null);
    }

    private void numberTheMoves(GameNode startNode, int moveNo, int nodeNo) {
        GameNode node = startNode;
        int nextMoveNo = moveNo;
        int nextNodeNo = nodeNo;
        if (node.isMove()) {
            startNode.setMoveNo(moveNo);
            ++nextMoveNo;
        }
        startNode.setNodeNo(nodeNo);
        ++nextNodeNo;
        if (node.getNextNode() != null) {
            this.numberTheMoves(node.getNextNode(), nextMoveNo, nextNodeNo);
        }
        if (node.hasChildren()) {
            for (GameNode childNode : node.getChildren()) {
                this.numberTheMoves(childNode, nextMoveNo, nextNodeNo);
            }
        }
    }

    public int getNoNodes() {
        return this.noNodes;
    }

    public GameNode getFirstMove() {
        GameNode node = this.getRootNode();
        do {
            if (!node.isMove()) continue;
            return node;
        } while ((node = node.getNextNode()) != null);
        return null;
    }

    public GameNode getLastMove() {
        GameNode node = this.getRootNode();
        GameNode rtrn = null;
        do {
            if (!node.isMove()) continue;
            rtrn = node;
        } while ((node = node.getNextNode()) != null);
        return rtrn;
    }

    public void saveToFile(Path path) {
        Sgf.writeToFile(this, path);
    }

    public boolean isSameGame(Game otherGame) {
        return this.isSameGame(otherGame, false);
    }

    public boolean isSameGame(Game otherGame, boolean verbose) {
        if (this.equals(otherGame)) {
            if (verbose) {
                System.out.println("The very same game object - returning true");
            }
            return true;
        }
        Map<String, String> reReadProps = otherGame.getProperties();
        if (this.properties.size() != reReadProps.size()) {
            log.trace("Properties mismatch {} {}", (Object)this.properties.size(), (Object)otherGame.getProperties().size());
            if (verbose) {
                System.out.printf("Properties mismatch %s %s\n", this.properties.size(), otherGame.getProperties().size());
            }
            return false;
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (entry.getValue().equals(reReadProps.get(entry.getKey()))) continue;
            log.trace("Property mismatch {}={} {}", new Object[]{entry.getKey(), entry.getValue(), reReadProps.get(entry.getKey())});
            if (verbose) {
                System.out.printf("Property mismatch %s='%s' '%s'", entry.getKey(), entry.getValue(), reReadProps.get(entry.getKey()));
            }
            return false;
        }
        if (this.getNoNodes() != otherGame.getNoNodes()) {
            log.trace("Games have different no of nodes {} {}", (Object)this.getNoNodes(), (Object)otherGame.getNoNodes());
            if (verbose) {
                System.out.printf("Games have different no of nodes old=%s new=%s", this.getNoNodes(), otherGame.getNoNodes());
            }
            return false;
        }
        if (this.getNoMoves() != otherGame.getNoMoves()) {
            log.trace("Games have different no of moves {} {}", (Object)this.getNoMoves(), (Object)otherGame.getNoMoves());
            if (verbose) {
                System.out.println("Games have different number of moves " + this.getNoMoves() + " " + otherGame.getNoMoves());
            }
            return false;
        }
        if (verbose) {
            System.out.println("Games have same number of moves " + this.getNoMoves());
        }
        if (!this.doAllNodesEqual(this, this.getRootNode(), otherGame, otherGame.getRootNode(), verbose)) {
            if (verbose) {
                System.out.println("Some nodes don't equal");
            }
            return false;
        }
        return true;
    }

    private boolean doAllNodesEqual(Game game, GameNode node, Game otherGame, GameNode otherNode, boolean verbose) {
        if (!node.isSameNode(otherNode)) {
            if (verbose) {
                System.out.println("Nodes don't equal a=" + node + "\nb=" + otherGame);
            }
            return false;
        }
        GameNode nextNode = node.getNextNode();
        GameNode nextOtherNode = otherNode.getNextNode();
        if (nextNode != null) {
            if (!nextNode.isSameNode(nextOtherNode)) {
                if (verbose) {
                    System.out.println("Nodes don't equal");
                    System.out.println(nextNode);
                    System.out.println(nextOtherNode);
                    System.out.println();
                }
                return false;
            }
            if (!this.doAllNodesEqual(game, nextNode, otherGame, nextOtherNode, verbose)) {
                return false;
            }
        } else if (nextNode == null && nextOtherNode != null) {
            if (verbose) {
                System.out.println("Nodes don't equal node=" + nextNode + " otherNode=" + nextOtherNode);
            }
            return false;
        }
        Set<GameNode> children = node.getChildren();
        Set<GameNode> otherChildren = otherNode.getChildren();
        if (children.size() != otherChildren.size()) {
            if (verbose) {
                System.out.println("Size of children don't equal node=" + children + " otherNode=" + otherChildren);
            }
            return false;
        }
        for (GameNode gameNode : children) {
            boolean found = false;
            for (GameNode gameNode2 : otherChildren) {
                if (!gameNode.isSameNode(gameNode2)) continue;
                found = true;
            }
            if (found) continue;
            if (verbose) {
                System.out.println("Children don't equal node=" + children + " otherNode=" + otherChildren);
            }
            return false;
        }
        Iterator<GameNode> ite = children.iterator();
        Iterator<GameNode> otherIte = otherChildren.iterator();
        while (ite.hasNext()) {
            GameNode otherChildNode;
            GameNode childNode = ite.next();
            if (this.doAllNodesEqual(game, childNode, otherGame, otherChildNode = otherIte.next(), verbose)) continue;
            return false;
        }
        return true;
    }

    public String getOriginalSgf() {
        return this.originalSgf;
    }

    public void setOriginalSgf(String originalSgf) {
        this.originalSgf = originalSgf;
    }

    public String getGeneratedSgf() {
        StringBuilder rtrn = new StringBuilder();
        rtrn.append("(");
        Map<String, String> props = this.getProperties();
        if (props.size() > 0) {
            rtrn.append(";");
        }
        for (Map.Entry<String, String> entry : props.entrySet()) {
            rtrn.append(entry.getKey() + "[" + entry.getValue() + "]");
        }
        this.populateSgf(this.getRootNode(), rtrn);
        rtrn.append(")");
        return rtrn.toString();
    }

    private void populateSgf(GameNode node, StringBuilder sgfString) {
        sgfString.append(";");
        for (Map.Entry<String, String> entry : node.getProperties().entrySet()) {
            sgfString.append(entry.getKey() + "[" + entry.getValue() + "]");
        }
        sgfString.append("\n");
        if (node.hasChildren()) {
            sgfString.append("(");
            this.populateSgf(node.getNextNode(), sgfString);
            sgfString.append(")");
            sgfString.append("\n");
            for (GameNode childNode : node.getChildren()) {
                sgfString.append("(");
                this.populateSgf(childNode, sgfString);
                sgfString.append(")");
                sgfString.append("\n");
            }
        } else if (node.getNextNode() != null) {
            this.populateSgf(node.getNextNode(), sgfString);
        }
    }

    public boolean getTimingInfoFound() {
        return this.timingInfoFound;
    }

    public MoveTimingInfo getWTimings() {
        return this.wTimings;
    }

    public MoveTimingInfo getBTimings() {
        return this.bTimings;
    }
}

