/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j.parser;

import com.toomasr.sgf4j.board.StoneState;
import com.toomasr.sgf4j.parser.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GameNode
implements Comparable<GameNode>,
Cloneable {
    private final Set<GameNode> children = new TreeSet<GameNode>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, String> updatedProperties = new HashMap<String, String>();
    private int moveNo = -1;
    private int nodeNo = -1;
    private int visualDepth = -1;
    private GameNode parentNode;
    private GameNode nextNode = null;
    private GameNode prevNode = null;
    private int id;

    public GameNode(GameNode parentNode) {
        this.parentNode = parentNode;
    }

    public void addChild(GameNode node) {
        if (this.nextNode == null) {
            this.nextNode = node;
            this.nextNode.setVisualDepth(0);
            node.setPrevNode(this);
            return;
        }
        if (this.children.contains(node)) {
            throw new RuntimeException("Node '" + node + "' already exists for " + this);
        }
        this.children.add(node);
    }

    public void setNextNode(GameNode nextNode) {
        this.nextNode = nextNode;
    }

    public GameNode getNextNode() {
        return this.nextNode;
    }

    public void setPrevNode(GameNode node) {
        this.prevNode = node;
    }

    public GameNode getPrevNode() {
        return this.prevNode;
    }

    public GameNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(GameNode node) {
        this.parentNode = node;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getUpdatedProperty(String key) {
        return this.updatedProperties.get(key);
    }

    public void addUpdatedProperty(String key, String value) {
        this.updatedProperties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.properties.get(key) == null) {
            return defaultValue;
        }
        return this.properties.get(key);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isMove() {
        return this.properties.get("W") != null || this.properties.get("B") != null;
    }

    public String getMoveString() {
        if (this.properties.get("W") != null) {
            return this.properties.get("W");
        }
        if (this.properties.get("B") != null) {
            return this.properties.get("B");
        }
        return null;
    }

    public int[] getCoords() {
        String moveStr = this.getMoveString();
        int[] moveCoords = Util.alphaToCoords(moveStr);
        return moveCoords;
    }

    public boolean isWhite() {
        return this.properties.get("W") != null;
    }

    public boolean isBlack() {
        return this.properties.get("B") != null;
    }

    public String getColor() {
        if (this.properties.get("W") != null) {
            return "W";
        }
        return "B";
    }

    public StoneState getColorAsEnum() {
        if (this.properties.get("W") != null) {
            return StoneState.WHITE;
        }
        return StoneState.BLACK;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Set<GameNode> getChildren() {
        return this.children;
    }

    public void setMoveNo(int i) {
        this.moveNo = i;
    }

    public int getMoveNo() {
        return this.moveNo;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty() && this.children.size() == 0;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isSameNode(GameNode otherNode) {
        if (this == otherNode) {
            return true;
        }
        if (otherNode == null) {
            return false;
        }
        if (this.getClass() != otherNode.getClass()) {
            return false;
        }
        GameNode other = otherNode;
        if (this.children == null) {
            if (other.children != null) {
                return false;
            }
        } else {
            for (GameNode gameNode : this.children) {
                boolean found = false;
                for (GameNode gameNode2 : this.children) {
                    if (!gameNode.isSameNode(gameNode2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        if (this.moveNo != other.moveNo) {
            return false;
        }
        if (this.parentNode == null ? other.parentNode != null : !this.parentNode.isSameNode(other.parentNode)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.visualDepth == other.visualDepth;
    }

    @Override
    public int compareTo(GameNode o) {
        if (this.visualDepth < o.visualDepth) {
            return -1;
        }
        if (this.visualDepth > o.visualDepth) {
            return 1;
        }
        if (this.moveNo < o.moveNo) {
            return -1;
        }
        if (this.moveNo > o.moveNo) {
            return 1;
        }
        if (this.hashCode() < o.hashCode()) {
            return -1;
        }
        if (this.hashCode() > o.hashCode()) {
            return 1;
        }
        return 0;
    }

    public void setVisualDepth(int visualDepth) {
        this.visualDepth = visualDepth;
    }

    public int getVisualDepth() {
        return this.visualDepth;
    }

    public boolean isPass() {
        return !this.isPlacementMove() && "tt".equals(this.getMoveString());
    }

    public boolean isPlacementMove() {
        return this.properties.get("W") == null && this.properties.get("B") == null && (this.properties.get("AB") != null || this.properties.get("AW") != null);
    }

    public void setNodeNo(int nodeNo) {
        this.nodeNo = nodeNo;
    }

    public int getNodeNo() {
        return this.nodeNo;
    }

    public String getSgfComment() {
        return this.properties.getOrDefault("C", "");
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        String parentHashcode = "";
        if (this.getParentNode() != null) {
            parentHashcode = "parentNode: " + this.getParentNode().hashCode();
        }
        return "Props: keys=" + this.properties.keySet().toString() + " all=" + this.properties.toString() + " moveNo: " + this.moveNo + " children: " + this.children.size() + " vdepth: " + this.visualDepth + parentHashcode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + this.moveNo;
        result = 31 * result + this.id;
        result = 31 * result + (this.parentNode == null ? 0 : this.parentNode.properties.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + this.visualDepth;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GameNode other = (GameNode)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        if (this.moveNo != other.moveNo) {
            return false;
        }
        if (this.parentNode == null ? other.parentNode != null : !this.parentNode.equals(other.parentNode)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.visualDepth != other.visualDepth) {
            return false;
        }
        return this.id == other.id;
    }
}

