/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j.parser;

import com.toomasr.sgf4j.parser.GameNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Util {
    public static final String[] alphabet = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T"};
    public static final Map<String, Integer> alphaToCoord = new HashMap<String, Integer>(){
        {
            this.put("a", 0);
            this.put("b", 1);
            this.put("c", 2);
            this.put("d", 3);
            this.put("e", 4);
            this.put("f", 5);
            this.put("g", 6);
            this.put("h", 7);
            this.put("i", 8);
            this.put("j", 9);
            this.put("k", 10);
            this.put("l", 11);
            this.put("m", 12);
            this.put("n", 13);
            this.put("o", 14);
            this.put("p", 15);
            this.put("q", 16);
            this.put("r", 17);
            this.put("s", 18);
            this.put("t", 19);
        }
    };
    public static final Map<Integer, String> coordToAlpha = new HashMap<Integer, String>(){
        {
            this.put(0, "a");
            this.put(1, "b");
            this.put(2, "c");
            this.put(3, "d");
            this.put(4, "e");
            this.put(5, "f");
            this.put(6, "g");
            this.put(7, "h");
            this.put(8, "i");
            this.put(9, "j");
            this.put(10, "k");
            this.put(11, "l");
            this.put(12, "m");
            this.put(13, "n");
            this.put(14, "o");
            this.put(15, "p");
            this.put(16, "q");
            this.put(17, "r");
            this.put(18, "s");
            this.put(19, "t");
        }
    };

    private Util() {
    }

    public static void printNodeTree(GameNode rootNode) {
        if (rootNode.hasChildren()) {
            Set<GameNode> children = rootNode.getChildren();
            for (GameNode node : children) {
                Util.printNodeTree(node);
            }
        }
    }

    public static int[] alphaToCoords(String input) {
        if (input == null || input.length() < 2) {
            throw new RuntimeException("Coordinate cannot be less than 2 characters. Input '" + input + "'");
        }
        return new int[]{alphaToCoord.get(input.charAt(0) + ""), alphaToCoord.get(input.charAt(1) + "")};
    }

    public static Map<String, String> extractLabels(String str) {
        HashMap<String, String> rtrn = new HashMap<String, String>();
        if (str == null) {
            return rtrn;
        }
        String[] labels = str.split("\\]\\[");
        for (int i = 0; i < labels.length; ++i) {
            String[] label = labels[i].split(":");
            rtrn.put(label[0], label[1]);
        }
        return rtrn;
    }

    public static String[] coordSequencesToSingle(String addBlack) {
        ArrayList<String> rtrn = new ArrayList<String>();
        String[] blackStones = addBlack.split(",");
        for (int i = 0; i < blackStones.length; ++i) {
            if (blackStones[i].contains(":")) {
                int j;
                String[] seq = blackStones[i].split(":");
                if (seq[0].charAt(0) == seq[1].charAt(0)) {
                    for (j = alphaToCoord.get(new StringBuilder().append(seq[0].charAt(1)).append("").toString()).intValue(); j <= alphaToCoord.get(seq[1].charAt(1) + ""); ++j) {
                        rtrn.add(seq[0].charAt(0) + coordToAlpha.get(j));
                    }
                    continue;
                }
                for (j = alphaToCoord.get(new StringBuilder().append(seq[0].charAt(0)).append("").toString()).intValue(); j <= alphaToCoord.get(seq[1].charAt(0) + ""); ++j) {
                    rtrn.add(coordToAlpha.get(j) + seq[0].charAt(1));
                }
                continue;
            }
            rtrn.add(blackStones[i]);
        }
        return rtrn.toArray(new String[0]);
    }

    public static String sgfEscapeText(String input) {
        input = input.replaceAll("\\\\\\[", "@@@@@");
        input = input.replaceAll("\\\\\\]", "#####");
        input = input.replaceAll(":", "\\\\:");
        input = input.replaceAll("\\]", "\\\\]");
        input = input.replaceAll("\\[", "\\\\[");
        return input;
    }

    public static String sgfUnescapeText(String input) {
        input = input.replaceAll("@@@@@", "\\\\\\[");
        input = input.replaceAll("#####", "\\\\\\]");
        input = input.replaceAll("\\\\\n", "");
        input = input.replaceAll("\\\\:", ":");
        input = input.replaceAll("\\\\\\]", "]");
        input = input.replaceAll("\\\\\\[", "[");
        return input;
    }
}

