/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j.parser;

import com.toomasr.sgf4j.parser.GameNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VisualDepthHelper {
    private List<List<Integer>> depthMatrix;

    public void calculateVisualDepth(GameNode lastNode, int variationDepth) {
        if (lastNode == null) {
            return;
        }
        ArrayList<List<Integer>> depthMatrix = new ArrayList<List<Integer>>();
        this.initializeMainLine(lastNode, depthMatrix);
        GameNode activeNode = lastNode;
        do {
            if (!activeNode.hasChildren()) continue;
            Iterator<GameNode> ite = activeNode.getChildren().iterator();
            while (ite.hasNext()) {
                this.calculateVisualDepthFor(ite.next(), depthMatrix, 1, ++variationDepth);
            }
        } while ((activeNode = activeNode.getPrevNode()) != null);
        this.depthMatrix = depthMatrix;
    }

    private void calculateVisualDepthFor(GameNode node, List<List<Integer>> depthMatrix, int minDepth, int variationDepth) {
        GameNode lastNodeInLine;
        int depth = this.findVisualDepthForNode(node, depthMatrix, minDepth, variationDepth);
        GameNode activeNode = lastNodeInLine = this.setVisualDepthForLine(node, depth);
        do {
            if (!activeNode.hasChildren()) continue;
            Iterator<GameNode> ite = activeNode.getChildren().iterator();
            while (ite.hasNext()) {
                this.calculateVisualDepthFor(ite.next(), depthMatrix, depth + 1, variationDepth);
            }
        } while (!activeNode.equals(node) && (activeNode = activeNode.getPrevNode()) != null);
    }

    private void initializeMainLine(GameNode lastNode, List<List<Integer>> depthMatrix) {
        ArrayList<Integer> firstLine = new ArrayList<Integer>();
        for (int i = 0; i <= lastNode.getMoveNo(); ++i) {
            firstLine.add(i, 0);
        }
        depthMatrix.add(0, firstLine);
        GameNode node = lastNode;
        do {
            if (!node.isMove()) continue;
            firstLine.set(node.getMoveNo(), 1);
            node.setVisualDepth(0);
        } while ((node = node.getPrevNode()) != null);
    }

    protected GameNode setVisualDepthForLine(GameNode child, int depth) {
        GameNode node = child;
        GameNode rtrn = child;
        do {
            node.setVisualDepth(depth);
            rtrn = node;
        } while ((node = node.getNextNode()) != null);
        return rtrn;
    }

    protected int findVisualDepthForNode(GameNode node, List<List<Integer>> depthMatrix, int minDepth, int variationDepth) {
        int length = this.findLengthOfLine(node);
        int depthDelta = minDepth;
        while (true) {
            boolean available;
            if (depthMatrix.size() <= depthDelta) {
                for (int i = depthMatrix.size(); i <= depthDelta; ++i) {
                    depthMatrix.add(i, new ArrayList());
                }
            }
            if (available = this.isAvailableForLineOfPlay(node, length, depthMatrix, depthDelta, variationDepth)) break;
            ++depthDelta;
        }
        this.bookForLineOfPlay(node, length, depthMatrix, depthDelta, variationDepth);
        return depthDelta;
    }

    protected void bookForLineOfPlay(GameNode node, int length, List<List<Integer>> depthMatrix, int listIndex, int variationDepth) {
        int i;
        List<Integer> levelList = depthMatrix.get(listIndex);
        int start = 0;
        if (node.getMoveNo() > 0) {
            start = node.getMoveNo() - 1;
        }
        for (i = start; i < node.getMoveNo() + length; ++i) {
            levelList.set(i, 1);
        }
        for (i = listIndex - 1; i > 0; --i) {
            List<Integer> tmpLevelList = depthMatrix.get(i);
            this.expandListIfNeeded(tmpLevelList, start);
            if (tmpLevelList.get(start) == 1) break;
            tmpLevelList.set(start, 1);
        }
    }

    private void expandListIfNeeded(List<Integer> tmpLevelList, int upperBound) {
        if (tmpLevelList.size() > upperBound) {
            return;
        }
        for (int i = tmpLevelList.size(); i <= upperBound; ++i) {
            tmpLevelList.add(i, 0);
        }
    }

    protected boolean isAvailableForLineOfPlay(GameNode node, int length, List<List<Integer>> depthMatrix, int listIndex, int variationDepth) {
        List<Integer> levelList = depthMatrix.get(listIndex);
        if (levelList.size() <= node.getMoveNo() || node.getMoveNo() == -1) {
            for (int i = levelList.size(); i <= node.getMoveNo() + length; ++i) {
                levelList.add(i, 0);
            }
        }
        Integer marker = 0;
        if (node.getMoveNo() > 1) {
            marker = node.getMoveNo() - 1;
        }
        for (int i = marker.intValue(); i < node.getMoveNo() + length; ++i) {
            Integer localMarker = levelList.get(i);
            if (localMarker != 1) continue;
            return false;
        }
        return true;
    }

    public void printDepthMatrix() {
        for (List<Integer> list : this.depthMatrix) {
            System.out.println(list);
        }
    }

    protected int findLengthOfLine(GameNode node) {
        GameNode tmpNode = node;
        int i = 0;
        do {
            ++i;
        } while ((tmpNode = tmpNode.getNextNode()) != null);
        return i;
    }
}

